/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.shield;

import xander.cat.group.shield.BulletShieldingController;
import xander.cat.group.shield.BulletShieldingDrive;
import xander.cat.group.shield.BulletShieldingGun;
import xander.cat.group.shield.BulletShieldingScenario;
import xander.cat.group.shield.BulletTargeter;
import xander.cat.group.shield.M1BulletTargeter;
import xander.cat.group.shield.M1TBulletTargeter;
import xander.core.ComponentChain;

public class BulletShieldingFactory {
    public static BulletTargeter[] getCommonBulletTargeters() {
        return new BulletTargeter[]{new M1BulletTargeter(), new M1TBulletTargeter()};
    }

    public static BulletShieldingScenario addBulletShieldingComponents(ComponentChain chain, int roundActivationTime, double maxAdjustedFirePower, boolean temporarilyDisableOnShieldingMiss, boolean allowFinishingShot) {
        BulletShieldingDrive bulletShieldingDrive = new BulletShieldingDrive();
        BulletShieldingController bulletShieldingController = new BulletShieldingController(bulletShieldingDrive);
        BulletShieldingGun bulletShieldingGun = null;
        bulletShieldingGun = maxAdjustedFirePower < 0.1 ? new BulletShieldingGun(bulletShieldingController, BulletShieldingFactory.getCommonBulletTargeters()) : new BulletShieldingGun(bulletShieldingController, maxAdjustedFirePower, BulletShieldingFactory.getCommonBulletTargeters());
        bulletShieldingGun.setAllowFinishingShot(allowFinishingShot);
        BulletShieldingScenario bulletShieldingScenario = new BulletShieldingScenario(bulletShieldingController, bulletShieldingGun, roundActivationTime, temporarilyDisableOnShieldingMiss);
        chain.addComponents(bulletShieldingScenario, bulletShieldingDrive, bulletShieldingGun);
        return bulletShieldingScenario;
    }

    public static void addBulletShieldingComponentsAsDefault(ComponentChain chain, double maxAdjustedFirePower, boolean allowFinishingShot) {
        BulletShieldingDrive bulletShieldingDrive = new BulletShieldingDrive();
        BulletShieldingController bulletShieldingController = new BulletShieldingController(bulletShieldingDrive);
        BulletShieldingGun bulletShieldingGun = null;
        bulletShieldingGun = maxAdjustedFirePower < 0.1 ? new BulletShieldingGun(bulletShieldingController, BulletShieldingFactory.getCommonBulletTargeters()) : new BulletShieldingGun(bulletShieldingController, maxAdjustedFirePower, BulletShieldingFactory.getCommonBulletTargeters());
        bulletShieldingGun.setAllowFinishingShot(allowFinishingShot);
        chain.addDefaultComponents(bulletShieldingDrive, bulletShieldingGun);
    }
}

