/*
 * Decompiled with CFR 0.152.
 */
package xander.core;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import xander.core.ComponentChain;
import xander.core.ComponentSet;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotStyle;
import xander.core.drive.DriveController;
import xander.core.gun.DisabledRobotGun;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.io.BattleStats;
import xander.core.io.FileIO;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.paint.CPUUtilizationGraphData;
import xander.core.radar.RadarController;
import xander.core.track.RunTimeLogger;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.paint.Paintables;
import xander.util.MissedTurnSimulator;

public abstract class AbstractXanderRobot
extends AdvancedRobot {
    public static final String STATS_KEY_TOTAL_BATTLES = "AXR:Total Battles";
    private static final Log log = Logger.getLog(AbstractXanderRobot.class);
    private static final ComponentChain componentChain = new ComponentChain();
    private static Gun disabledRobotGun;
    private static RunTimeLogger radarRTLogger;
    private static RunTimeLogger driveRTLogger;
    private static RunTimeLogger gunRTLogger;
    private static RunTimeLogger scannedRobotRTLogger;
    private static int skippedTurns;
    private static CPUUtilizationGraphData cpuUtilizationGraphData;
    private RobotEvents robotEvents = Resources.getRobotEvents();
    private RadarController radarController;
    private DriveController driveController;
    private GunController gunController;
    private SnapshotHistory snapshotHistory;
    private Rectangle2D.Double battleFieldSize;
    private ComponentSet componentSet;
    private boolean usingDisabledRobotGun;
    private MissedTurnSimulator missedTurnSimulator;

    protected void style(RobotStyle robotStyle) {
    }

    protected void configure(Configuration configuration) {
    }

    protected boolean recordBattleStats(Map<String, String> oppStats, int totalBattlesAgainstOpponent) {
        return false;
    }

    protected boolean recordCommonBattleStats(Map<String, String> commonStats, int totalBattles) {
        return false;
    }

    protected abstract void addComponents(ComponentChain var1);

    public void onCustomEvent(CustomEvent event) {
        super.onCustomEvent(event);
        this.robotEvents.onCustomEvent(event);
    }

    public void onDeath(DeathEvent event) {
        super.onDeath(event);
        this.robotEvents.onDeath(event);
        Resources.onWinOrDeath();
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        super.onSkippedTurn(event);
        ++skippedTurns;
        this.robotEvents.onSkippedTurn(event);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        BattleStats battleStats;
        super.onBattleEnded(event);
        this.robotEvents.onBattleEnded(event);
        if (skippedTurns > 0) {
            FileIO.logSkippedTurns(this, skippedTurns);
        }
        if (this.snapshotHistory.getOpponentCount() == 1 && (battleStats = FileIO.getBattleStats(Resources.getConfiguration())) != null && this.snapshotHistory.getLastOpponentScanned() != null) {
            String opponentName = this.snapshotHistory.getLastOpponentScanned().getName();
            Map<String, String> oppStats = battleStats.getStatsForRobot(opponentName, true);
            Map<String, String> commonStats = battleStats.getCommonStats();
            int totalBattlesAgainstOpp = 1;
            String totalBattlesAgainstOppStored = oppStats.get(STATS_KEY_TOTAL_BATTLES);
            if (totalBattlesAgainstOppStored != null) {
                try {
                    totalBattlesAgainstOpp += Integer.parseInt(totalBattlesAgainstOppStored);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            oppStats.put(STATS_KEY_TOTAL_BATTLES, String.valueOf(totalBattlesAgainstOpp));
            int totalBattles = 1;
            String totalBattlesStored = commonStats.get(STATS_KEY_TOTAL_BATTLES);
            if (totalBattlesStored != null) {
                try {
                    totalBattles += Integer.parseInt(totalBattlesStored);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            commonStats.put(STATS_KEY_TOTAL_BATTLES, String.valueOf(totalBattles));
            boolean oppStatsUpdated = this.recordBattleStats(oppStats, totalBattlesAgainstOpp);
            boolean commonStatsUpdated = this.recordCommonBattleStats(commonStats, totalBattles);
            if (Resources.getConfiguration().isSaveComponentRunTimesCommon()) {
                commonStatsUpdated = true;
                driveRTLogger.saveTo(commonStats, totalBattles);
                gunRTLogger.saveTo(commonStats, totalBattles);
                radarRTLogger.saveTo(commonStats, totalBattles);
            }
            if (Resources.getConfiguration().isSaveComponentRunTimesIndividual()) {
                driveRTLogger.saveTo(oppStats, totalBattlesAgainstOpp);
                gunRTLogger.saveTo(oppStats, totalBattlesAgainstOpp);
                radarRTLogger.saveTo(oppStats, totalBattlesAgainstOpp);
            }
            if (oppStatsUpdated || commonStatsUpdated) {
                log.info("Updating battle statistics...");
                FileIO.saveBattleStats();
                log.info("Battle statistics updated.");
            }
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        super.onBulletHit(event);
        this.robotEvents.onBulletHit(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        super.onBulletHitBullet(event);
        this.robotEvents.onBulletHitBullet(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        super.onBulletMissed(event);
        this.robotEvents.onBulletMissed(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        super.onHitByBullet(event);
        this.robotEvents.onHitByBullet(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        super.onHitRobot(event);
        this.robotEvents.onHitRobot(event);
    }

    public void onHitWall(HitWallEvent event) {
        super.onHitWall(event);
        this.robotEvents.onHitWall(event);
    }

    public void onKeyPressed(KeyEvent e) {
        super.onKeyPressed(e);
        this.robotEvents.onKeyPressed(e);
    }

    public void onKeyReleased(KeyEvent e) {
        super.onKeyReleased(e);
        this.robotEvents.onKeyReleased(e);
    }

    public void onKeyTyped(KeyEvent e) {
        super.onKeyTyped(e);
        this.robotEvents.onKeyTyped(e);
    }

    public void onMouseClicked(MouseEvent e) {
        super.onMouseClicked(e);
        this.robotEvents.onMouseClicked(e);
    }

    public void onMouseDragged(MouseEvent e) {
        super.onMouseDragged(e);
        this.robotEvents.onMouseDragged(e);
    }

    public void onMouseEntered(MouseEvent e) {
        super.onMouseEntered(e);
        this.robotEvents.onMouseEntered(e);
    }

    public void onMouseExited(MouseEvent e) {
        super.onMouseExited(e);
        this.robotEvents.onMouseExited(e);
    }

    public void onMouseMoved(MouseEvent e) {
        super.onMouseMoved(e);
        this.robotEvents.onMouseMoved(e);
    }

    public void onMousePressed(MouseEvent e) {
        super.onMousePressed(e);
        this.robotEvents.onMousePressed(e);
    }

    public void onMouseReleased(MouseEvent e) {
        super.onMouseReleased(e);
        this.robotEvents.onMouseReleased(e);
    }

    public void onMouseWheelMoved(MouseWheelEvent e) {
        super.onMouseWheelMoved(e);
        this.robotEvents.onMouseWheelMoved(e);
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        this.robotEvents.onPaint(g);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        super.onRobotDeath(event);
        this.robotEvents.onRobotDeath(event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        super.onRoundEnded(event);
        this.robotEvents.onRoundEnded(event);
        Resources.endRound();
        if (skippedTurns > 0) {
            log.warn("Skipped turns so far: " + skippedTurns);
        }
        RunTimeLogger.logAll();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        scannedRobotRTLogger.start();
        super.onScannedRobot(event);
        this.robotEvents.onScannedRobot(event);
        scannedRobotRTLogger.stop();
    }

    public void onStatus(StatusEvent e) {
        super.onStatus(e);
        this.robotEvents.onStatus(e);
    }

    public void onWin(WinEvent event) {
        super.onWin(event);
        this.robotEvents.onWin(event);
        Resources.onWinOrDeath();
    }

    public Rectangle2D.Double getBattleFieldSize() {
        return this.battleFieldSize;
    }

    public int getSkippedTurns() {
        return skippedTurns;
    }

    public String getActiveRadarName() {
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.radar == null) {
            return "None";
        }
        return this.componentSet.radar.getName();
    }

    public String getActiveGunName() {
        if (this.usingDisabledRobotGun) {
            return disabledRobotGun.getName();
        }
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.gun == null) {
            return "None";
        }
        return this.componentSet.gun.getName();
    }

    public String getActiveDriveName() {
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.drive == null) {
            return "None";
        }
        return this.componentSet.drive.getName();
    }

    private void initialize() {
        log.info("Configuring robot...");
        Resources.getRobotProxy().setRobot(this);
        Configuration configuration = Resources.getConfiguration();
        this.style(Resources.getRobotStyle());
        this.configure(configuration);
        Resources.initialize(this, componentChain);
        if (configuration.isAutoFireOnDisabledOpponents()) {
            disabledRobotGun = new DisabledRobotGun(configuration);
        }
        log.info("Setting up component chain...");
        this.addComponents(componentChain);
        radarRTLogger = RunTimeLogger.getLoggerFor("Radar");
        driveRTLogger = RunTimeLogger.getLoggerFor("Drive");
        gunRTLogger = RunTimeLogger.getLoggerFor("Gun");
        scannedRobotRTLogger = RunTimeLogger.getLoggerFor("ScannedRobotEvent");
        if (!(configuration.isLogComponentRunTimes() || configuration.isSaveComponentRunTimesCommon() || configuration.isSaveComponentRunTimesIndividual())) {
            radarRTLogger.setActive(false);
            driveRTLogger.setActive(false);
            gunRTLogger.setActive(false);
        }
        if (!configuration.isLogScannedRobotEventTime()) {
            scannedRobotRTLogger.setActive(false);
        }
        int dataPoints = configuration.getCPUUtilizationDataPoints();
        cpuUtilizationGraphData = new CPUUtilizationGraphData(dataPoints);
        if (configuration.getCpuConstantMS() != null) {
            cpuUtilizationGraphData.setCPUConstant(configuration.getCpuConstantMS());
        }
        Paintables.addPaintable(cpuUtilizationGraphData);
        if (configuration.getMissedTurnRanges() != null) {
            log.warn("Simulating missed turns for this battle!");
            this.missedTurnSimulator = new MissedTurnSimulator(configuration.getMissedTurnRanges());
        }
        log.info("Loading previous battle statistics...");
        FileIO.loadBattleStats(configuration);
        log.info("Ready for battle!");
    }

    public void run() {
        try {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.battleFieldSize = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
            if (this.getRoundNum() == 0) {
                this.initialize();
            }
            Resources.beginRound(this);
            Resources.getRobotStyle().apply((Robot)this);
            this.snapshotHistory = Resources.getSnapshotHistory();
            this.radarController = Resources.getRadarController();
            this.driveController = Resources.getDriveController();
            this.gunController = Resources.getGunController();
            this.componentSet = new ComponentSet();
            this.usingDisabledRobotGun = false;
            this.robotEvents.onRoundBegin();
            while (true) {
                if (this.missedTurnSimulator != null && this.missedTurnSimulator.isTurnToBeMissed()) {
                    log.info("Intentionally skipping turn " + this.getTime());
                    this.onSkippedTurn(new SkippedTurnEvent(this.getTime()));
                    this.execute();
                    continue;
                }
                if (cpuUtilizationGraphData != null) {
                    cpuUtilizationGraphData.onTurnBegin();
                }
                this.robotEvents.onTurnBegin();
                componentChain.loadComponents(this.componentSet);
                Snapshot targetRobot = null;
                if (this.componentSet.radar != null) {
                    radarRTLogger.start();
                    targetRobot = this.componentSet.radar.search(this.radarController);
                    radarRTLogger.stop();
                }
                if (targetRobot == null) {
                    if (this.componentSet.drive != null) {
                        driveRTLogger.start();
                        this.componentSet.drive.drive(this.driveController);
                        driveRTLogger.stop();
                    }
                } else {
                    if (this.componentSet.drive != null) {
                        driveRTLogger.start();
                        this.componentSet.drive.driveTo(targetRobot, this.driveController);
                        driveRTLogger.stop();
                    }
                    if (this.componentSet.gun != null) {
                        Snapshot myself = this.snapshotHistory.getMySnapshot(targetRobot.getTime(), true);
                        if (targetRobot.getEnergy() <= 0.0 && disabledRobotGun != null && disabledRobotGun.canFireAt(targetRobot)) {
                            this.usingDisabledRobotGun = true;
                            disabledRobotGun.fireAt(targetRobot, myself, this.gunController);
                        } else {
                            this.usingDisabledRobotGun = false;
                            if (this.componentSet.gun.canFireAt(targetRobot)) {
                                gunRTLogger.start();
                                this.componentSet.gun.fireAt(targetRobot, myself, this.gunController);
                                gunRTLogger.stop();
                            } else {
                                double oppHeading = RCMath.getRobocodeAngle(myself.getLocation(), targetRobot.getLocation());
                                double turn = RCMath.getTurnAngle(this.getGunHeading(), oppHeading);
                                this.gunController.setTurnGunRightDegrees(turn);
                            }
                        }
                    }
                }
                this.robotEvents.onTurnEnd();
                if (cpuUtilizationGraphData != null) {
                    cpuUtilizationGraphData.onTurnEnd();
                }
                this.execute();
            }
        }
        catch (Exception e) {
            Resources.endRound();
            FileIO.logException(this, e);
            return;
        }
    }
}

