/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import xander.core.Resources;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.segment.Segmenter;

public class DefenderAccelerationSegmenter
implements Segmenter {
    private String myRobotName = Resources.getRobotProxy().getName();

    @Override
    public String getName() {
        return "Defender Acceleration Segmenter";
    }

    private Accel getAccel(Wave wave) {
        double ps;
        SnapshotHistory history = Resources.getSnapshotHistory();
        Snapshot defenderSnapshot = wave.getInitialDefenderSnapshot();
        Snapshot previousDefenderSnapshot = null;
        previousDefenderSnapshot = defenderSnapshot.getName().equals(this.myRobotName) ? history.getMySnapshot(defenderSnapshot.getTime() - 1L, false) : history.getSnapshot(defenderSnapshot.getName(), defenderSnapshot.getTime() - 1L, false);
        double s = defenderSnapshot.getVelocity();
        double d = ps = previousDefenderSnapshot == null ? s : previousDefenderSnapshot.getVelocity();
        if (s == ps) {
            return Accel.STEADY_SPEED;
        }
        if (s > 0.0 && ps < 0.0 || s < 0.0 && ps > 0.0 || Math.abs(s) > Math.abs(ps)) {
            return Accel.ACCELERATING;
        }
        return Accel.DECELERATING;
    }

    @Override
    public double getSegmentValue(Wave wave) {
        return this.getAccel(wave).ordinal();
    }

    @Override
    public double getSegmentValuePercent(Wave wave) {
        Accel accel = this.getAccel(wave);
        switch (accel) {
            case STEADY_SPEED: {
                return 0.5;
            }
            case DECELERATING: {
                return 0.0;
            }
        }
        return 1.0;
    }

    @Override
    public String getSegmentValueDescription(double segmentValue) {
        int ord = (int)Math.round(segmentValue);
        return Accel.values()[ord].toString();
    }

    private static enum Accel {
        STEADY_SPEED,
        ACCELERATING,
        DECELERATING;

    }
}

