/*
 * Decompiled with CFR 0.152.
 */
package vStar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.TreeMap;
import robocode.Rules;
import vStar.EnergyDeltaStatistics;
import vStar.LinearEquation;
import vStar.MathMethods;
import vStar.PointCommon;
import vStar.PointRelativelyLocated;
import vStar.PointThatMoves;
import vStar.RAFzilla;
import vStar.TankCommon;

class TankEnemy
extends TankCommon {
    private RAFzilla zilla_tank;
    private PointRelativelyLocated refreshed_location;
    private LinearEquation move_equation;
    private double last_heading_seen;
    private double last_speed_seen;
    public EnergyDeltaStatistics stat_per_distance;
    private int time_not_refresh;
    int times_position_not_predicted = 0;
    public Map<Long, PointCommon> movement_history = new TreeMap<Long, PointCommon>();
    private double distance2main;

    public int get_time_not_refresh() {
        return this.time_not_refresh;
    }

    public double get_distance2main() {
        return this.distance2main;
    }

    public TankEnemy(RAFzilla tank, EnergyDeltaStatistics last_stats) {
        this.zilla_tank = tank;
        this.refreshed_location = new PointRelativelyLocated(this.zilla_tank);
        this.stat_per_distance = new EnergyDeltaStatistics(this.zilla_tank.BORDER_PVP_MID, this.zilla_tank.BORDER_MID_FAR, last_stats);
    }

    public void renew_movement_data(double bear, double distance, double naprav, double skor, Long time_captured) {
        this.refreshed_location.set_relative_location(distance, bear);
        this.refreshed_location.refresh_location();
        if (this.time_not_refresh == 0) {
            this.set_location(this.refreshed_location);
        }
        if (this.time_not_refresh != 0 && 0.1 < this.get_distance_to(this.refreshed_location)) {
            ++this.times_position_not_predicted;
            if (naprav != 0.0 || skor != 0.0) {
                this.rotation_speed = MathMethods.normalize_rads(naprav - this.last_heading_seen) / (double)this.time_not_refresh;
                this.acceleration = (skor - this.last_speed_seen) / (double)this.time_not_refresh;
                if (this.acceleration < -2.0) {
                    this.acceleration = 0.0;
                }
            } else {
                this.rotation_speed = 0.0;
                this.acceleration = 0.0;
            }
            this.set_location(this.refreshed_location);
        }
        this.last_heading_seen = naprav;
        this.last_speed_seen = skor;
        this.heading = naprav;
        this.speed = skor;
        this.movement_history.put(time_captured, new PointCommon(this));
        this.time_not_refresh = 0;
    }

    public void rotate_accelerate_move(Long time) {
        super.rotate_accelerate_move();
        this.movement_history.put(time, new PointCommon(this));
        this.distance2main = this.get_distance_to(new PointCommon(this.zilla_tank));
        ++this.time_not_refresh;
    }

    public double prediction_ratio() {
        return (double)this.times_position_not_predicted / (double)this.movement_history.size();
    }

    public boolean is_robot_predictable() {
        return this.prediction_ratio() < 0.1;
    }

    public void draw_point(Graphics2D graf) {
        super.draw_point(graf, Color.red, 3);
        if (this.move_equation != null) {
            this.move_equation.draw(graf);
        }
    }

    public int reason_rotate_radar_right() {
        if (this.time_not_refresh == 0) {
            return 0;
        }
        double angle = new PointCommon(this.zilla_tank).get_heading(this);
        angle = (angle = MathMethods.normalize_rads(angle - this.zilla_tank.getRadarHeadingRadians())) > 0.0 ? 1 : -1;
        return (int)angle * this.time_not_refresh * 5;
    }

    public double reason_rotate_gun_right(double power, long curren_time) {
        double angle;
        TankCommon myTank = this.zilla_tank.as_common_tank();
        TankCommon enemy = new TankCommon(this);
        myTank.rotate_accelerate_move();
        double used_enemy_speed = this.speed;
        boolean predictable_now = this.is_robot_predictable();
        if (!predictable_now) {
            enemy.patch4averaged_movement_calculation(this, curren_time);
            used_enemy_speed = enemy.speed;
            this.move_equation = enemy.speed == 0.0 ? null : new LinearEquation(enemy, this.zilla_tank);
        } else {
            this.move_equation = this.speed != 0.0 ? new LinearEquation(this, this.zilla_tank) : null;
        }
        if (used_enemy_speed == 0.0) {
            angle = myTank.get_heading(enemy);
        } else if (this.rotation_speed != 0.0 && 125.0 < this.distance2main && predictable_now) {
            double framesWait = myTank.get_distance_to(enemy) / Rules.getBulletSpeed((double)power);
            int deep = 0;
            while ((double)deep < framesWait) {
                enemy.rotate_accelerate_move();
                if (!enemy.is_in_battle_field(this.zilla_tank)) {
                    enemy = new TankCommon(this);
                    break;
                }
                ++deep;
            }
            angle = myTank.get_heading(enemy);
        } else {
            enemy.calc_move();
            LinearEquation perpendikular = this.move_equation.create_perpendicular(myTank);
            PointCommon crossPoint = this.move_equation.get_point_lines_crosses(perpendikular);
            double s = enemy.get_distance_to(crossPoint);
            double d = myTank.get_distance_to(crossPoint);
            double bulletSpeed = Rules.getBulletSpeed((double)power);
            double above = Math.sqrt(bulletSpeed * bulletSpeed * d * d + bulletSpeed * bulletSpeed * s * s - d * d * used_enemy_speed * used_enemy_speed);
            double below = bulletSpeed * bulletSpeed - used_enemy_speed * used_enemy_speed;
            double absSpeed = Math.abs(used_enemy_speed);
            if (enemy.is_getting_closer(crossPoint)) {
                double timeCatchBefore = (above - absSpeed * s) / below;
                enemy.move_x_times(timeCatchBefore);
            } else {
                double timeCatchAfter = (above + absSpeed * s) / below;
                enemy.move_x_times(timeCatchAfter);
            }
            angle = enemy.is_in_battle_field(this.zilla_tank) ? myTank.get_heading(enemy) : myTank.get_heading(this);
        }
        return MathMethods.normalize_rads(angle - this.zilla_tank.getGunHeadingRadians() - myTank.rotation_speed);
    }

    public double reason_shot_with_power(double power, long curren_time) {
        return this.reason_shot_with_power(power, curren_time, false);
    }

    public double reason_shot_with_power(double power, long curren_time, boolean power_is_presize) {
        PointThatMoves bullet = new PointThatMoves(this.zilla_tank, Rules.getBulletSpeed((double)power), this.zilla_tank.getGunHeadingRadians());
        double ENEMY_WIDTH = power_is_presize ? this.zilla_tank.getWidth() : this.zilla_tank.getWidth() / 2.0;
        LinearEquation bullet_way = new LinearEquation(bullet, this.zilla_tank);
        if (!bullet.is_getting_closer(this)) {
            return 0.0;
        }
        double used_enemy_speed = this.speed;
        TankCommon enemy = new TankCommon(this);
        boolean predictable_now = this.is_robot_predictable();
        if (!predictable_now) {
            enemy.patch4averaged_movement_calculation(this, curren_time);
            used_enemy_speed = enemy.speed;
        }
        if (used_enemy_speed == 0.0) {
            if (bullet_way.get_distance_from_line2point(this) < this.zilla_tank.getWidth() / 2.0) {
                return power;
            }
        } else {
            PointCommon cross_point;
            if (this.rotation_speed != 0.0 && predictable_now) {
                double closestDistance = 1000000.0;
                PointCommon closestPoint = new PointCommon(this);
                boolean goingTo = false;
                int deep = -1;
                while (deep < 70) {
                    enemy.rotate_accelerate_move();
                    if (!enemy.is_in_battle_field(this.zilla_tank)) {
                        return 0.0;
                    }
                    double tempDistance = bullet_way.get_distance_from_line2point(enemy);
                    if (tempDistance < closestDistance) {
                        if (closestDistance != 1000000.0) {
                            goingTo = true;
                        }
                        closestDistance = tempDistance;
                        closestPoint = new PointCommon(enemy);
                    } else if (goingTo) {
                        double bulletPower;
                        if (closestDistance > this.zilla_tank.getWidth()) {
                            return 0.0;
                        }
                        if (power_is_presize) {
                            bullet.move_x_times(deep);
                            if (bullet.get_distance_to(closestPoint) < ENEMY_WIDTH) {
                                return power;
                            }
                            bulletPower = 0.0;
                        } else {
                            bulletPower = MathMethods.bullet_velocity2power(new PointCommon(this.zilla_tank).get_distance_to(closestPoint) / (double)deep);
                        }
                        if (bulletPower != 0.0) {
                            return bulletPower;
                        }
                        goingTo = false;
                    }
                    ++deep;
                }
                return 0.0;
            }
            if (this.move_equation == null) {
                this.move_equation = new LinearEquation(enemy, this.zilla_tank);
            }
            if ((cross_point = bullet_way.get_point_lines_crosses(this.move_equation)).get_x() == Double.NaN && cross_point.get_y() == Double.NaN) {
                System.out.println("Rare place 1");
                return 0.0;
            }
            if (cross_point.get_x() == Double.POSITIVE_INFINITY && cross_point.get_y() == Double.POSITIVE_INFINITY) {
                return power;
            }
            if (cross_point.is_in_battle_field(this.zilla_tank)) {
                if (enemy.is_getting_closer(cross_point)) {
                    double frames2reach;
                    double enemy2cross = this.get_distance_to(cross_point);
                    if (enemy.acceleration == 0.0) {
                        frames2reach = enemy2cross / Math.abs(used_enemy_speed);
                    } else if (this.acceleration * this.speed > 0.0) {
                        double roundedSpeed = Math.round(Math.abs(this.speed));
                        double accelerationDistance = 36.0 - (roundedSpeed + 1.0) * roundedSpeed / 2.0;
                        double framesOnMaxSpeed = (enemy2cross - accelerationDistance) / 8.0;
                        frames2reach = framesOnMaxSpeed < 0.0 ? Math.sqrt(2.0 * enemy2cross + (roundedSpeed + 1.0) * roundedSpeed + 0.25) - 0.25 : framesOnMaxSpeed + (8.0 - roundedSpeed);
                    } else {
                        if (enemy2cross > 6.0) {
                            return 0.0;
                        }
                        frames2reach = enemy2cross > 4.0 ? 3.0 : (enemy2cross > 2.0 ? 2.0 : 1.0);
                    }
                    if (power_is_presize) {
                        bullet.move_x_times(frames2reach);
                        if (bullet.get_distance_to(cross_point) < ENEMY_WIDTH) {
                            return power;
                        }
                        return 0.0;
                    }
                    return MathMethods.bullet_velocity2power(new PointCommon(this.zilla_tank).get_distance_to(cross_point) / frames2reach);
                }
            } else if (bullet_way.get_distance_from_line2point(this) < ENEMY_WIDTH) {
                if (enemy.is_getting_closer(cross_point)) {
                    return power;
                }
                PointCommon pointCommon = new PointCommon(this.zilla_tank);
                if (this.move_equation.get_distance_from_line2point(pointCommon) < ENEMY_WIDTH) {
                    return power;
                }
            }
        }
        return 0.0;
    }
}

