/*
 * Decompiled with CFR 0.152.
 */
package ultra.strategies.guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import robocode.Bullet;
import ultra.core.BotDump;
import ultra.core.LogEntry;
import ultra.core.UltraLogManager;
import ultra.core.Utils;
import ultra.strategies.Gun;

public abstract class AbstractGun
implements Gun {
    private double nbHits = 0.0;
    private final Map<Integer, Bullet> bullets = new HashMap<Integer, Bullet>();
    private long fireTime = 0L;
    private double firePower;
    private Point2D.Double prediction;

    @Override
    public final Point2D.Double run(BotDump r, UltraLogManager log) {
        if (r.getGunHeat() == 0.0 && this.fireTime == r.getTime() && r.getGunTurnRemaining() == 0.0 && this.firePower > 0.0) {
            Bullet b = r.setFireBullet(this.firePower);
            if (b != null) {
                this.bullets.put(this.hashBullet(b), b);
                return this.prediction;
            }
        } else if (r.getGunHeat() < 1.0) {
            this.firePower = this.doFirePower(r, log);
            this.prediction = this.doPrediction(r, log, this.firePower);
            if (this.prediction != null) {
                double headingTo = Utils.fixAngle(Utils.getHeadingTo(r, this.prediction.x, this.prediction.y));
                Utils.rotateGun(r, headingTo);
                this.fireTime = r.getTime() + 1L;
            }
        }
        return null;
    }

    protected double doFirePower(BotDump r, UltraLogManager log) {
        LogEntry latest = log.getLatest();
        double distanceTo = Utils.getDistanceTo(r, latest);
        return Utils.computeFirePower(r, r.getTargetMovingStrat(), distanceTo, this.getEfficiency(), latest.energy);
    }

    protected abstract Point2D.Double doPrediction(BotDump var1, UltraLogManager var2, double var3);

    @Override
    public long getNbShots() {
        return this.bullets.size();
    }

    @Override
    public double getEfficiency() {
        return this.bullets.size() == 0 ? 0.1 : this.nbHits / (double)this.bullets.size();
    }

    @Override
    public String getStats() {
        return "[" + Utils.round(this.getEfficiency() * 100.0, 2) + "%] \t hit/bullets = " + this.nbHits + "/" + this.bullets.size();
    }

    @Override
    public boolean match(Bullet b) {
        if (this.bullets.containsKey(this.hashBullet(b))) {
            this.nbHits += 1.0;
            return true;
        }
        return false;
    }

    private int hashBullet(Bullet b) {
        return new Double(b.getHeading()).hashCode() ^ new Double(b.getPower()).hashCode();
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (this.prediction != null) {
            g.setColor(Color.red);
            Utils.drawMark(g, this.prediction, 5.0);
        }
    }

    @Override
    public void reset() {
        this.nbHits = 0.0;
        this.bullets.clear();
    }
}

