/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.ListIterator;
import starpkg.EnemyData;
import starpkg.EnemyStatus;
import starpkg.Position;
import starpkg.Rect;
import starpkg.StarViewerZ;

public class BattleArea {
    private StarViewerZ robot = null;
    private EnemyStatus enemy = null;
    private double DEFAULT_ADJ_AREA = 50.0;
    public Rect screenArea = new Rect();
    public Rect mainArea = new Rect();
    public Rect centerArea = new Rect();
    public Rect maxArea = new Rect();
    public final int MAX_TOTAL_B_RECT = 16;
    public Rect[] PosArea = new Rect[16];
    public Position[] PosAreaPos = new Position[16];
    public int[] PosAreaEnemy = new int[16];
    public Rect[] statusArea = new Rect[4];
    public Rect centerPointArea = new Rect();
    public Rect[] cornerRect = new Rect[4];
    public Position[] nearCornerPos = new Position[4];
    public double offsetAreaX = 0.0;
    public double offsetAreaY = 0.0;
    public Position centerPos = new Position();

    public BattleArea(StarViewerZ getInst) {
        this.robot = getInst;
        this.enemy = this.robot.enemy;
    }

    public void GetBattleAreaInfo() {
        this.screenArea.Set(new Position(0.0, 0.0), new Position(this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight()));
        this.maxArea.Set(new Position(5.0, 5.0), new Position(this.screenArea.pos2.X - 5.0, this.screenArea.pos2.Y - 5.0));
        this.centerPos.Set(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
        this.mainArea.Set(new Position(this.DEFAULT_ADJ_AREA, this.DEFAULT_ADJ_AREA), new Position(this.screenArea.pos2.X - this.DEFAULT_ADJ_AREA, this.screenArea.pos2.Y - this.DEFAULT_ADJ_AREA));
        this.centerArea.Set(new Position(this.DEFAULT_ADJ_AREA * 2.0, this.DEFAULT_ADJ_AREA * 2.0), new Position(this.screenArea.pos2.X - this.DEFAULT_ADJ_AREA * 2.0, this.screenArea.pos2.Y - this.DEFAULT_ADJ_AREA * 2.0));
        this.centerPointArea.Set(new Position(this.centerPos.X - 300.0, this.centerPos.X - 300.0), new Position(this.centerPos.X + 300.0, this.centerPos.X + 300.0));
        this.nearCornerPos[0] = new Position(this.centerPos.X - 200.0, this.centerPos.Y - 200.0);
        this.nearCornerPos[1] = new Position(this.centerPos.X - 200.0, this.centerPos.Y + 200.0);
        this.nearCornerPos[2] = new Position(this.centerPos.X + 200.0, this.centerPos.Y + 200.0);
        this.nearCornerPos[3] = new Position(this.centerPos.X + 200.0, this.centerPos.Y - 200.0);
        this.SetBattleAreaSp();
    }

    public int CheckMyPosArea(double myX, double myY) {
        if (myX < this.centerPos.X && myY < this.centerPos.Y) {
            return 0;
        }
        if (myX < this.centerPos.X && myY > this.centerPos.Y) {
            return 1;
        }
        if (myX > this.centerPos.X && myY > this.centerPos.Y) {
            return 2;
        }
        return 3;
    }

    public int CheckTargetPosArea(double tX, double tY) {
        int i = 0;
        while (i < 9) {
            if (this.PosArea[i].PointInside(new Position(tX, tY))) {
                return i;
            }
            ++i;
        }
        return 10;
    }

    public void SetBattleAreaSp() {
        int i = 0;
        while (i < 16) {
            this.PosArea[i] = new Rect();
            this.PosAreaPos[i] = new Position();
            ++i;
        }
        double reX = 0.0;
        double reY = 0.0;
        double rX = this.screenArea.pos2.X / 4.0;
        double rY = this.screenArea.pos2.X / 4.0;
        this.offsetAreaX = rX;
        this.offsetAreaY = rY;
        int rectId = 0;
        int i2 = 0;
        while (i2 < 4) {
            reX = 0.0;
            int j = 0;
            while (j < 4) {
                this.PosArea[rectId] = new Rect(new Position(reX, reY), new Position(reX + rX, reY + rY));
                this.PosAreaPos[rectId] = new Position(reX + rX / 2.0, reY + rY / 2.0);
                this.PosArea[rectId].id = rectId;
                ++rectId;
                reX += rX;
                ++j;
            }
            reY += rY;
            ++i2;
        }
        int addCount = 0;
        int i3 = 0;
        while (i3 < 16) {
            addCount = 0;
            int j = 0;
            while (j < 16) {
                if (i3 != j && (this.PosArea[j].pos2.X == this.PosArea[i3].pos1.X && this.PosArea[j].pos2.Y == this.PosArea[i3].pos1.Y || this.PosArea[j].pos2.X == this.PosArea[i3].pos2.X && this.PosArea[j].pos2.Y == this.PosArea[i3].pos1.Y || this.PosArea[j].pos1.X == this.PosArea[i3].pos2.X && this.PosArea[j].pos2.Y == this.PosArea[i3].pos1.Y || this.PosArea[j].pos2.X == this.PosArea[i3].pos1.X && this.PosArea[j].pos1.Y == this.PosArea[i3].pos1.Y || this.PosArea[j].pos1.X == this.PosArea[i3].pos2.X && this.PosArea[j].pos1.Y == this.PosArea[i3].pos1.Y || this.PosArea[j].pos2.X == this.PosArea[i3].pos1.X && this.PosArea[j].pos1.Y == this.PosArea[i3].pos2.Y || this.PosArea[j].pos2.X == this.PosArea[i3].pos2.X && this.PosArea[j].pos1.Y == this.PosArea[i3].pos2.Y || this.PosArea[j].pos1.X == this.PosArea[i3].pos2.X && this.PosArea[j].pos1.Y == this.PosArea[i3].pos2.Y)) {
                    this.PosArea[i3].relRectId.add(new Integer(this.PosArea[j].id));
                    ++addCount;
                }
                ++j;
            }
            ++i3;
        }
        this.cornerRect[0] = this.PosArea[0];
        this.cornerRect[1] = this.PosArea[3];
        this.cornerRect[2] = this.PosArea[12];
        this.cornerRect[3] = this.PosArea[15];
        this.statusArea[0] = new Rect(new Position(this.screenArea.pos1.X, this.screenArea.pos1.Y), new Position(this.centerPos.X - 1.0, this.centerPos.Y - 1.0));
        this.statusArea[1] = new Rect(new Position(this.screenArea.pos1.X, this.centerPos.Y + 1.0), new Position(this.centerPos.X - 1.0, this.screenArea.pos2.Y));
        this.statusArea[2] = new Rect(new Position(this.centerPos.X + 1.0, this.centerPos.Y + 1.0), new Position(this.screenArea.pos2.X, this.screenArea.pos2.Y));
        this.statusArea[3] = new Rect(new Position(this.centerPos.X + 1.0, this.screenArea.pos1.Y), new Position(this.screenArea.pos2.X, this.centerPos.Y - 1.0));
    }

    public int CheckInPosArea(Position pos) {
        int i = 0;
        while (i < 16) {
            if (this.PosArea[i].PointInside(pos)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void CheckPosAreaEnemy() {
        EnemyData enemy = null;
        int rid = -1;
        ListIterator enemyListItor = this.robot.enemy.enemyList.listIterator(0);
        int i = 0;
        while (i < 16) {
            this.PosAreaEnemy[i] = 0;
            ++i;
        }
        while (enemyListItor.hasNext()) {
            enemy = (EnemyData)enemyListItor.next();
            if (!enemy.alive || (rid = this.CheckInPosArea(enemy.pos)) < 0) continue;
            int n = rid;
            this.PosAreaEnemy[n] = this.PosAreaEnemy[n] + 1;
        }
    }

    public boolean CheckEnemyInCorner(Position pos) {
        int i = 0;
        while (i < 4) {
            if (this.cornerRect[i].PointInside(pos)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

