/*
 * Decompiled with CFR 0.152.
 */
package oog.micro;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Maui
extends AdvancedRobot {
    static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(20.0, 20.0, 760.0, 560.0);
    static double enemyEnergy;
    static LinkedList<Wave> waves;
    static double[] hits;
    static String enemyHistory;

    static {
        hits = new double[5];
        enemyHistory = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffe\ufffc\ufffa\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff9\ufffa\ufffb\ufffc\ufffd\ufffe\uffff\u0000\u0002\u0004\u0006\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\u0007\u0006\u0005\u0004\u0003\u0002\u0001\u0000";
    }

    public void run() {
        waves = new LinkedList();
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAllColors(Color.blue);
        while (true) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int i;
        int n;
        int matchPos;
        double d;
        double time;
        Wave w = new Wave();
        new Wave().startTime = time = (double)this.getTime();
        double absBearing = enemyEnergy - e.getEnergy();
        if (d > 0.0 && absBearing <= 3.0) {
            waves.add(w);
            w.speed = 20.0 - 3.0 * absBearing;
        }
        absBearing = e.getBearingRadians() + this.getHeadingRadians();
        w.startBearing = absBearing + Math.PI;
        w.velSeg = (int)(this.getVelocity() * Math.sin(this.getHeadingRadians() - Utils.normalRelativeAngle((double)(absBearing + Math.PI))) / 4.0) + 2;
        double dist = e.getDistance();
        w.eStartPos = this.project(dist, absBearing);
        enemyEnergy = e.getEnergy();
        double maxRisk = Double.POSITIVE_INFINITY;
        try {
            int dir = 1;
            while (dir > -2) {
                w = waves.getFirst();
                double turn = absBearing + 1.5707963267948966 + (double)dir * ((350.0 - e.getDistance()) / 300.0);
                while (!fieldRect.contains(this.project(160 * dir, turn -= 0.1 * (double)dir))) {
                }
                Point2D.Double predictPos = this.project(8 * dir, turn);
                double rating = 1.0 / Math.abs(Utils.normalRelativeAngle((double)(w.startBearing + hits[w.velSeg] - Maui.findAngle(predictPos, w))));
                if (rating < maxRisk) {
                    maxRisk = rating;
                    this.setTurnRightRadians(Utils.normalRelativeAngle((double)(turn - this.getHeadingRadians())));
                    this.setAhead(100 * dir);
                }
                if ((time - w.startTime) * w.speed > w.eStartPos.distance(this.getX(), this.getY()) + 20.0) {
                    waves.remove(w);
                }
                dir -= 2;
            }
        }
        catch (Exception dir) {
            // empty catch block
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        int matchLen = 30;
        enemyHistory = String.valueOf((char)(e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing))).concat(enemyHistory);
        do {
            n = matchLen--;
            i = (int)(dist / 14.0);
        } while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, n), i)) < 0);
        do {
            absBearing += (double)((short)enemyHistory.charAt(--matchPos)) / dist;
        } while (--i > 0);
        this.setFire(dist < 150.0 ? 3 : 2);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        try {
            Wave w = waves.getFirst();
            Maui.hits[w.velSeg] = Utils.normalRelativeAngle((double)(Maui.findAngle(new Point2D.Double(this.getX(), this.getY()), w) - w.startBearing));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static double findAngle(Point2D.Double spot, Wave w) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(spot.x - w.eStartPos.x, spot.y - w.eStartPos.y));
    }

    public Point2D.Double project(double dist, double angle) {
        return new Point2D.Double(this.getX() + dist * Math.sin(angle), this.getY() + dist * Math.cos(angle));
    }

    public static class Wave {
        double startBearing;
        double startTime;
        double speed;
        int velSeg;
        Point2D.Double eStartPos;
    }
}

