/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.move;

import catcat20.cat.utils.CUtils;
import catcat20.jewel.iolite.gun.IoliteGun;
import catcat20.jewel.iolite.knnUtils.DangerModel;
import catcat20.jewel.iolite.knnUtils.Data;
import catcat20.jewel.iolite.knnUtils.KNNModel;
import catcat20.jewel.iolite.knnUtils.WeightedData;
import catcat20.jewel.iolite.move.MiniRisk;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.MovementPredictor;
import catcat20.jewel.iolite.utils.PreciseWallSmooth;
import catcat20.jewel.iolite.utils.Wave;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Objects;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class MeleeSurfing {
    public static double allGetDamage = 0.0;
    PreciseWallSmooth preciseWallSmooth;
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    public static int BINS = 47;
    private static int MIDDLE_BIN = (BINS - 1) / 2;
    private static double MAX_ESCAPE_ANGLE = 0.7;
    private static double BIN_WIDTH = MAX_ESCAPE_ANGLE / (double)MIDDLE_BIN;
    public boolean paint = false;
    public boolean GOTO_ENABLE = false;
    public boolean TICK_FLATTENER_ENABLE = false;
    public final boolean FLATTENER_ONLY_MODE = false;
    public boolean FLATTENER_ENABLE = false;
    public boolean ANTI_SIMPLEGUN_ENABLE = true;
    public final boolean OTHER_PATH_PAINT = false;
    public TeamRobot robot;
    public static String myName;
    public static Point2D.Double _myLocation;
    public Point2D.Double _centerPosition;
    public long gameTime;
    public ArrayList<Wave> _enemyWaves;
    public ArrayList<Wave> _flattenerWaves;
    public static double actualBulletCount;
    public static double hitBulletCount;
    public static double allBulletCount;
    public static double allHitBulletCount;
    public static Rectangle2D.Double _fieldRect;
    public static Rectangle2D.Double _safeFieldRect;
    public static double WALL_STICK;
    public double bfWidth;
    public double bfHeight;
    MiniRisk miniRisk;
    double currentGF = 0.0;
    PreciseWallSmooth wallSmoothing;
    static double energy;
    Intersection intersection = new Intersection(0.0, 0.0);
    int MAX_SURFING_WAVE_COUNT = -1;
    Intersection intersectionCache = new Intersection(0.0, 0.0);
    Point2D.Double hitCache = new Point2D.Double(0.0, 0.0);
    static double[] guessFactors;
    static double[] weights;
    public static Point2D.Double antiMirrorPos;
    int count = 0;
    Wave bestPointWave = null;
    Path bestPath = null;
    ArrayList<Path> bestPaths = null;
    ArrayList<Point2D.Double> bestHitPositions = null;
    Result bestSecondResult = null;
    Point2D.Double _lastGoToPoint = null;
    ArrayList<Path> cachePoss = new ArrayList();
    Path cachePos = new Path();
    public boolean oldPaint = false;
    BasicStroke bs = new BasicStroke(3.0f);
    double fieldWidth;
    double fieldHeight;
    double r = 114.5450131316624;
    double d = 2.0 * this.r;
    private static double DESIRED_DISTANCE;
    private static double MAX_ATTACK_ANGLE;
    DistanceController distancer = new DistanceController();

    public MeleeSurfing(TeamRobot robot) {
        this.robot = robot;
        actualBulletCount = 1.0;
        hitBulletCount = 0.0;
        this.fieldWidth = robot.getBattleFieldWidth();
        this.fieldHeight = robot.getBattleFieldHeight();
        this.preciseWallSmooth = new PreciseWallSmooth(this.fieldWidth, this.fieldHeight);
        this.miniRisk = new MiniRisk((AdvancedRobot)robot);
        _safeFieldRect = new Rectangle2D.Double(20.0, 20.0, robot.getBattleFieldWidth() - 40.0, robot.getBattleFieldHeight() - 40.0);
        _fieldRect = new Rectangle2D.Double(1.0, 1.0, robot.getBattleFieldWidth() - 2.0, robot.getBattleFieldHeight() - 2.0);
        this._enemyWaves = new ArrayList();
        this._flattenerWaves = new ArrayList();
        this.wallSmoothing = new PreciseWallSmooth(robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
        this.bfWidth = robot.getBattleFieldWidth();
        this.bfHeight = robot.getBattleFieldHeight();
        this._centerPosition = new Point2D.Double(this.bfWidth / 2.0, this.bfHeight / 2.0);
        myName = robot.getName();
    }

    public void execute() {
        this.gameTime = this.robot.getTime();
        if (this.robot.getOthers() > 1) {
            this.FLATTENER_ENABLE = true;
        }
        _myLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        energy = this.robot.getEnergy();
        DESIRED_DISTANCE = 600.0;
        long time = this.robot.getTime();
        double coolingRate = this.robot.getGunCoolingRate();
        boolean isMelee = this.robot.getOthers() > 1;
        for (BotState en : IoliteRadar.enemies.values()) {
            Wave ew;
            if (!en.alive) continue;
            if (!isMelee) {
                en.moveModel.update();
                en.moveHitModel.update();
            } else {
                en.moveMeleeHitModel.update();
                en.moveMeleeModel.update();
            }
            double bulletPower = en.energyChange;
            if (bulletPower < 3.01 && bulletPower > 0.09 && en.directions.size() > 2 && en.gunHeat <= 0.0) {
                en.shotsFired += 1.0;
                actualBulletCount += 1.0;
                allBulletCount += 1.0;
                ew = new Wave();
                ew.x = en.oldPositions.get((int)2).x;
                ew.y = en.oldPositions.get((int)2).y;
                ew.fireTime = time - (this.robot.getTime() - en.lastLastScanTime);
                ew.bulletPower = bulletPower;
                ew.distanceTraveled = Rules.getBulletSpeed((double)bulletPower) * (double)(2L + (this.robot.getTime() - en.lastScanTime));
                ew.direction = en.myState.directions.get(2).intValue();
                ew.directAngle = en.absBearings.get(2);
                ew.enemyData = (BotState)en.thisOldStates.get(2).clone();
                ew.myData = (BotState)en.myState.thisOldStates.get(2).clone();
                if (this.robot.getOthers() > 1) {
                    ew.isMeleeWave = true;
                }
                ew.linear = this.robot.getVelocity() * Math.sin(this.robot.getHeadingRadians() - ew.directAngle) / ew.bulletVelocity();
                ew.weight = 1.0;
                if (en.getNearestBot(_myLocation, myName).equals(myName)) {
                    ew.weight = 5.0;
                }
                this._enemyWaves.add(ew);
                this._flattenerWaves.add(ew);
            } else if (this.robot.getOthers() <= 1 && en.directions.size() > 2 && en.gunHeat <= 0.0) {
                bulletPower = en.predictPower((AdvancedRobot)this.robot);
                ew = new Wave();
                ew.x = en.oldPositions.get((int)2).x;
                ew.y = en.oldPositions.get((int)2).y;
                ew.fireTime = time;
                ew.bulletPower = bulletPower;
                ew.distanceTraveled = Rules.getBulletSpeed((double)bulletPower) * (double)(2L + (this.robot.getTime() - en.lastScanTime));
                ew.direction = en.myState.directions.get(2).intValue();
                ew.directAngle = en.absBearings.get(2);
                ew.enemyData = (BotState)en.thisOldStates.get(2).clone();
                ew.myData = (BotState)en.myState.thisOldStates.get(2).clone();
                if (this.robot.getOthers() > 1) {
                    ew.isMeleeWave = true;
                }
                ew.linear = this.robot.getVelocity() * Math.sin(this.robot.getHeadingRadians() - ew.directAngle) / ew.bulletVelocity();
                this._flattenerWaves.add(ew);
            }
            if (this.robot.getTime() < 20L || !(_myLocation.distance(en) <= 150.0) || en.directions.size() <= 2) continue;
            this.addRammerWave(en, 0);
        }
        this.updateWaves();
        this.updateFlattenerWaves();
        this.MAX_SURFING_WAVE_COUNT = this.robot.getOthers() <= 1 ? Math.min(this._enemyWaves.size(), 3) : 1;
        this.doSurfing();
        this.paint = false;
    }

    public void updateWaves() {
        Graphics2D g = this.robot.getGraphics();
        long time = this.robot.getTime();
        for (int x = 0; x < this._enemyWaves.size(); ++x) {
            Wave ew = this._enemyWaves.get(x);
            IoliteRadar.getEnemy((String)ew.enemyData.name).currentGF = this.currentGF = ew.guessAngle(IoliteRadar.getEnemy(ew.enemyData.name));
            ++ew.ramTimeCount;
            ew.distanceTraveled = ((double)time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > _myLocation.distance(ew) + ew.bulletVelocity() * 2.0) {
                if (!ew.isMeleeWave) {
                    Data data = new Data();
                    data.guessFactor = ew.guessFactor(_myLocation);
                    data.weight = 1.0;
                    data.treeWeight = 1.0;
                    IoliteRadar.getEnemy(ew.enemyData.name).putSurfFlattenerLog(ew, data);
                    IoliteRadar.getEnemy((String)ew.enemyData.name).moveModel.learn(ew, _myLocation);
                    data = new Data();
                    data.guessFactor = ew.guessFactor(_myLocation);
                    data.weight = 3.0;
                    data.treeWeight = 1.0;
                    ew.enemyData.putSurfTickFlattenerLog(ew, data);
                }
                this._enemyWaves.remove(x);
                --x;
                continue;
            }
            if (ew.rammerWave && ew.ramTimeCount > 1L) {
                this._enemyWaves.remove(x);
                --x;
                continue;
            }
            Point2D.Double bulletPos = new Point2D.Double();
            Point2D.Double lastBulletPos = new Point2D.Double();
            boolean binUpdated = false;
            for (Bullet bullet : IoliteGun.realBullets) {
                if (ew.shadowedBullet.contains(bullet)) continue;
                this.calculateShadow(this.gameTime, ew, bullet);
                ew.shadowedBullet.add(bullet);
            }
            BotState en = IoliteRadar.getEnemy(ew.enemyData.name);
            if (ew.surfBins != null && !binUpdated) continue;
            this.updateNeighbors(ew);
            this.updateBins(ew, g);
        }
    }

    private void calculateShadow(long gameTime, Wave wave, Bullet b) {
        long timeOffset = 0L;
        double x = b.getX();
        double y = b.getY();
        double h = b.getHeadingRadians();
        double v = b.getVelocity();
        do {
            double r = wave.bulletVelocity() * ((double)(gameTime + timeOffset) - wave.fireTime);
            Line2D.Double line = CUtils.projection(x, y, h, v * (double)timeOffset, v * (double)(timeOffset + 1L));
            if (_myLocation.distanceSq(line.x1, line.y1) > wave.distanceSq(_myLocation) - r * r) break;
            wave.shadowBullet(b, line, gameTime + timeOffset);
        } while (++timeOffset < 110L);
    }

    public static double sqr(double val) {
        return val * val;
    }

    public static Point2D.Double intersection(Point2D.Double l1, Point2D.Double l2, Point2D.Double pos, double distanceTraveled) {
        double c;
        double xd = l2.x - l1.x;
        double yd = l2.y - l1.y;
        double b = 2.0 * (xd * (l1.x - pos.x) + yd * (l1.y - pos.y));
        double a = MeleeSurfing.sqr(xd) + MeleeSurfing.sqr(yd);
        double det = b * b - 4.0 * a * (c = MeleeSurfing.sqr(l1.x - pos.x) + MeleeSurfing.sqr(l1.y - pos.y) - MeleeSurfing.sqr(distanceTraveled));
        if (det < 0.0) {
            return null;
        }
        double t = (-b + (det = Math.sqrt(det))) / (2.0 * a);
        if (0.0 <= t && t <= 1.0) {
            return new Point2D.Double(l1.x + xd * t, l1.y + yd * t);
        }
        t = (-b - det) / (2.0 * a);
        if (0.0 <= t && t <= 1.0) {
            return new Point2D.Double(l1.x + xd * t, l1.y + yd * t);
        }
        return null;
    }

    public void updateFlattenerWaves() {
        Graphics2D g = this.robot.getGraphics();
        long time = this.robot.getTime();
        for (int x = 0; x < this._flattenerWaves.size(); ++x) {
            Wave ew = this._flattenerWaves.get(x);
            IoliteRadar.getEnemy((String)ew.enemyData.name).currentGF = this.currentGF = ew.guessAngle(IoliteRadar.getEnemy(ew.enemyData.name));
            ++ew.ramTimeCount;
            ew.distanceTraveled = ((double)time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > _myLocation.distance(ew) + ew.bulletVelocity()) {
                if (!ew.isMeleeWave) {
                    Data data = new Data();
                    data.guessFactor = ew.guessFactor(_myLocation);
                    data.weight = 1.0;
                    data.treeWeight = 1.0;
                    ew.enemyData.putSurfTickFlattenerLog(ew, data);
                }
                this._flattenerWaves.remove(x);
                --x;
                continue;
            }
            if (!ew.rammerWave || ew.ramTimeCount <= 1L) continue;
            this._flattenerWaves.remove(x);
            --x;
        }
    }

    public Wave getClosestSurfableWave(Point2D.Double pos) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Wave surfWave = null;
        if (this._enemyWaves.size() <= 0) {
            return null;
        }
        if (this._enemyWaves.size() == 1) {
            return this._enemyWaves.get(0);
        }
        for (Wave ew : this._enemyWaves) {
            double distance;
            if (surfWave == null) {
                surfWave = ew;
            }
            if (!((distance = (pos.distanceSq(ew) - ew.distanceTraveled * ew.distanceTraveled) / ew.bulletVelocity()) > 0.0) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    public Wave getNthSurfableWave(Point2D.Double pos, int number) {
        if (this._enemyWaves.size() < number) {
            return null;
        }
        this._enemyWaves.sort((w1, w2) -> {
            double distance2;
            double distance1 = (pos.distance((Point2D)w1) - w1.distanceTraveled) / w1.bulletVelocity();
            if (distance1 < w1.bulletVelocity()) {
                distance1 = Double.NEGATIVE_INFINITY;
            }
            if ((distance2 = (pos.distance((Point2D)w2) - w2.distanceTraveled) / w2.bulletVelocity()) < w2.bulletVelocity()) {
                distance2 = Double.NEGATIVE_INFINITY;
            }
            return (int)(-(distance1 - distance2));
        });
        return this._enemyWaves.get(number);
    }

    public Wave getSecondSurfableWave(Point2D.Double pos) {
        if (this._enemyWaves.size() < 2) {
            return null;
        }
        Wave closestWave = this.getClosestSurfableWave(pos);
        Wave secondWave = null;
        int index = this._enemyWaves.indexOf(closestWave);
        if (index == -1) {
            return null;
        }
        this._enemyWaves.remove(index);
        secondWave = this.getClosestSurfableWave(pos);
        this._enemyWaves.add(index, closestWave);
        return secondWave;
    }

    public Wave getThirdSurfableWave(Point2D.Double pos) {
        if (this._enemyWaves.size() < 3) {
            return null;
        }
        Wave closestWave = this.getClosestSurfableWave(pos);
        Wave secondWave = null;
        Wave thirdWave = null;
        int index = this._enemyWaves.indexOf(closestWave);
        if (index == -1) {
            return null;
        }
        this._enemyWaves.remove(index);
        secondWave = this.getClosestSurfableWave(pos);
        int secondIndex = this._enemyWaves.indexOf(secondWave);
        if (secondIndex == -1) {
            return null;
        }
        this._enemyWaves.remove(secondIndex);
        thirdWave = this.getClosestSurfableWave(pos);
        this._enemyWaves.add(secondIndex, secondWave);
        this._enemyWaves.add(index, closestWave);
        return thirdWave;
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
        long time = this.robot.getTime();
        this.ANTI_SIMPLEGUN_ENABLE = false;
        double gunHeat = ew.enemyData.gunHeat;
        int ticksSinceShot = ew.isRealWave ? 0 : (int)(time - ew.enemyData.lastFireTime);
        double coolingRate = this.robot.getGunCoolingRate();
        ew.enemyData.virtuality = ew.isRealWave ? 0.0 : (double)Math.min((int)(gunHeat / coolingRate), 1 + ticksSinceShot);
        Data data = new Data();
        data.guessFactor = ew.guessFactor(targetLocation);
        data.weight = 1.0;
        data.treeWeight = 1.0;
        if (ew.isMeleeWave) {
            IoliteRadar.getEnemy(ew.enemyData.name).putSurfMeleeLog(ew, data);
            IoliteRadar.getEnemy((String)ew.enemyData.name).moveMeleeHitModel.learn(ew, _myLocation);
            ArrayList<WeightedData<Data>> arrayList = ew.nearestNeighbors;
        } else {
            IoliteRadar.getEnemy(ew.enemyData.name).putSurfLog(ew, data);
            IoliteRadar.getEnemy((String)ew.enemyData.name).moveHitModel.learn(ew, _myLocation);
            data = new Data();
            data.guessFactor = ew.guessFactor(targetLocation);
            data.weight = 3.0;
            data.treeWeight = 1.0;
            IoliteRadar.getEnemy(ew.enemyData.name).putSurfFlattenerLog(ew, data);
            data = new Data();
            data.guessFactor = ew.guessFactor(targetLocation);
            data.weight = 5.0;
            data.treeWeight = 1.0;
            ew.enemyData.putSurfTickFlattenerLog(ew, data);
            ArrayList<WeightedData<Data>> nearestNeighbors = ew.nearestNeighbors;
            this.updateTreeWeight(data, nearestNeighbors);
        }
    }

    public void updateTreeWeight(Data data, ArrayList<WeightedData<Data>> nearestNeighbors) {
        double allWeight = 0.0;
        double count = 0.0;
        for (WeightedData<Data> dataList : nearestNeighbors) {
            double diff = 0.01;
            for (Data angleData : dataList.listData) {
                diff += 1.0 / Math.abs(Math.pow(angleData.guessFactor - data.guessFactor, 2.0));
            }
            diff /= (double)dataList.listData.size();
            diff = IUtils.limit(0.01, diff, 100.0);
            dataList.modelPointer.allModelWeight += diff;
            allWeight += dataList.modelPointer.allModelWeight;
            count += 1.0;
        }
        for (WeightedData<Data> dataList : nearestNeighbors) {
            dataList.modelPointer.modelWeight = dataList.modelPointer.allModelWeight / allWeight;
        }
    }

    public void onRoundEnded(RoundEndedEvent e) {
        System.out.println();
        System.out.println("***** surfing *****");
        for (BotState en : IoliteRadar.enemies.values()) {
            System.out.println(" [ " + en.name + " ] ");
            for (KNNModel<Data> kNNModel : en.surfKNNModels) {
                System.out.println("[surf] " + kNNModel.name + ": " + kNNModel.modelWeight);
            }
            for (KNNModel<Data> kNNModel : en.surfTickFlattenerModels) {
                System.out.println("[tickflattener] " + kNNModel.name + ": " + kNNModel.modelWeight);
            }
            for (KNNModel<Data> kNNModel : en.surfFlattenerModels) {
                System.out.println("[flattener] " + kNNModel.name + ": " + kNNModel.modelWeight);
            }
            for (DangerModel dangerModel : en.surfQuickModels) {
                System.out.println("[quicktargeting] " + dangerModel.name + ": " + dangerModel.modelWeight);
            }
            for (KNNModel kNNModel : en.surfMeleeKNNModels) {
                System.out.println("[melee] " + kNNModel.name + ": " + kNNModel.modelWeight);
            }
        }
        System.out.println();
        System.out.println("round hitRate: " + 100.0 * hitBulletCount / actualBulletCount + "%");
        System.out.println("game hitRate: " + 100.0 * allHitBulletCount / allBulletCount + "%");
        System.out.println();
    }

    public static double getRoundHitRate() {
        return 100.0 * hitBulletCount / actualBulletCount;
    }

    public static double getGameHitRate() {
        return 100.0 * allHitBulletCount / allBulletCount;
    }

    public void onHitRobot(HitRobotEvent e) {
        BotState en = IoliteRadar.getEnemy(e.getName());
        if (en != null) {
            Wave ew = new Wave();
            ew.x = en.x;
            ew.y = en.y;
            ew.fireTime = this.robot.getTime() - 1L;
            ew.bulletPower = 0.6;
            ew.distanceTraveled = en.velocity;
            ew.direction = en.myState.directions.get(2).intValue();
            ew.directAngle = en.absBearings.get(2);
            ew.enemyData = (BotState)en.clone();
            ew.myData = (BotState)en.myState.clone();
            ew.rammerWave = true;
            Data data = new Data();
            data.treeWeight = 3.0;
            data.weight = 1.0;
            data.guessFactor = ew.guessFactor(_myLocation);
            en.putSurfAntiRamLog(ew, data);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        allGetDamage += Rules.getBulletDamage((double)e.getBullet().getPower());
        hitBulletCount += 1.0;
        allHitBulletCount += 1.0;
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._enemyWaves.size(); ++x) {
                Wave ew = this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < 50.0 && Math.abs(MeleeSurfing.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity()) < 0.001 && Objects.equals(e.getBullet().getName(), ew.enemyData.name)) {
                    hitWave = ew;
                    break;
                }
                if (!(_myLocation.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = _myLocation.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onHitByBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            double bestScore = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._enemyWaves.size(); ++x) {
                Wave ew = this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < bestScore && Math.abs(MeleeSurfing.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity()) < 0.001 && e.getHitBullet().getName().equals(ew.enemyData.name)) {
                    hitWave = ew;
                    bestScore = Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew));
                }
                if (!(_myLocation.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = _myLocation.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onBulletHitBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public ArrayList<Path> predictPosition(Path statusInfo, Wave surfWave, int direction, int smoothTowardEnemy) {
        return this.predictPosition(statusInfo, surfWave, direction, smoothTowardEnemy, false);
    }

    public ArrayList<Path> predictPosition(Path statusInfo, Wave surfWave, int direction, int smoothTowardEnemy, boolean escapeFromRam) {
        MovementPredictor.PredictionStatus predictedPosition = (MovementPredictor.PredictionStatus)statusInfo.status.clone();
        double predictedVelocity = statusInfo.status.velocity;
        double predictedHeading = statusInfo.status.heading;
        double moveAngle = 0.0;
        int counter = 0;
        boolean intercepted = false;
        PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
        ArrayList<Path> statuses = new ArrayList<Path>();
        do {
            double distancerAngle = 0.0;
            distancerAngle = !escapeFromRam ? this.distancer.surfAttackAngle(predictedPosition.distance(IoliteRadar.getEnemy(surfWave.enemyData.name))) : this.distancer.surfEscapeFromRamAngle(predictedPosition.distance(IoliteRadar.getEnemy(surfWave.enemyData.name)));
            moveAngle = this.wallSmoothing(predictedPosition.x, predictedPosition.y, IUtils.absoluteBearing(surfWave, predictedPosition) + (double)direction * (1.5707963267948966 + distancerAngle), direction, smoothTowardEnemy) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + IUtils.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = IUtils.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition.x = IUtils.project((Point2D.Double)predictedPosition, (double)predictedHeading, (double)predictedVelocity).x;
            predictedPosition.y = IUtils.project((Point2D.Double)predictedPosition, (double)predictedHeading, (double)predictedVelocity).y;
            predictedPosition.heading = predictedHeading;
            predictedPosition.velocity = predictedVelocity;
            predictedPosition.direction = direction;
            Path path = new Path();
            path.wave = surfWave;
            path.heading = predictedHeading;
            path.maxVelocity = statusInfo.maxVelocity;
            path.status = (MovementPredictor.PredictionStatus)predictedPosition.clone();
            path.status.direction = direction;
            path.status.x = predictedPosition.x;
            path.status.y = predictedPosition.y;
            path.heading = predictedHeading;
            statuses.add(path);
            ++counter;
            if (!(predictedPosition.distance(surfWave) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity() + surfWave.bulletVelocity())) continue;
            intercepted = true;
        } while (!intercepted && counter < 300);
        return statuses;
    }

    public ArrayList<Path> predict(Path statusInfo, Wave surfWave, int direction) {
        return this.predict(statusInfo, surfWave, direction, false);
    }

    public ArrayList<Path> predict(Path statusInfo, Wave surfWave, int direction, boolean escapeFromRam) {
        MovementPredictor.PredictionStatus predictedPosition = (MovementPredictor.PredictionStatus)statusInfo.status.clone();
        int counter = 0;
        boolean intercepted = false;
        PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
        trig.sin = Math.sin(statusInfo.status.heading);
        trig.cos = Math.cos(statusInfo.status.heading);
        ArrayList<Path> statuses = new ArrayList<Path>();
        do {
            double distancerAngle = 0.0;
            distancerAngle = !escapeFromRam ? this.distancer.surfAttackAngle(predictedPosition.distance(IoliteRadar.getEnemy(surfWave.enemyData.name))) : this.distancer.surfEscapeFromRamAngle(predictedPosition.distance(IoliteRadar.getEnemy(surfWave.enemyData.name)));
            double goHeading = this.wallSmoothing(predictedPosition.x, predictedPosition.y, IUtils.absoluteBearing(surfWave, predictedPosition) + (double)direction * (1.5707963267948966 + distancerAngle), direction, 1);
            predictedPosition = MovementPredictor.predict(predictedPosition, goHeading, statusInfo.maxVelocity);
            Path path = new Path();
            path.wave = surfWave;
            path.heading = predictedPosition.heading;
            path.maxVelocity = statusInfo.maxVelocity;
            path.status = (MovementPredictor.PredictionStatus)predictedPosition.clone();
            statuses.add(path);
            ++counter;
            if (!(predictedPosition.distance(surfWave) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity() + surfWave.bulletVelocity())) continue;
            intercepted = true;
        } while (!intercepted && counter < 300);
        return statuses;
    }

    public double getMiniRisk(Point2D.Double pos) {
        double risk = 0.0;
        for (BotState en : IoliteRadar.enemies.values()) {
            double goAngle = IUtils.absoluteBearing(_myLocation, pos);
            if (!en.alive) continue;
            String nearestBotName = en.getNearestBot(pos, myName);
            double energyRatio = Math.min(en.energy / energy, 2.0);
            if (nearestBotName != null && nearestBotName.equals(myName)) {
                energyRatio *= 1.75;
            }
            double sui = 1.0 + Math.abs(Math.cos(en.absBearing - goAngle));
            double dist = en.distance(pos);
            risk += energyRatio * sui / dist;
        }
        return risk;
    }

    public Result checkDanger(Wave surfWave, MovementPredictor.PredictionStatus pos, Graphics2D g, int surfWaveIndex, double allBestEval) {
        double distance;
        this.intersection.angle = IUtils.absoluteBearing(surfWave, pos);
        this.intersection.bandwidth = IUtils.botWidthAimAngle(surfWave.distance(pos));
        this.intersection.pos = pos;
        double risk = 0.0;
        risk = !surfWave.isMeleeWave ? this.getDangerScore(surfWave, this.intersection, false, g) : this.getDangerScoreFromBins(surfWave, this.intersection);
        if (this.robot.isTeammate(surfWave.enemyData.name)) {
            risk /= 3.0;
        }
        if ((distance = surfWave.distance(pos)) <= 150.0) {
            risk /= distance * distance * distance;
        }
        if (surfWave.isMeleeWave) {
            risk /= Math.pow(distance, 0.125);
        }
        double timeToImpact = Math.max(1.0, (surfWave.distance(pos) - surfWave.bulletVelocity() * ((double)this.gameTime - surfWave.fireTime)) / surfWave.bulletVelocity());
        risk /= timeToImpact;
        Path bestPath = null;
        ArrayList<Path> bestPathList = null;
        Result secondResult = null;
        if (surfWaveIndex < this.MAX_SURFING_WAVE_COUNT) {
            Wave secondWave = null;
            Wave thirdWave = null;
            if (surfWaveIndex == 1) {
                thirdWave = this.getThirdSurfableWave(pos);
                secondWave = this.getSecondSurfableWave(pos);
            } else if (surfWaveIndex == 2) {
                secondWave = this.getThirdSurfableWave(pos);
            }
            if (secondWave != null) {
                double addDistance = pos.distance(surfWave) - surfWave.distanceTraveled + surfWave.bulletVelocity();
                for (Wave w : this._enemyWaves) {
                    w.distanceTraveled += addDistance;
                }
                ArrayList<ArrayList<Path>> paths = null;
                paths = !secondWave.isMeleeWave ? this.makePathFor1v1(pos, secondWave) : this.makePathForMelee(pos, secondWave, 8);
                double bestRisk = Double.POSITIVE_INFINITY;
                for (ArrayList<Path> pathList : paths) {
                    Path path1 = pathList.get(Math.max(pathList.size() - 1, 0));
                    Result riskResult = this.checkDanger(secondWave, path1.status, g, surfWaveIndex + 1, allBestEval);
                    double riskCount = riskResult.danger;
                    distance = secondWave.distance(path1.status);
                    if (distance <= 150.0) {
                        risk /= distance * distance * distance;
                    }
                    if (this.paint) {
                        // empty if block
                    }
                    if (riskCount < bestRisk) {
                        bestRisk = riskCount;
                        bestPath = path1;
                        bestPathList = pathList;
                        secondResult = riskResult;
                    }
                    if (!this.paint) continue;
                }
                risk += bestRisk;
                for (Wave w : this._enemyWaves) {
                    w.distanceTraveled -= addDistance;
                }
            }
        }
        Result result = new Result(bestPathList, risk);
        result.deeperResult = secondResult;
        return result;
    }

    public ArrayList<ArrayList<Path>> makePathAllWaveSurfing(MovementPredictor.PredictionStatus pos, Wave wave, int directions) {
        ArrayList<ArrayList<Path>> paths = new ArrayList<ArrayList<Path>>();
        double division = directions;
        int start = 0;
        BotState en = IoliteRadar.getNearestEnemy();
        double enAngle = MeleeSurfing.absoluteBearing(pos, en);
        double wallStick = IUtils.limit(40.0, en.distance, 140.0);
        int i = start;
        while (i < 360) {
            double angle = Math.abs(enAngle - Math.toRadians(i));
            boolean isDangerAngle = true;
            if (en.distance <= 175.0) {
                boolean bl = isDangerAngle = angle >= Math.toRadians(360.0 / division) * IUtils.limit(2.5, 5.0 / (en.distance / 100.0), 5.0);
            }
            if (isDangerAngle && _safeFieldRect.contains(MeleeSurfing.project(pos, Math.toRadians(i), wallStick + 18.0))) {
                paths.add(this.meleePredict(8.0, pos, Math.toRadians(i), wallStick));
            }
            i = (int)((double)i + 360.0 / division);
        }
        return paths;
    }

    public Path getHitPath(Wave w, ArrayList<Path> paths, long time) {
        double distanceTraveled = w.bulletVelocity() * ((double)time - w.fireTime - 1.0);
        int index = 0;
        Path currentPath = null;
        do {
            currentPath = paths.get(index);
        } while (++index <= 100 && currentPath.status.distance(w) > (distanceTraveled += w.bulletVelocity()) && index < paths.size());
        if (index >= paths.size()) {
            return null;
        }
        return currentPath;
    }

    public ArrayList<ArrayList<Path>> makePathForMelee(MovementPredictor.PredictionStatus pos, Wave wave, int directions) {
        ArrayList<ArrayList<Path>> paths = new ArrayList<ArrayList<Path>>();
        double division = directions;
        int start = 0;
        BotState en = IoliteRadar.getNearestEnemy();
        double enAngle = MeleeSurfing.absoluteBearing(pos, en);
        double centerAngle = MeleeSurfing.absoluteBearing(pos, this._centerPosition);
        int i = start;
        while (i < 360) {
            double angle = Math.abs(enAngle - Math.toRadians(i));
            boolean isDangerAngle = true;
            if (en.distance <= 175.0) {
                boolean bl = isDangerAngle = angle >= Math.toRadians(360.0 / division) * IUtils.limit(2.5, 5.0 / (en.distance / 100.0), 5.0);
            }
            if (isDangerAngle && _safeFieldRect.contains(MeleeSurfing.project(pos, Math.toRadians(i), 210.0))) {
                int moveDir = 1;
                if (Math.cos(Math.toRadians(i) - centerAngle) < 0.0) {
                    moveDir = -1;
                }
                pos.direction = moveDir;
                paths.add(this.precisePredict(wave, 8.0, pos, Math.toRadians(i)));
            }
            i = (int)((double)i + 360.0 / division);
        }
        Path path = new Path();
        path.wave = wave;
        path.maxVelocity = 0.0;
        path.status = pos;
        path.status.x = pos.x;
        path.status.y = pos.y;
        path.heading = pos.heading;
        path.status.smoothTowardEnemy = 1;
        paths.add(this.predict(path, wave, 1));
        path.maxVelocity = 8.0;
        if (pos.distance(wave) <= 150.0) {
            path.status.smoothTowardEnemy = -1;
            paths.add(this.predictPosition(path, wave, 1, -1, true));
            paths.add(this.predictPosition(path, wave, -1, -1, true));
            path.status.smoothTowardEnemy = 1;
        }
        return paths;
    }

    public ArrayList<ArrayList<Path>> makePathFor1v1(MovementPredictor.PredictionStatus pos, Wave wave) {
        MovementPredictor.PredictionStatus status = (MovementPredictor.PredictionStatus)pos.clone();
        ArrayList<ArrayList<Path>> paths = new ArrayList<ArrayList<Path>>();
        Path path = new Path();
        path.wave = wave;
        path.status = status;
        path.status.x = pos.x;
        path.status.y = pos.y;
        path.heading = status.heading;
        path.maxVelocity = 8.0;
        path.status.smoothTowardEnemy = 1;
        paths.add(this.predictPosition(path, wave, 1, 1));
        paths.add(this.predictPosition(path, wave, -1, 1));
        if (pos.distance(wave) <= 150.0) {
            path.status.smoothTowardEnemy = -1;
            paths.add(this.predictPosition(path, wave, 1, -1, true));
            paths.add(this.predictPosition(path, wave, -1, -1, true));
            path.status.smoothTowardEnemy = 1;
        }
        if (path.status.distance(wave) > 150.0) {
            path.maxVelocity = 0.0;
            paths.add(this.predict(path, wave, 1));
        }
        return paths;
    }

    double getDangerScore(Wave w, Point2D.Double dangerLocation, Graphics2D g, boolean paint) {
        double bandwidth;
        this.intersectionCache.bandwidth = bandwidth = 36.0 / _myLocation.distance(w);
        this.intersectionCache.angle = IUtils.absoluteBearing(w, dangerLocation);
        this.intersectionCache.pos = dangerLocation;
        if (w.isMeleeWave) {
            return Math.sqrt(Math.pow(this.getDangerScore(w, this.intersectionCache, paint, g), 3.0));
        }
        return this.getDangerScore(w, this.intersectionCache, paint, g);
    }

    double getDangerScoreFromBins(Wave w, Intersection intersection) {
        int toBin;
        double bin2;
        double dangerAngle = intersection.angle;
        double bandwidth = intersection.bandwidth;
        bandwidth = 40.0;
        double danger = 0.0;
        double bin1 = this.getFactorIndex(w, IUtils.projectWithCache(intersection.pos, intersection.angle + 1.5707963267948966, bandwidth / 2.0, this.hitCache));
        int fromBin = (int)Math.ceil(Math.min(bin1, bin2 = this.getFactorIndex(w, IUtils.projectWithCache(intersection.pos, intersection.angle - 1.5707963267948966, bandwidth / 2.0, this.hitCache))));
        if (fromBin == (toBin = (int)Math.floor(Math.max(bin1, bin2)))) {
            if (toBin + 1 > w.surfBins.length) {
                --fromBin;
            } else {
                ++toBin;
            }
        }
        for (int i = fromBin; i < toBin; ++i) {
            danger += w.surfBins[i];
        }
        return danger / (double)(toBin - fromBin);
    }

    double getDangerScore(Wave w, Intersection intersection, boolean paint, Graphics2D g) {
        double dangerAngle = intersection.angle;
        double bandwidth = intersection.bandwidth;
        double totalDanger = 0.0;
        double totalScanWeight = 0.0;
        int enabledSize = 0;
        BotState en = IoliteRadar.getEnemy(w.enemyData.name);
        if (en != null) {
            if (paint) {
                g.setColor(Color.cyan);
            }
            ArrayList<WeightedData<Data>> nearestNeighbors = null;
            nearestNeighbors = w.nearestNeighbors;
            if (nearestNeighbors == null) {
                System.out.println("null");
                nearestNeighbors = this.getNearestNeighbors(w);
            }
            double density = 0.0;
            double viewScanWeight = 0.0;
            int neiCount = 0;
            for (WeightedData<Data> neighbor : nearestNeighbors) {
                ++neiCount;
                int dataCount = 0;
                for (Data data : neighbor.listData) {
                    ++dataCount;
                    double scanWeight = data.treeWeight;
                    scanWeight = !neighbor.modelPointer.isQuickTargeting ? (scanWeight /= Math.sqrt(neighbor.list.distance())) : (scanWeight /= 5.0);
                    double xFiringAngle = IUtils.normalizeAngle(w.firingAngle(data.guessFactor), dangerAngle);
                    double ux = (xFiringAngle - dangerAngle) / bandwidth;
                    ++enabledSize;
                    totalScanWeight += (viewScanWeight += scanWeight) * data.weight;
                    totalDanger += data.weight * (density += scanWeight * Math.pow(2.0, -Math.abs(ux)));
                }
            }
        }
        if (enabledSize == 0) {
            totalDanger += MeleeSurfing.defaultDanger(w, intersection) * 10.0;
        }
        double danger = totalDanger;
        double shadowFactor = 0.1;
        for (Wave.BulletShadow shadow : w.shadows) {
            double diff = Math.abs(dangerAngle - Math.abs(Math.abs(w.firingAngle(shadow.maxAngle)) - Math.abs(w.firingAngle(shadow.minAngle))));
            shadowFactor += diff * 0.1;
        }
        if (!w.isMeleeWave) {
            // empty if block
        }
        return shadowFactor * w.bulletPower * w.weight * danger / totalScanWeight;
    }

    public ArrayList<WeightedData<Data>> getNearestNeighbors(Wave w) {
        BotState en = w.enemyData;
        ArrayList<Object> nearestNeighbors = new ArrayList<WeightedData<Data>>();
        if (w.isMeleeWave) {
            nearestNeighbors = en.getMeleeSurfNeighbors(w);
        } else {
            nearestNeighbors.addAll(en.getSurfNeighbors(w));
            if (this.FLATTENER_ENABLE) {
                nearestNeighbors.addAll(en.getSurfFlattenerNeighbors(w));
            }
            if (this.TICK_FLATTENER_ENABLE) {
                nearestNeighbors.addAll(en.getSurfTickFlattenerNeighbors(w));
            }
        }
        if (w.rammerWave) {
            nearestNeighbors.addAll(en.getSurfAntiRamNeighbors(w));
        }
        if (this.ANTI_SIMPLEGUN_ENABLE || w.isMeleeWave && nearestNeighbors.isEmpty()) {
            nearestNeighbors.addAll(en.getQuickTargetingNeighbors(w));
        }
        return nearestNeighbors;
    }

    public static double[] rollingAverage(double[] bins) {
        for (int x = 0; x < bins.length; ++x) {
            for (int y = -2; y < 5; ++y) {
                int pointer = x + y;
                if (x + y <= 0 || x + y >= bins.length) continue;
                int n = x;
                bins[n] = bins[n] + 1.0 / Math.pow(Math.abs(x - pointer) + 1, 2.0);
            }
        }
        return bins;
    }

    public double getFactorIndex(Wave ew, Point2D.Double targetLocation) {
        double offsetAngle = MeleeSurfing.absoluteBearing(ew, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / MeleeSurfing.maxEscapeAngle(ew.bulletVelocity()) * ew.direction;
        return MeleeSurfing.limit(0.0, 0.9 * factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    private static double defaultDanger(Wave w, Intersection intersection) {
        double danger = 0.0;
        for (int x = 0; x < guessFactors.length; ++x) {
            double firingAngle = w.firingAngle(guessFactors[x]);
            double ux = (firingAngle - IUtils.normalizeAngle(intersection.angle, firingAngle)) / intersection.bandwidth;
            danger += weights[x] * Math.pow(2.0, -Math.abs(ux));
        }
        return danger;
    }

    public Wave addRammerWave(BotState en, int timeOffset) {
        Wave ew = new Wave();
        ew.x = en.x;
        ew.y = en.y;
        ew.fireTime = this.robot.getTime() + 1L + (long)timeOffset;
        ew.bulletPower = en.velocity;
        ew.distanceTraveled = en.velocity;
        ew.direction = en.myState.directions.get(2).intValue();
        ew.directAngle = en.absBearings.get(2);
        ew.enemyData = (BotState)en.clone();
        ew.myData = (BotState)en.myState.clone();
        ew.rammerWave = true;
        this._enemyWaves.add(ew);
        return ew;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doSurfing() {
        BotState en;
        Graphics2D g = this.robot.getGraphics();
        antiMirrorPos.setLocation(this.fieldWidth - MeleeSurfing._myLocation.x, this.fieldHeight - MeleeSurfing._myLocation.y);
        if (this.paint) {
            g.setColor(Color.white);
            g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
        }
        Wave surfWave = this.getClosestSurfableWave(_myLocation);
        if (this.bestPath == null) {
            this.bestPath = new Path();
            this.bestPath.wave = surfWave;
            this.bestPath.status = new MovementPredictor.PredictionStatus(MeleeSurfing._myLocation.x, MeleeSurfing._myLocation.y, this.robot.getHeadingRadians(), this.robot.getVelocity(), this.robot.getTime());
        }
        if ((en = IoliteRadar.getNearestEnemy()) != null && en.distance <= 150.0) {
            this.bestPointWave = null;
        } else if (this.robot.getOthers() <= 1) {
            this.bestHitPositions = null;
            if (!this.GOTO_ENABLE) {
                this.bestPointWave = null;
            }
        }
        if (this.robot.getOthers() > 1) {
            this.bestPointWave = null;
        }
        if (surfWave == null) {
            if (en == null) {
                this.miniRisk.move();
                return;
            }
            if (this.robot.getTime() > 20L && _myLocation.distance(en) <= 150.0 && en.absBearings.size() > 2 && en.myState.directions.size() > 2 && en.oldPositions.size() > 0) {
                surfWave = this.addRammerWave(en, 5);
                this.updateBins(surfWave, g);
            } else {
                this.miniRisk.move();
                return;
            }
        }
        if (this.bestPointWave != surfWave) {
            MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(MeleeSurfing._myLocation.x, MeleeSurfing._myLocation.y, this.robot.getHeadingRadians(), this.robot.getVelocity(), this.robot.getTime());
            ArrayList<Object> paths = new ArrayList();
            paths = this.robot.getOthers() <= 1 ? this.makePathFor1v1(status, surfWave) : this.makePathAllWaveSurfing(status, surfWave, 32);
            this.bestPath = null;
            this.bestPaths = null;
            this.bestSecondResult = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            boolean isOne = this.robot.getOthers() <= 1;
            long time = this.robot.getTime();
            for (ArrayList arrayList : paths) {
                if (isOne) {
                    if (!this.GOTO_ENABLE) {
                        Path pos = (Path)arrayList.get(Math.max(arrayList.size() - 1, 0));
                        Result riskResult = this.checkDanger(surfWave, pos.status, g, 1, bestRisk);
                        double risk = riskResult.danger;
                        if (risk < bestRisk) {
                            bestRisk = risk;
                            this.bestPath = pos;
                            this.bestPaths = arrayList;
                            this.bestSecondResult = riskResult;
                            this.bestPointWave = surfWave;
                        }
                        if (!this.paint) continue;
                        g.setColor(Color.white);
                        g.drawOval((int)pos.status.x, (int)pos.status.y, 5, 5);
                        continue;
                    }
                    for (Path pos : arrayList) {
                        Result riskResult = this.checkDanger(surfWave, pos.status, g, 1, bestRisk);
                        double risk = riskResult.danger;
                        if (!(risk < bestRisk)) continue;
                        bestRisk = risk;
                        this.bestPath = pos;
                        this.bestPaths = arrayList;
                        this.bestSecondResult = riskResult;
                        this.bestPointWave = surfWave;
                    }
                    continue;
                }
                Point2D.Double miniPos = new Point2D.Double();
                double risk = 0.0;
                Path miniPath = (Path)arrayList.get(Math.max(0, arrayList.size() - 1));
                ArrayList<MovementPredictor.PredictionStatus> hitPositions = new ArrayList<MovementPredictor.PredictionStatus>();
                for (Wave w : this._enemyWaves) {
                    Path hitPath = this.getHitPath(w, arrayList, time);
                    if (hitPath == null) continue;
                    hitPositions.add(hitPath.status);
                    this.intersection.pos = hitPath.status;
                    this.intersection.bandwidth = IUtils.botWidthAimAngle(w.distance(hitPath.status));
                    this.intersection.angle = IUtils.absoluteBearing(w, hitPath.status);
                    if (this.paint) {
                        g.setColor(Color.red);
                        g.drawOval((int)hitPath.status.x - 1, (int)hitPath.status.y - 1, 2, 2);
                    }
                    double currentWaveRisk = this.getDangerScoreFromBins(surfWave, this.intersection);
                    double distance = surfWave.distance(hitPath.status);
                    if (distance <= 150.0) {
                        currentWaveRisk /= distance * distance * distance;
                    }
                    risk += currentWaveRisk;
                }
                miniPos.setLocation(miniPath.status.x, miniPath.status.y);
                double miniRisk = this.getMiniRisk(miniPos);
                risk *= miniRisk;
                g.setColor(Color.white);
                g.drawOval((int)miniPath.status.x - 2, (int)miniPath.status.y - 2, 4, 4);
                if (!(risk < bestRisk)) continue;
                bestRisk = risk;
                this.bestPath = miniPath;
                this.bestPaths = arrayList;
                this.bestSecondResult = null;
                this.bestPointWave = null;
                this.bestHitPositions = hitPositions;
            }
        }
        if (this.paint && this.bestHitPositions != null && !this.bestHitPositions.isEmpty()) {
            for (Point2D.Double hitPos : this.bestHitPositions) {
                g.setColor(Color.white);
                g.drawRect((int)hitPos.x - 18, (int)hitPos.y - 18, 36, 36);
            }
        }
        if (this.paint && this.bestPaths != null && this.robot.getOthers() <= 1) {
            Stroke cache = g.getStroke();
            g.setStroke(new BasicStroke(2.0f));
            Path drawPos2 = null;
            int bestIndex = this.bestPaths.indexOf(this.bestPath);
            for (int i = 0; i < this.bestPaths.size(); ++i) {
                Path drawPos = this.bestPaths.get(i);
                g.setColor(Color.white);
                if (i > 0) {
                    drawPos2 = this.bestPaths.get(i - 1);
                    g.drawLine((int)drawPos.status.x, (int)drawPos.status.y, (int)drawPos2.status.x, (int)drawPos2.status.y);
                }
                antiMirrorPos.setLocation(drawPos.status.x, drawPos.status.y);
                if (bestIndex == i) break;
            }
            g.setColor(Color.white);
            g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
            antiMirrorPos.setLocation(this.fieldWidth - MeleeSurfing.antiMirrorPos.x, this.fieldHeight - MeleeSurfing.antiMirrorPos.y);
            g.setColor(Color.white);
            g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
            if (this.bestSecondResult.pathList != null) {
                ArrayList<Path> pathList = this.bestSecondResult.pathList;
                for (int i = 0; i < pathList.size(); ++i) {
                    Path drawPos = pathList.get(i);
                    g.setColor(Color.white);
                    if (i > 0) {
                        drawPos2 = pathList.get(i - 1);
                        g.drawLine((int)drawPos.status.x, (int)drawPos.status.y, (int)drawPos2.status.x, (int)drawPos2.status.y);
                    }
                    if (drawPos != null && drawPos2 != null) {
                        g.drawLine((int)drawPos.status.x, (int)drawPos.status.y, (int)drawPos2.status.x, (int)drawPos2.status.y);
                    }
                    antiMirrorPos.setLocation(drawPos.status.x, drawPos.status.y);
                }
                g.setColor(Color.white);
                g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
                antiMirrorPos.setLocation(this.fieldWidth - MeleeSurfing.antiMirrorPos.x, this.fieldHeight - MeleeSurfing.antiMirrorPos.y);
                g.setColor(Color.white);
                g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
                if (this.bestSecondResult.deeperResult != null && this.bestSecondResult.deeperResult.pathList != null) {
                    ArrayList<Path> list = this.bestSecondResult.deeperResult.pathList;
                    for (int i = 0; i < list.size(); ++i) {
                        Path drawPos = list.get(i);
                        g.setColor(Color.white);
                        if (i > 0) {
                            drawPos2 = this.bestSecondResult.deeperResult.pathList.get(i - 1);
                            g.drawLine((int)drawPos.status.x, (int)drawPos.status.y, (int)drawPos2.status.x, (int)drawPos2.status.y);
                        }
                        if (drawPos != null && drawPos2 != null) {
                            g.drawLine((int)drawPos.status.x, (int)drawPos.status.y, (int)drawPos2.status.x, (int)drawPos2.status.y);
                        }
                        antiMirrorPos.setLocation(drawPos.status.x, drawPos.status.y);
                    }
                    g.setColor(Color.white);
                    g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
                    antiMirrorPos.setLocation(this.fieldWidth - MeleeSurfing.antiMirrorPos.x, this.fieldHeight - MeleeSurfing.antiMirrorPos.y);
                    g.setColor(Color.white);
                    g.drawRect((int)MeleeSurfing.antiMirrorPos.x - 18, (int)MeleeSurfing.antiMirrorPos.y - 18, 36, 36);
                }
                g.setStroke(cache);
            }
        }
        this.robot.setMaxVelocity(8.0);
        if (this.bestPath != null) {
            this.trig.sin = Math.sin(this.robot.getHeadingRadians());
            this.trig.cos = Math.cos(this.robot.getHeadingRadians());
            double ran = Math.random() / 1.0E12;
            if (this.bestPath.maxVelocity > 7.9) {
                this.robot.setMaxVelocity(8.0 - ran);
            } else if (this.bestPath.maxVelocity < 1.0) {
                this.robot.setMaxVelocity(ran);
            } else {
                this.robot.setMaxVelocity(this.bestPath.maxVelocity - ran);
            }
            double absBearing = IUtils.absoluteBearing(_myLocation, this.bestPath.status);
            absBearing = this.wallSmoothing(MeleeSurfing._myLocation.x, MeleeSurfing._myLocation.y, absBearing, this.bestPath.status.direction, this.bestPath.status.smoothTowardEnemy);
            double goAngle = this.wallSmoothing.smoothHeading(absBearing, this.trig, MeleeSurfing._myLocation.x, MeleeSurfing._myLocation.y, this.bestPath.status.direction);
            IUtils.setBackAsFront((AdvancedRobot)this.robot, goAngle);
            if (this.bestPath.maxVelocity < 1.0) {
                this.robot.setAhead(100.0);
            }
            if (this.bestPointWave != null && !this.bestPointWave.isMeleeWave && this.GOTO_ENABLE) {
                if (!this.bestPaths.isEmpty()) {
                    this.goTo(this.bestPaths.get((int)0).status);
                    this.bestPaths.remove(0);
                } else {
                    this.goTo(_myLocation);
                }
            }
            if (this.bestPointWave != null && this.bestPointWave.isMeleeWave) {
                this.goTo(this.bestPaths.get((int)Math.max((int)0, (int)(this.bestPaths.size() - 1))).status);
            }
            g.setColor(Color.yellow);
            g.drawOval((int)this.bestPath.status.x, (int)this.bestPath.status.y, 8, 8);
        }
    }

    private void goTo(Point2D.Double place) {
        double distance = _myLocation.distance(place);
        double dir = 1.0;
        double angle = Utils.normalRelativeAngle((double)(MeleeSurfing.absoluteBearing(_myLocation, place) - this.robot.getHeadingRadians()));
        if (-1.0 < distance & distance < 1.0) {
            angle = 0.0;
        }
        if (Math.abs(angle) > 1.5707963267948966) {
            dir = -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.robot.setTurnRightRadians(angle);
        this.robot.setAhead(this.distanceScale(distance, angle) * dir);
    }

    private double distanceScale(double oldDistance, double changeAngle) {
        return Math.abs(Math.cos(changeAngle)) * Math.min(20.0, oldDistance);
    }

    private void goTo(Point2D.Double myLocation, Point2D.Double destination) {
        if (destination == null) {
            if (this._lastGoToPoint != null) {
                destination = this._lastGoToPoint;
            } else {
                return;
            }
        }
        this._lastGoToPoint = destination;
        double distance = myLocation.distance(destination);
        double angle = Utils.normalRelativeAngle((double)(MeleeSurfing.absoluteBearing(myLocation, destination) - this.robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance = -distance;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.robot.setTurnRightRadians(angle * (double)Math.signum(Math.abs((int)distance)));
        this.robot.setAhead(distance + 20.0);
    }

    private void go(AdvancedRobot robot, double myPosX, double myPosY, double goX, double goY) {
        double goAngle = Utils.normalRelativeAngle((double)(Math.atan2(goX -= myPosX, goY -= myPosY) - robot.getHeadingRadians()));
        robot.setTurnRightRadians(Math.atan(Math.tan(goAngle)));
        robot.setAhead(Math.cos(goAngle) * (Math.hypot(goX, goY) + 20.0));
    }

    public ArrayList<Path> precisePredict(Wave ew, double maxVelocity, MovementPredictor.PredictionStatus status, double heading) {
        this.cachePoss = new ArrayList();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        Point2D.Double lastPos = new Point2D.Double(predictedStatus.x, predictedStatus.y);
        Point2D.Double cacheCurrentPos = new Point2D.Double();
        do {
            predictedStatus = MovementPredictor.predict(predictedStatus, heading, maxVelocity);
            this.cachePos = new Path();
            this.cachePos.status = predictedStatus;
            this.cachePos.maxVelocity = maxVelocity;
            this.cachePos.heading = predictedStatus.heading;
            cacheCurrentPos.setLocation(predictedStatus.x, predictedStatus.y);
            this.cachePoss.add(this.cachePos);
            lastPos.setLocation(predictedStatus.x, predictedStatus.y);
            ++counter;
            if (predictedStatus.distance(ew) < ew.distanceTraveled + (double)counter * ew.bulletVelocity() + ew.bulletVelocity()) {
                intercepted = true;
            }
            if (_fieldRect.contains(predictedStatus.x, predictedStatus.y)) continue;
            intercepted = true;
        } while (!intercepted && counter < 20);
        return this.cachePoss;
    }

    public ArrayList<Path> meleePredict(double maxVelocity, MovementPredictor.PredictionStatus status, double heading, double targetDistance) {
        this.cachePoss = new ArrayList();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        Point2D.Double lastPos = new Point2D.Double(predictedStatus.x, predictedStatus.y);
        Point2D.Double cacheCurrentPos = new Point2D.Double();
        do {
            predictedStatus = MovementPredictor.predict(predictedStatus, heading, maxVelocity);
            this.cachePos = new Path();
            this.cachePos.status = predictedStatus;
            this.cachePos.maxVelocity = maxVelocity;
            this.cachePos.heading = predictedStatus.heading;
            cacheCurrentPos.setLocation(predictedStatus.x, predictedStatus.y);
            this.cachePoss.add(this.cachePos);
            lastPos.setLocation(predictedStatus.x, predictedStatus.y);
            ++counter;
            if (predictedStatus.distance(_myLocation) > targetDistance) {
                intercepted = true;
            }
            if (_fieldRect.contains(predictedStatus.x, predictedStatus.y)) continue;
            intercepted = true;
        } while (!intercepted);
        return this.cachePoss;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, this.bfWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this.bfHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this.bfWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.bfHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!_fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005)) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, this.bfWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.bfHeight - testY - 18.0);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    public void updateNeighbors(Wave enemyWave) {
        enemyWave.dangers = new ArrayList();
        BotState en = IoliteRadar.getEnemy(enemyWave.enemyData.name);
        ArrayList<WeightedData<Data>> nearestNeighbors = this.getNearestNeighbors(enemyWave);
        enemyWave.nearestNeighbors = nearestNeighbors;
        int neiCount = 0;
        for (WeightedData<Data> neighbor : enemyWave.nearestNeighbors) {
            ++neiCount;
            if (neighbor.modelPointer.isQuickTargeting) continue;
            neighbor.listData = new ArrayList();
            int dataCount = 0;
            if (neighbor.list == null) continue;
            for (Data data : neighbor.list) {
                ++dataCount;
                neighbor.listData.add(data);
            }
        }
    }

    public void updateBins(Wave enemyWave, Graphics2D g) {
        int numBins = BINS;
        double halfBins = (double)(numBins - 1) / 2.0;
        double[] gfDangers = new double[numBins];
        double[] gfShadowed = enemyWave.shadowBins;
        double minDanger = Double.POSITIVE_INFINITY;
        double maxDanger = Double.NEGATIVE_INFINITY;
        Point2D.Double maxDangerPos = null;
        for (int x = 0; x <= numBins - 1; ++x) {
            double gf = ((double)x - halfBins) / halfBins;
            double bearingOffset = enemyWave.direction * (gf * IUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
            double absFiringAngle = enemyWave.directAngle + bearingOffset;
            Point2D.Double dangerLocation = IUtils.project(enemyWave, absFiringAngle, enemyWave.distanceTraveled + enemyWave.bulletVelocity());
            gfDangers[x] = this.getDangerScore(enemyWave, dangerLocation, g, true);
            int n = x;
            gfDangers[n] = gfDangers[n] * gfShadowed[x];
            if (gfDangers[x] < minDanger) {
                minDanger = gfDangers[x];
            }
            if (!(gfDangers[x] > maxDanger)) continue;
            maxDanger = gfDangers[x];
            maxDangerPos = dangerLocation;
        }
        enemyWave.minDanger = minDanger;
        enemyWave.maxDanger = maxDanger;
        enemyWave.surfBins = gfDangers;
    }

    public void onPaint(Graphics2D g) {
        this.paint = true;
        if (!this.oldPaint) {
            this.oldPaint = this.paint;
            return;
        }
        g.setColor(Color.green);
        BotState en = IoliteRadar.getNearestEnemy();
        g.drawString("desired distance: " + DESIRED_DISTANCE, 10, 20);
        if (en != null) {
            g.drawString("current distance: " + en.distance(_myLocation), 10, 40);
        }
        g.drawString("my velocity: " + this.robot.getVelocity(), 10, 60);
        if (this.robot.getOthers() <= 1 && en != null) {
            int treeCount = 0;
            for (KNNModel<Data> kNNModel : en.surfKNNModels) {
                g.drawString("[surf] " + kNNModel.name + ": " + kNNModel.modelWeight, 10, (int)this.fieldHeight - 10 * ++treeCount);
            }
            for (KNNModel<Data> kNNModel : en.surfTickFlattenerModels) {
                g.drawString("[tickflattener] " + kNNModel.name + ": " + kNNModel.modelWeight, 10, (int)this.fieldHeight - 10 * ++treeCount);
            }
            for (KNNModel<Data> kNNModel : en.surfFlattenerModels) {
                g.drawString("[flattener] " + kNNModel.name + ": " + kNNModel.modelWeight, 10, (int)this.fieldHeight - 10 * ++treeCount);
            }
            for (DangerModel dangerModel : en.surfQuickModels) {
                g.drawString("[quick] " + dangerModel.name + ": " + dangerModel.modelWeight, 10, (int)this.fieldHeight - 10 * ++treeCount);
            }
            ++treeCount;
            for (KNNModel kNNModel : en.surfMeleeKNNModels) {
                g.drawString("[melee] " + kNNModel.name + ": " + kNNModel.modelWeight, 10, (int)this.fieldHeight - 10 * ++treeCount);
            }
        }
        g.setColor(Color.red);
        int numBins = BINS;
        double halfBins = (double)(numBins - 1) / 2.0;
        double[] gfDangers = new double[numBins];
        double[] gfShadowed = new double[numBins];
        Intersection intersection = new Intersection(0.0, 0.0);
        Point2D.Double dangerLocation = new Point2D.Double();
        Point2D.Double oldDrawLocation = new Point2D.Double();
        Point2D.Double drawLocation = new Point2D.Double();
        Point2D.Double drawLocationBuffer = null;
        for (Wave enemyWave : this._enemyWaves) {
            if (enemyWave.rammerWave) {
                g.setColor(Color.yellow);
            } else {
                g.setColor(Color.red);
            }
            int radius = (int)(enemyWave.distanceTraveled + enemyWave.bulletVelocity());
            double minDanger = Double.POSITIVE_INFINITY;
            double maxDanger = Double.NEGATIVE_INFINITY;
            double maxPointDanger = Double.NEGATIVE_INFINITY;
            Point2D.Double maxDangerPos = null;
            gfDangers = enemyWave.surfBins;
            minDanger = enemyWave.minDanger;
            maxDanger = enemyWave.maxDanger;
            gfShadowed = enemyWave.shadowBins;
            for (int x = 0; x <= numBins - 1; ++x) {
                double gf = ((double)x - halfBins) / halfBins;
                double bearingOffset = enemyWave.direction * (gf * IUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
                IUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 10.0 + enemyWave.bulletVelocity(), drawLocation);
                if (maxPointDanger < gfDangers[x]) {
                    maxPointDanger = gfDangers[x];
                    maxDangerPos = new Point2D.Double(drawLocation.x, drawLocation.y);
                }
                Color binColor = this.getColorForHitRate(gfDangers[x] / maxDanger);
                g.setColor(binColor);
                if (gfShadowed[x] < 1.0) {
                    g.setColor(Color.white);
                }
                if (oldDrawLocation != null && x > 0) {
                    Stroke cache = g.getStroke();
                    g.setStroke(this.bs);
                    g.drawLine((int)oldDrawLocation.x, (int)oldDrawLocation.y, (int)drawLocation.x, (int)drawLocation.y);
                    g.setStroke(cache);
                } else {
                    g.fillOval((int)drawLocation.x - 2, (int)drawLocation.y - 2, 4, 4);
                }
                drawLocationBuffer = oldDrawLocation;
                oldDrawLocation = drawLocation;
                drawLocation = drawLocationBuffer;
            }
            this.drawHitWidth(g, enemyWave, _myLocation, Color.yellow);
            if (this.bestPaths != null && this.bestPaths.contains(this.bestPath)) {
                int bestIndex = this.bestPaths.indexOf(this.bestPath);
                if (enemyWave == this.bestPath.wave) {
                    this.drawHitWidth(g, enemyWave, this.bestPaths.get((int)bestIndex).status, Color.white);
                }
                if (this.bestSecondResult != null && this.bestSecondResult.pathList != null) {
                    Path bestThirdPath;
                    Path bestSecondPath = this.bestSecondResult.pathList.get(Math.max(0, this.bestSecondResult.pathList.size() - 1));
                    if (bestSecondPath != null && enemyWave == bestSecondPath.wave) {
                        this.drawHitWidth(g, enemyWave, bestSecondPath.status, Color.white);
                    }
                    if (this.bestSecondResult.deeperResult != null && this.bestSecondResult.deeperResult.pathList != null && (bestThirdPath = this.bestSecondResult.deeperResult.pathList.get(Math.max(0, this.bestSecondResult.deeperResult.pathList.size() - 1))) != null && enemyWave == bestThirdPath.wave) {
                        this.drawHitWidth(g, enemyWave, bestThirdPath.status, Color.white);
                    }
                }
            }
            double gf = (this.getFactorIndex(enemyWave, _myLocation) - (double)MIDDLE_BIN) / (double)MIDDLE_BIN;
            double bearingOffset = enemyWave.direction * (gf * IUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
            IUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 10.0, drawLocation);
            g.setColor(Color.white);
            g.fillOval((int)drawLocation.x - 4, (int)drawLocation.y - 4, 8, 8);
            g.setColor(Color.red);
            g.fillOval((int)drawLocation.x - 3, (int)drawLocation.y - 3, 6, 6);
            if (maxDangerPos != null) {
                g.setColor(Color.gray);
                g.drawOval((int)enemyWave.x - 2, (int)enemyWave.y - 2, 4, 4);
                Point2D.Double pos = IUtils.project(enemyWave, IUtils.absoluteBearing(enemyWave, maxDangerPos), enemyWave.distanceTraveled);
                g.drawOval((int)pos.x - 2, (int)pos.y - 2, 4, 4);
                g.drawLine((int)enemyWave.x, (int)enemyWave.y, (int)pos.x, (int)pos.y);
            }
            for (Wave.BulletShadow shadow : enemyWave.shadows) {
                Point2D.Double pos = IUtils.project(enemyWave, enemyWave.firingAngle(shadow.maxAngle), enemyWave.distanceTraveled);
                Point2D.Double pos2 = IUtils.project(enemyWave, enemyWave.firingAngle(shadow.minAngle), enemyWave.distanceTraveled);
                g.setColor(Color.green);
                g.drawLine((int)pos.x, (int)pos.y, (int)pos2.x, (int)pos2.y);
            }
        }
    }

    public void drawHitWidth(Graphics2D g, Wave enemyWave, Point2D.Double pos, Color color) {
        double bandwidth = 36.0 / enemyWave.distance(pos);
        Point2D.Double drawLocation = new Point2D.Double();
        bandwidth = 36.0;
        double bin1 = this.getFactorIndex(enemyWave, MeleeSurfing.project(pos, MeleeSurfing.absoluteBearing(enemyWave, pos) + 1.5707963267948966, bandwidth / 2.0));
        double bin2 = this.getFactorIndex(enemyWave, MeleeSurfing.project(pos, MeleeSurfing.absoluteBearing(enemyWave, pos) - 1.5707963267948966, bandwidth / 2.0));
        int fromBin = (int)Math.ceil(Math.min(bin1, bin2));
        int toBin = (int)Math.floor(Math.max(bin1, bin2));
        double gf = (double)(fromBin - MIDDLE_BIN) / (double)MIDDLE_BIN;
        double bearingOffset = enemyWave.direction * (gf * IUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
        IUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled + 15.0, drawLocation);
        Point2D.Double linePos = MeleeSurfing.project(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 15.0);
        g.setColor(color);
        g.drawLine((int)linePos.x, (int)linePos.y, (int)drawLocation.x, (int)drawLocation.y);
        gf = (double)(toBin - MIDDLE_BIN) / (double)MIDDLE_BIN;
        bearingOffset = enemyWave.direction * (gf * IUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
        IUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled + 15.0, drawLocation);
        linePos = MeleeSurfing.project(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 15.0);
        g.setColor(color);
        g.drawLine((int)linePos.x, (int)linePos.y, (int)drawLocation.x, (int)drawLocation.y);
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)IUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)IUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0));
    }

    public double square(double d) {
        return d * d;
    }

    public double standardDeviation(double[] values) {
        double avg = this.average(values);
        double sumSquares = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sumSquares += this.square(avg - values[x]);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public double average(double[] values) {
        double sum = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sum += values[x];
        }
        return sum / (double)values.length;
    }

    public Color getColorForHitRate(double d) {
        double colorAmp = 0.7;
        return new Color(Color.HSBtoRGB((float)(0.7 - Math.min(0.7, colorAmp * d)), 1.0f, 1.0f));
    }

    public double wallSmooth(Point2D.Double pos, double angle, int direction) {
        boolean clockwise;
        double TOP = this.fieldHeight - 18.0;
        double RIGHT = this.fieldWidth - 18.0;
        double BOTTOM = 18.0;
        double LEFT = 18.0;
        double N = Math.PI * 2;
        double E = 1.5707963267948966;
        double S = Math.PI;
        double W = 4.71238898038469;
        double s = 8.0;
        double x = pos.x;
        double y = pos.y;
        double a = angle;
        boolean bl = clockwise = direction > 0;
        if (clockwise) {
            if (S < a) {
                if (this.shouldSmooth(a - S, LEFT - x, s)) {
                    a = this.smooth(a - S, LEFT - x, s) + S;
                }
            } else if (a < S && this.shouldSmooth(a, x - RIGHT, s)) {
                a = this.smooth(a, x - RIGHT, s);
            }
            if (W < a || a < E) {
                if (this.shouldSmooth(a + E, y - TOP, s)) {
                    a = this.smooth(a + E, y - TOP, s) - E;
                }
            } else if (E < a && a < W && this.shouldSmooth(a - E, BOTTOM - y, s)) {
                a = this.smooth(a - E, BOTTOM - y, s) + E;
            }
        } else {
            if (S < a) {
                if (this.shouldSmooth(N - a, LEFT - x, s)) {
                    a = N - this.smooth(N - a, LEFT - x, s);
                }
            } else if (a < S && this.shouldSmooth(S - a, x - RIGHT, s)) {
                a = S - this.smooth(S - a, x - RIGHT, s);
            }
            if (W < a || a < E) {
                if (this.shouldSmooth(E - a, y - TOP, s)) {
                    a = E - this.smooth(E - a, y - TOP, s);
                }
            } else if (E < a && a < W && this.shouldSmooth(W - a, BOTTOM - y, s)) {
                a = W - this.smooth(W - a, BOTTOM - y, s);
            }
        }
        return a;
    }

    private double smooth(double a, double x, double s) {
        double nextX = x + s * Math.sin(a);
        if (0.0 <= nextX) {
            return Math.PI;
        }
        return Math.acos(-nextX / this.r - 1.0);
    }

    private boolean shouldSmooth(double a, double x, double s) {
        double nextX = x + s * Math.sin(a);
        if (nextX < -this.d) {
            return false;
        }
        if (0.0 <= nextX) {
            return true;
        }
        return 0.0 < nextX + this.r * (Math.cos(a) + 1.0);
    }

    public double wallSmoothing(Point2D.Double startLocation, double startAngle, int orientation, double wallStick) {
        double width = this.fieldWidth;
        double height = this.fieldHeight;
        double wallDistanceX = Math.min(startLocation.x - 18.0, width - startLocation.x - 18.0);
        double wallDistanceY = Math.min(startLocation.y - 18.0, height - startLocation.y - 18.0);
        if (wallDistanceX > wallStick && wallDistanceY > wallStick) {
            return startAngle;
        }
        double angle = startAngle;
        double testX = startLocation.x + Math.sin(angle) * wallStick;
        double testY = startLocation.y + Math.cos(angle) * wallStick;
        double testDistanceX = Math.min(testX - 18.0, width - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, height - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while ((testDistanceX < 0.0 || testDistanceY < 0.0) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = testY < 18.0 ? Math.PI : 0.0;
                adjacent = wallDistanceY;
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = testX < 18.0 ? 4.71238898038469 : 1.5707963267948966;
                adjacent = wallDistanceX;
            }
            if (adjacent < 0.0) {
                if (-adjacent > wallStick) {
                    wallStick += -adjacent;
                }
                angle += Math.PI - (double)orientation * (Math.abs(Math.acos(-adjacent / wallStick)) - 5.0E-4);
            } else {
                angle += (double)orientation * (Math.abs(Math.acos(adjacent / wallStick)) + 5.0E-4);
            }
            testX = startLocation.x + Math.sin(angle) * wallStick;
            testY = startLocation.y + Math.cos(angle) * wallStick;
            testDistanceX = Math.min(testX - 18.0, width - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, height - testY - 18.0);
        }
        return angle;
    }

    static {
        actualBulletCount = 1.0;
        hitBulletCount = 0.0;
        allBulletCount = 1.0;
        allHitBulletCount = 0.0;
        WALL_STICK = 160.5450131316624;
        energy = 100.0;
        guessFactors = new double[]{0.0, 0.85, 1.0, -1.0};
        weights = new double[]{3.0, 1.0, 1.0, 1.75};
        antiMirrorPos = new Point2D.Double();
        DESIRED_DISTANCE = 650.0;
        MAX_ATTACK_ANGLE = 1.413716694115407;
    }

    private static class DistanceController {
        private DistanceController() {
        }

        public double surfAttackAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.65);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            return this.attackAngle(currentDistance, 0.6);
        }

        public double surfEscapeFromRamAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.5);
            }
            return this.attackAngle(currentDistance, 1.0);
        }

        public double orbitAttackAngle(double currentDistance) {
            return this.attackAngle(currentDistance, 1.65);
        }

        private double attackAngle(double currentDistance, double offsetMultiplier) {
            double distanceFactor = (currentDistance - DESIRED_DISTANCE) / DESIRED_DISTANCE;
            return IUtils.limit(-MAX_ATTACK_ANGLE, distanceFactor * offsetMultiplier, MAX_ATTACK_ANGLE);
        }
    }

    public static class Intersection {
        public double angle;
        public double bandwidth;
        public Point2D.Double pos;

        public Intersection(double angle, double bandwidth) {
            this.angle = angle;
            this.bandwidth = bandwidth;
        }
    }

    public static class Result {
        public ArrayList<Path> pathList;
        public double danger;
        public Result deeperResult;

        public Result(ArrayList<Path> pathList, double danger) {
            this.pathList = pathList;
            this.danger = danger;
        }
    }

    public class Path {
        MovementPredictor.PredictionStatus status;
        public double maxVelocity = 8.0;
        public double heading;
        public Result result;
        public Wave wave;
    }
}

