/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Utils;

import java.util.ArrayList;
import rdt.Wraith.EnemyPrediction.PredictedPosition;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Utils.MoveToCalculator;
import robocode.util.Utils;

public class FastMoveInterceptLookup {
    private static final int NUM_RELATIVE_HEADING_DIVISIONS = 1441;
    private static final double RAD_TO_INDEX = 229.1831180523293;
    private static final double INDEX_TO_RAD = 0.004363323129985824;
    private static final int VELOCITY_ACCURACY = 1;
    private static final int NUM_VELOCITY_DIVISIONS = 9;
    private static final double INDEX_TO_VELOCITY = 1.0;
    private static final double VELOCITY_TO_INDEX = 1.0;
    private static final MovementData[][] CachedMovementData = new MovementData[1441][9];

    public static double GetDistanceCanMove(double startX, double startY, double startAbsHeading, double initialAbsVelocity, double targetX, double targetY, long durationTicks) {
        double startToTargetAbsHeading = MathUtils.GetAngle(startX, startY, targetX, targetY);
        double relativeHeadingChange = Utils.normalRelativeAngle((double)(startToTargetAbsHeading - startAbsHeading));
        int angleIndex = (int)(229.1831180523293 * (relativeHeadingChange + Math.PI) + 0.5);
        int velocityIndex = (int)(1.0 * initialAbsVelocity + 0.5);
        MovementData data = CachedMovementData[angleIndex][velocityIndex];
        double distanceCovered = data.DistancePerTick[(int)durationTicks];
        return distanceCovered;
    }

    public static boolean CanBeIntercepted(double startX, double startY, double startAbsHeading, double initialAbsVelocity, double targetX, double targetY, long durationTicks) {
        double startToTargetAbsHeading = MathUtils.GetAngle(startX, startY, targetX, targetY);
        double relativeHeadingChange = Utils.normalRelativeAngle((double)(startToTargetAbsHeading - startAbsHeading));
        int angleIndex = (int)(229.1831180523293 * (relativeHeadingChange + Math.PI) + 0.5);
        int velocityIndex = (int)(1.0 * initialAbsVelocity + 0.5);
        MovementData data = CachedMovementData[angleIndex][velocityIndex];
        double distanceCovered = data.DistancePerTick[(int)durationTicks];
        double dX = targetX - startX;
        double dY = targetY - startY;
        double distanceFromStartToTargetSq = dX * dX + dY * dY;
        return distanceCovered * distanceCovered >= distanceFromStartToTargetSq;
    }

    public static double GetSmallestBulletInterceptDistanceAlongVector(double bulletOriginX, double bulletOriginY, double bulletVelocity, double startX, double startY, double startAbsHeading, double initialAbsVelocity, double movementDX, double movementDY) {
        double botY;
        double deltaToBulletOriginY;
        double distanceCovered;
        double botX;
        double deltaToBulletOriginX;
        double distanceToBulletOriginSq;
        double startToTargetAbsHeading = MathUtils.GetAngle(startX, startY, startX + movementDX, startY + movementDY);
        double relativeHeadingChange = Utils.normalRelativeAngle((double)(startToTargetAbsHeading - startAbsHeading));
        int angleIndex = (int)(229.1831180523293 * (relativeHeadingChange + Math.PI) + 0.5);
        int velocityIndex = (int)(1.0 * initialAbsVelocity + 0.5);
        MovementData data = CachedMovementData[angleIndex][velocityIndex];
        double bulletDistance = 0.0;
        long numTicks = 0L;
        while (!((distanceToBulletOriginSq = (deltaToBulletOriginX = bulletOriginX - (botX = startX + movementDX * (distanceCovered = data.DistancePerTick[(int)(++numTicks)]))) * deltaToBulletOriginX + (deltaToBulletOriginY = bulletOriginY - (botY = startY + movementDY * distanceCovered)) * deltaToBulletOriginY) <= (bulletDistance += bulletVelocity) * bulletDistance)) {
        }
        return distanceCovered;
    }

    private static MovementData GenerateCachedMovementData(double deltaHeadingRadians, double initialVelocity) {
        double dX = MathUtils.FastSin(deltaHeadingRadians);
        double dY = MathUtils.FastCos(deltaHeadingRadians);
        double targetX = dX * 1000.0;
        double targetY = dY * 1000.0;
        ArrayList<PredictedPosition> predictedPositions = MoveToCalculator.PredictRouteToXY(0.0, 0.0, 0.0, initialVelocity, targetX, targetY);
        double[] distancePerTick = new double[predictedPositions.size()];
        for (int tick = 0; tick < predictedPositions.size(); ++tick) {
            double distanceToStart;
            PredictedPosition position = predictedPositions.get(tick);
            distancePerTick[tick] = distanceToStart = Math.sqrt(position.X * position.X + position.Y * position.Y);
        }
        return new MovementData(distancePerTick, deltaHeadingRadians, initialVelocity);
    }

    static {
        for (int headingIndex = 0; headingIndex < 1441; ++headingIndex) {
            double headingDeltaRadians = (double)headingIndex * 0.004363323129985824 - Math.PI;
            for (int velocityIndex = 0; velocityIndex < 9; ++velocityIndex) {
                double initialVelocity = (double)velocityIndex * 1.0;
                FastMoveInterceptLookup.CachedMovementData[headingIndex][velocityIndex] = FastMoveInterceptLookup.GenerateCachedMovementData(headingDeltaRadians, initialVelocity);
            }
        }
    }

    private static final class MovementData {
        public final double[] DistancePerTick;
        public final double DeltaRadians;
        public final double Velocity;

        public MovementData(double[] distancePerTick, double deltaRadians, double velocity) {
            this.DistancePerTick = distancePerTick;
            this.DeltaRadians = deltaRadians;
            this.Velocity = velocity;
        }
    }
}

