/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.text.NumberFormat;
import robocode.AdvancedRobot;
import taqho.GameInfo;
import taqho.MathUtils;
import taqho.RobotData;

public class GunManager {
    protected static AdvancedRobot robot = null;
    protected static double gunHeading;
    protected double robotEnergy;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public GunManager() {
        robot = GameInfo.getRobot();
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void updateTick() {
        gunHeading = robot.getGunHeading();
        this.robotEnergy = robot.getEnergy();
    }

    public boolean trackAndShoot(RobotData r) {
        if (r != null && robot.getGunTurnRemaining() == 0.0) {
            double power = this.getFirePower(r);
            double absBearing = r.getBearingToShootAt(this.getBulletVelocity(power));
            double turnTo = gunHeading - absBearing;
            turnTo = MathUtils.normaliseBearingDegrees(turnTo);
            robot.setTurnGunLeft(turnTo);
            if (robot.getGunHeat() == 0.0 && !GameInfo.skipFire) {
                robot.setFire(power);
                return true;
            }
            return false;
        }
        return false;
    }

    public double getBulletVelocity(double power) {
        if (power <= 3.0) {
            return 20.0 - 3.0 * power;
        }
        return 11.0;
    }

    public double getFirePower(RobotData r) {
        double power = 3.0;
        double damage = power * 4.0;
        if (power >= 1.0) {
            damage += (power - 1.0) * 2.0;
        }
        if (damage > r.energy) {
            power = r.distance < 200.0 && r.energy < this.robotEnergy && this.robotEnergy > 20.0 ? this.getPowerToCauseDamage(r.energy - 0.1, r) : this.getPowerToCauseDamage(r.energy, r);
        }
        if (power > this.robotEnergy) {
            power = this.robotEnergy;
        }
        return power;
    }

    public double getPowerToCauseDamage(double damage, RobotData r) {
        if (damage > 16.0) {
            if (r.distance < 400.0 || Math.random() < 0.25) {
                return 2.75 + Math.random() * 0.25;
            }
            return 2.4 + Math.random() * 0.2;
        }
        if (damage > 4.0) {
            return (damage + 2.0) / 6.0;
        }
        if (damage > 0.3) {
            return damage / 4.0;
        }
        return 0.1;
    }
}

