/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import pedersen.core.GameState;
import pedersen.debug.DebuggableBase;
import pedersen.physics.Firepower;
import pedersen.util.Constraints;
import pedersen.util.Conversions;

public class Metrics
extends DebuggableBase {
    private static final Metrics instance = new Metrics();
    private long turnsProcessed = 0L;
    private long exceptionsThrown = 0L;
    private long firedShotCount = 0L;
    private int[] place = new int[10];
    private double energyGainDueToShotFired = 0.0;
    private double energyLossDueToShotFired = 0.0;
    private double energyLossDueToDamageTaken = 0.0;
    private double energyLossCausedToTarget = 0.0;
    private double speedTotal = 0.0;
    private long speedCount = 0L;
    private long targetCount = 0L;
    private long teammateCount = 0L;
    private long firingSolutionCount = 0L;

    public void incrementTurnCount() {
        ++this.turnsProcessed;
    }

    public void incrementExceptionCount() {
        ++this.exceptionsThrown;
    }

    public void incrementFiringSolutionCount() {
        ++this.firingSolutionCount;
    }

    public void place(int enemiesRemaining) {
        if (Constraints.isInRange(0, enemiesRemaining, this.place.length - 1)) {
            int n = enemiesRemaining;
            this.place[n] = this.place[n] + 1;
        }
    }

    public void shotFired(Firepower firepower) {
        ++this.firedShotCount;
        this.energyLossDueToShotFired += firepower.firepower();
    }

    public void bulletHitTarget(double firepower) {
        this.energyGainDueToShotFired += Conversions.getEnergyRewardFromFirepower(firepower);
        this.energyLossCausedToTarget += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public void bulletHitCombatant(double firepower) {
        this.energyLossDueToDamageTaken += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public long getFiredShotCount() {
        return this.firedShotCount;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n").append(this.getClass().getSimpleName());
        buffer.append("\n").append(" - Match Statistics - ");
        buffer.append("\n").append("Turns processed: " + this.turnsProcessed);
        buffer.append("\n").append("Exceptions thrown: " + this.exceptionsThrown);
        buffer.append("\n").append("Average firepower: " + super.trim(this.energyLossDueToShotFired / (double)this.firedShotCount));
        buffer.append("\n").append("Average speed: " + super.trim(this.getAverageSpeed()));
        buffer.append("\n").append("Finished 1st: " + this.place[0]);
        buffer.append("\n").append("Finished 2nd: " + this.place[1]);
        if (this.place[2] + this.place[3] + this.place[4] + this.place[5] + this.place[6] + this.place[7] + this.place[8] + this.place[9] > 0) {
            buffer.append("\n").append("Finished 3rd: " + this.place[2]);
            int i = 3;
            while (i < this.place.length) {
                buffer.append("\n").append("Finished " + (i + 1) + "th: " + this.place[i]);
                ++i;
            }
        }
        long roundCount = GameState.getInstance().getRounds();
        buffer.append("\n").append(" - Energy Management Statistics - ");
        buffer.append("\n").append("energyGainDueToShotFired: ").append(super.trim(this.energyGainDueToShotFired / (double)roundCount));
        buffer.append("\n").append("energyLossDueToShotFired: ").append(super.trim(this.energyLossDueToShotFired / (double)roundCount));
        buffer.append("\n").append("energyLossCausedToTarget: ").append(super.trim(this.energyLossCausedToTarget / (double)roundCount));
        buffer.append("\n").append("energyLossDueToDamageTaken: ").append(super.trim(this.energyLossDueToDamageTaken / (double)roundCount));
        buffer.append("\n").append("energyAdvantagePerShot: ").append(super.trim((this.energyLossCausedToTarget + this.energyGainDueToShotFired - this.energyLossDueToShotFired) / (double)this.firedShotCount));
        return buffer.toString();
    }

    public void addSpeed(double newSpeed) {
        this.speedTotal += Math.abs(newSpeed);
        ++this.speedCount;
    }

    public double getAverageSpeed() {
        return this.speedTotal / (double)this.speedCount;
    }

    public void incrementTargetCount() {
        ++this.targetCount;
    }

    public long getTargetCount() {
        return this.targetCount;
    }

    public void incrementTeammateCount() {
        ++this.teammateCount;
    }

    public long getTeammateCount() {
        return this.teammateCount;
    }

    public static Metrics getInstance() {
        return instance;
    }
}

