/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.segmentation;

import pedersen.divination.CombatWave;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.segmentation.Segment;
import pedersen.util.UnsupportedEnumException;

public enum FixedSegment implements Segment
{
    WALL_DISTANCE_CLOCKWISE(5),
    WALL_DISTANCE_COUNTERCLOCKWISE(5),
    DISTANCE_TO_TARGET(5);

    public final int slices;

    private FixedSegment(int slices) {
        this.slices = slices;
    }

    @Override
    public int getIndex(CombatWave wave, TargetAnalysis targetAnalysis, int slices) {
        if (slices != this.slices) {
            System.out.println("Segment " + this.toString() + " has a fixed slice count of " + this.slices + ".  A slice count of " + slices + " was requested.");
            return 0;
        }
        switch (this) {
            case WALL_DISTANCE_CLOCKWISE: {
                double value = targetAnalysis.originalPosDistanceToWall;
                if (value < 80.0) {
                    return 1;
                }
                if (value < 160.0) {
                    return 2;
                }
                if (value < 240.0) {
                    return 3;
                }
                if (value < 320.0) {
                    return 4;
                }
                return 0;
            }
            case WALL_DISTANCE_COUNTERCLOCKWISE: {
                double value = targetAnalysis.originalNegDistanceToWall;
                if (value < 80.0) {
                    return 1;
                }
                if (value < 160.0) {
                    return 2;
                }
                if (value < 240.0) {
                    return 3;
                }
                if (value < 320.0) {
                    return 4;
                }
                return 0;
            }
            case DISTANCE_TO_TARGET: {
                double value = targetAnalysis.originalDistanceToTarget;
                if (value < 80.0) {
                    return 1;
                }
                if (value < 160.0) {
                    return 2;
                }
                if (value < 240.0) {
                    return 3;
                }
                if (value < 320.0) {
                    return 4;
                }
                return 0;
            }
        }
        throw new UnsupportedEnumException(this);
    }

    @Override
    public void debug(CombatWave wave, TargetAnalysis targetAnalysis) {
        switch (this) {
            case WALL_DISTANCE_CLOCKWISE: {
                System.out.println(targetAnalysis.originalPosDistanceToWall);
                return;
            }
            case WALL_DISTANCE_COUNTERCLOCKWISE: {
                System.out.println(targetAnalysis.originalNegDistanceToWall);
                return;
            }
            case DISTANCE_TO_TARGET: {
                System.out.println(targetAnalysis.originalDistanceToTarget);
                return;
            }
        }
        throw new UnsupportedEnumException(this);
    }
}

