/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import java.awt.Color;
import java.util.LinkedList;
import java.util.Queue;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.CombatWaveBank;
import pedersen.movement.MovementMethod;
import pedersen.movement.MovementMethodBase;
import pedersen.physics.Distance;
import pedersen.physics.Position;
import pedersen.physics.Vehicle;
import pedersen.physics.VelocityVector;
import pedersen.systems.chassis.ChassisSubsystem;
import pedersen.util.Arena;

public abstract class MovementMethodAbsoluteBase
extends MovementMethodBase
implements MovementMethod {
    public static final Queue<VelocityVector> predictedMovementVectors = new LinkedList<VelocityVector>();
    public static final Queue<Position> predictedPositions = new LinkedList<Position>();

    protected boolean isDestinationViable(long time, Vehicle originalVehicle, Vehicle destinationVehicle, Position unsafePosition) {
        Position graphingReferencePoint = originalVehicle.getPosition();
        boolean isOriginalPositionUnsafe = this.isUnsafeDistance(originalVehicle.getPosition(), unsafePosition);
        Distance originalDistanceToUnsafePosition = unsafePosition == null ? null : originalVehicle.getPosition().getDistance(unsafePosition);
        boolean isDestinationViable = false;
        boolean intercepted = CombatWaveBank.getInstance().doesAnyInboundWaveInterceptChassisPosition(time, destinationVehicle);
        if (CombatWaveBank.getInstance().isWaveInbound()) {
            Vehicle projectedVehicle = originalVehicle;
            int i = 0;
            while (i < 1000 && !intercepted && !projectedVehicle.getPosition().equalsPosition(destinationVehicle)) {
                intercepted = this.doesAnyWaveInterceptVehicle(projectedVehicle, time + (long)i);
                intercepted = !isOriginalPositionUnsafe ? (intercepted |= this.isUnsafeDistance(projectedVehicle.getPosition(), unsafePosition)) : (intercepted |= this.isCloser(originalDistanceToUnsafePosition, projectedVehicle.getPosition(), unsafePosition));
                if (!intercepted) {
                    VelocityVector movementVector = ChassisSubsystem.navigation.getAbsoluteMovementVector(projectedVehicle, destinationVehicle);
                    predictedMovementVectors.add(movementVector);
                    projectedVehicle = projectedVehicle.getQualifiedFuturePosition(movementVector);
                    predictedPositions.add(projectedVehicle.getPosition());
                    boolean bl = intercepted = !Arena.singleton.isVehicleCenterInBoundary(projectedVehicle);
                    if (GraphicalDebugger.paintMovementMethods) {
                        GraphicalDebugger.addLineRoundScope(graphingReferencePoint, projectedVehicle.getPosition(), Color.lightGray);
                    }
                    graphingReferencePoint = projectedVehicle.getPosition();
                }
                ++i;
            }
        }
        isDestinationViable = !intercepted;
        return isDestinationViable;
    }

    private boolean isUnsafeDistance(Position here, Position there) {
        return here != null && there != null && here.getDistance(there).distance() < MovementMethod.safeDistance.distance();
    }

    private boolean isCloser(Distance originalDistance, Position here, Position there) {
        return originalDistance != null && here != null && there != null && here.getDistance(there).distance() < originalDistance.distance();
    }

    private boolean doesAnyWaveInterceptVehicle(Vehicle vehicleChassis, long time) {
        for (CombatWave wave : CombatWaveBank.getInstance().getInboundWaves()) {
            if (!wave.doesAnyFiringSolutionInterceptVehicleChassis(vehicleChassis, time)) continue;
            return true;
        }
        return false;
    }
}

