/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import pedersen.core.Combatant;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.core.Teammate;
import pedersen.debug.DebuggableBase;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.Direction;
import pedersen.physics.HasVehicle;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;
import pedersen.team.communication.CommuniqueMyRadarTarget;
import pedersen.util.Constraints;

public class ScannerSubsystem
extends DebuggableBase
implements OnRound {
    private Target target;
    private boolean targetLock = true;
    private long targetLockTimer = 0L;
    private static ScannerSubsystem singleton = new ScannerSubsystem();
    public static final long mandatorySweepPeriod = 8L;

    private ScannerSubsystem() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public static ScannerSubsystem getInstance() {
        return singleton;
    }

    public void operate(HasVehicle chassisFuturePosition) {
        if (GameState.getInstance().isEveryoneDead()) {
            Instructions.getInstance().setScannerDirectionChange(chassisFuturePosition.getVehicle());
        } else if (!(this.targetLock && this.target != null && this.target.isActive() && Constraints.isInRange(0.0, this.target.getElapsedTimeSinceLastScan(), 2.0))) {
            Instructions.getInstance().setScannerDirectionChange(GameState.getInstance().getScannerHeading().getTangentAngle());
        } else {
            Direction initialAbsoluteHeading = GameState.getInstance().getScannerHeading();
            Direction futureBearingToTarget = chassisFuturePosition.getVehicle().getPosition().getBearing(this.target.getSnapshot());
            double bearingOffset = Math.atan(Constraints.maxAbsVehicleVelocity.velocity() / chassisFuturePosition.getVehicle().getPosition().getDistance(this.target.getSnapshot()).distance());
            if (initialAbsoluteHeading.getRelativeDirection(futureBearingToTarget).getRelativeRadians() < 0.0) {
                bearingOffset = -bearingOffset;
            }
            Direction futureBearingToOffset = futureBearingToTarget.addRadians(bearingOffset);
            Instructions.getInstance().setScannerDirectionChange(futureBearingToOffset);
        }
        --this.targetLockTimer;
        this.enableTargetLock();
        if (GraphicalDebugger.paintScannerSubsystem && this.target != null && this.target.isActive()) {
            GraphicalDebugger.addLineTurnScope(Combatant.getCombatant().getSnapshot().getPosition(), this.target.getSnapshot().getPosition(), Color.yellow);
        }
    }

    public void considerTarget(Target target) {
        this.setTarget(this.getBestTarget());
    }

    private Target getBestTarget() {
        Set<Target> targets = new HashSet<Target>(TargetBank.getInstance().getActiveTargets());
        for (Teammate teammate : Teammate.getLivingTeammates()) {
            targets.remove(teammate.getScannerTarget());
        }
        Target bestTarget = null;
        double bestTargetDistance = Double.POSITIVE_INFINITY;
        if (targets.isEmpty()) {
            targets = TargetBank.getInstance().getActiveTargets();
        }
        for (Target target : targets) {
            double targetDistance = GameState.getInstance().getDistance(target.getSnapshot()).distance();
            if (!(targetDistance < bestTargetDistance)) continue;
            bestTarget = target;
            bestTargetDistance = targetDistance;
        }
        return bestTarget;
    }

    private void setTarget(Target target) {
        Target originalTarget = this.target;
        if (this.target != null && !this.target.isActive()) {
            this.target = null;
        }
        if (this.target == null) {
            this.targetLock = false;
        }
        if (!this.targetLock && target != null && target.isActive()) {
            this.target = target;
        }
        if (this.target != originalTarget && this.target != null) {
            CommunicationSubsystem.getInstance().prepareCommunique(new CommuniqueMyRadarTarget(this.target.getName()));
        }
    }

    public void onRobotDeath(Target target) {
        if (target.equals(this.target)) {
            this.target = null;
            this.releaseTargetLock();
        }
    }

    @Override
    public void onRound(int round) {
        this.target = null;
        this.releaseTargetLock();
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Target: " + (this.target == null ? "(no target)" : this.target.getName()));
        return buffer.toString();
    }

    public void enableTargetLock() {
        if (GameState.getInstance().isInDuelMode() || this.targetLockTimer < 1L) {
            this.targetLock = true;
        }
    }

    public void releaseTargetLock() {
        if (!GameState.getInstance().isInDuelMode()) {
            this.targetLock = false;
            this.targetLockTimer = 8L;
        }
    }
}

