/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems.chassis;

import java.util.Queue;
import pedersen.core.Combatant;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.movement.MovementMethod;
import pedersen.physics.VelocityVector;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.systems.chassis.NavigationMethod;
import pedersen.systems.chassis.NavigationMethodBasicImpl;
import pedersen.systems.notifier.OnHitByBullet;

public class ChassisSubsystem
extends DebuggableBase
implements OnHitByBullet {
    private Queue<MovementMethod> movementMethods = null;
    private MovementMethod movementMethod = null;
    private int gracePeriod = 0;
    private static final ChassisSubsystem singleton = new ChassisSubsystem();
    public static final NavigationMethod navigation = new NavigationMethodBasicImpl();

    private ChassisSubsystem() {
    }

    public static ChassisSubsystem getInstance() {
        return singleton;
    }

    public void setMovementMethods(Queue<MovementMethod> movementMethods, int gracePeriod) {
        this.gracePeriod = gracePeriod;
        this.movementMethods = movementMethods;
        this.onHitByBullet(null);
    }

    public VelocityVector getAbsoluteMovementVector() {
        VelocityVector movementVector = PhysicsConstants.anchorVelocityVector;
        if (this.movementMethod != null) {
            movementVector = navigation.getAbsoluteMovementVector(Combatant.getCombatant().getChassis(), this.movementMethod.getDestination());
        }
        return movementVector;
    }

    public static MovementMethod getOptimalMovementMethod(Queue<MovementMethod> movementMethods, int gracePeriod) {
        MovementMethod preferredMovementMethod = null;
        int preferredHitTally = 0;
        double preferredHitRatio = 0.0;
        boolean movementMethodDetermined = false;
        for (MovementMethod presentMovementMethod : movementMethods) {
            double presentHitRatio;
            int presentHitTally = presentMovementMethod.getHitTally();
            if (preferredMovementMethod == null) {
                preferredMovementMethod = presentMovementMethod;
                preferredHitTally = presentHitTally;
                preferredHitRatio = (double)preferredMovementMethod.getTimeInUse() / (double)preferredHitTally;
                if (preferredHitTally == 0) {
                    movementMethodDetermined = true;
                }
            } else if (presentHitTally < gracePeriod) {
                if (presentHitTally != preferredHitTally && presentHitTally < preferredHitTally) {
                    preferredMovementMethod = presentMovementMethod;
                    preferredHitTally = presentHitTally;
                    preferredHitRatio = (double)preferredMovementMethod.getTimeInUse() / (double)preferredHitTally;
                    movementMethodDetermined = true;
                }
            } else if (preferredHitTally >= gracePeriod && (presentHitRatio = (double)presentMovementMethod.getTimeInUse() / (double)presentHitTally) > preferredHitRatio) {
                preferredMovementMethod = presentMovementMethod;
                preferredHitTally = presentHitTally;
                preferredHitRatio = presentHitRatio;
            }
            if (movementMethodDetermined) break;
        }
        return preferredMovementMethod;
    }

    @Override
    public void onHitByBullet(CombatWave wave) {
        if (this.movementMethod != null) {
            this.movementMethod.deactivate();
        }
        this.movementMethod = ChassisSubsystem.getOptimalMovementMethod(this.movementMethods, this.gracePeriod);
        if (this.movementMethod != null) {
            this.movementMethod.activate();
        }
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        for (MovementMethod e : this.movementMethods) {
            buffer.append("\n").append(e.description());
        }
        return buffer.toString();
    }
}

