/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import robocode.AdvancedRobot;

public class AdvancedMovementRobot
extends AdvancedRobot {
    final double Pi = Math.PI;
    final double Pi2 = Math.PI * 2;
    private boolean forwards = true;

    public void turnTo(double angle) {
        double current_heading = this.getHeadingRadians();
        if (Math.abs(current_heading - (angle = CustFunct.normaliseAbsolute(angle))) > 1.5707963267948966 && this.forwards) {
            this.forwards = false;
        } else if (Math.abs(current_heading - angle) < 1.5707963267948966 && !this.forwards) {
            this.forwards = true;
        }
        double tmp = this.forwards ? CustFunct.normaliseRelative(-(current_heading - angle)) : CustFunct.normaliseRelative(-(Math.PI - angle + current_heading));
        this.setTurnRightRadians(tmp);
    }

    public void turnGunTo(double angle) {
        angle = CustFunct.normaliseAbsolute(angle);
        this.setTurnGunRightRadians(CustFunct.normaliseRelative(-this.getGunHeadingRadians() + angle));
    }

    public long gunTurnTime(double angle) {
        angle = CustFunct.normaliseRelative(-this.getGunHeadingRadians() + CustFunct.normaliseAbsolute(angle));
        int gun_turn_rate = (int)Math.toDegrees(20.0);
        int robot_turn_rate = (int)Math.toDegrees(0.75 * this.getVelocity());
        double robot_turn_remaining = this.getTurnRemainingRadians();
        double angle_time = angle % (double)gun_turn_rate;
        double robot_turn_time = robot_turn_remaining % (double)robot_turn_rate;
        if (angle_time == 0.0 || robot_turn_time == 0.0) {
            return 0L;
        }
        int t = (int)Math.abs(Math.ceil(robot_turn_time + angle_time));
        return t;
    }

    public void reverse() {
        this.forwards = !this.forwards;
        double distance = this.getDistanceRemaining();
        this.setAhead(-distance);
    }

    public void setAhead(double distance) {
        if (this.forwards) {
            super.setAhead(distance);
        } else {
            super.setAhead(-distance);
        }
    }

    public void setBack(double distance) {
        if (this.forwards) {
            super.setAhead(-distance);
        } else {
            super.setAhead(distance);
        }
    }

    public void ahead(double distance) {
        if (this.forwards) {
            super.ahead(distance);
        } else {
            super.ahead(-distance);
        }
    }

    public void back(double distance) {
        if (this.forwards) {
            super.back(-distance);
        } else {
            super.back(distance);
        }
    }
}

