/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.Arena;
import amarok.BotConstants;
import java.util.Random;

public class BotMath
implements BotConstants {
    static Arena arena;
    static Random rnd;

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double NormalizeAngle(double angle) {
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static double normalizeBearing(double angle) {
        return (angle + Math.PI * 7) % (Math.PI * 2) - Math.PI;
    }

    public static double normalizeBearing1(double angle) {
        return (angle + Math.PI * 7) % (Math.PI * 2) + Math.PI;
    }

    public static double getAlpha(double x, double y, double X, double Y) {
        double dx = x - X;
        double dy = y - Y;
        double alpha = Math.atan(dx / dy);
        alpha = dy < 0.0 ? (alpha += Math.PI) : (alpha += Math.PI * 2);
        return BotMath.NormalizeAngle(alpha);
    }

    public static double optimizeOffset(double d) {
        double offset = d;
        if (Math.abs(offset) > Math.PI) {
            offset = offset < 0.0 ? Math.PI * 2 - Math.abs(offset) : (offset -= Math.PI * 2);
        }
        return offset;
    }

    public static boolean randomBoolean() {
        return rnd.nextBoolean();
    }

    public BotMath(Arena a) {
        arena = a;
        rnd = new Random();
    }
}

