/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.BulletLine;
import amarok.Statistics;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class Enemy
implements BotConstants,
Statistics {
    private Arena arena;
    private String name;
    private long time;
    private double bearing;
    private double deltaBearing;
    private double averageBearing;
    private double heading;
    private double deltaHeading;
    private Point2D.Double point;
    private double distance;
    private double sumDistance;
    private double energy;
    private double velocity;
    private double maxVelocity;
    private double averageVelocity;
    private double deltaVelocity;
    private int sumEvents;
    private double deltaEnergy;

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getDeltaBearing() {
        return this.deltaBearing;
    }

    public double getAverageBearing() {
        return this.averageBearing;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getDeltaHeading() {
        return this.deltaHeading;
    }

    public Point2D.Double getPoint() {
        return this.point;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getSumDistance() {
        return this.sumDistance;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public double getAverageVelocity() {
        return this.averageVelocity;
    }

    public double getDeltaVelocity() {
        return this.deltaVelocity;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.deltaEnergy += 4.0 * e.getPower();
        if (e.getBullet().getPower() > 1.0) {
            this.deltaEnergy += 2.0 * (e.getBullet().getPower() - 1.0);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.deltaEnergy -= e.getBullet().getPower() * 4.0;
        if (e.getBullet().getPower() > 1.0) {
            this.deltaEnergy -= 2.0 * (e.getBullet().getPower() - 1.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        AdvancedRobot me = this.arena.getMe();
        this.time = e.getTime();
        double d = (me.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        this.deltaBearing = d - this.bearing;
        this.bearing = d;
        this.averageBearing = (this.averageBearing + this.bearing) / 2.0;
        this.heading = e.getHeadingRadians();
        this.distance = e.getDistance();
        this.sumDistance += this.distance;
        this.deltaVelocity = e.getVelocity() - this.velocity;
        this.velocity = e.getVelocity();
        this.maxVelocity = Math.max(this.velocity, this.maxVelocity);
        this.averageVelocity = (this.averageVelocity + this.velocity) / 2.0;
        double x = me.getX() + Math.sin(this.bearing) * e.getDistance();
        double y = me.getY() + Math.cos(this.bearing) * e.getDistance();
        this.point.setLocation(x, y);
        double dEnergy = this.energy - e.getEnergy() + this.deltaEnergy;
        if (dEnergy >= 0.1 && dEnergy <= 3.0) {
            double vel = 20.0 - 3.0 * dEnergy;
            double velMe = me.getVelocity();
            double heading = BotMath.getAlpha(me.getX(), me.getY(), x, y);
            double headingMe = me.getHeadingRadians();
            double distance = BotMath.getDistance(x, y, me.getX(), me.getY());
            long expiringTime = this.time + (long)(distance / vel);
            double relativeHeading = headingMe - heading;
            double hVelocity = velMe * Math.sin(relativeHeading);
            double leadAngle = Math.asin(hVelocity / (20.0 - 3.0 * dEnergy));
            this.arena.addBullet(new BulletLine(this.name, x, y, leadAngle / 2.0 + heading, vel, this.time, expiringTime));
        }
        this.energy = e.getEnergy();
        this.deltaEnergy = 0.0;
        ++this.sumEvents;
    }

    public String toString() {
        return this.name;
    }

    public void dump() {
        System.out.println("--- statistics for " + this.toString());
        System.out.println("sumEvents   = " + this.sumEvents);
        System.out.println("maxVelocity = " + this.maxVelocity);
    }

    public Enemy(String n, Arena a) {
        this.arena = a;
        this.name = n;
        this.sumEvents = 0;
        this.deltaEnergy = 0.0;
        this.point = new Point2D.Double();
    }
}

