/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.move;

import catcat20.core.bot.Bot;
import catcat20.core.bot.BotState;
import catcat20.core.gun.LambdaGun;
import catcat20.core.move.KNNResultWithWave;
import catcat20.core.move.NonWaveMove;
import catcat20.core.move.SurfDefaultTree;
import catcat20.core.move.SurfPathPos;
import catcat20.core.move.SurfWave;
import catcat20.core.move.formula.SurfKNNModel;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.MovementPredictor;
import catcat20.core.utils.OptimalPointPlacer;
import catcat20.core.utils.PreciseWallSmooth;
import catcat20.core.utils.ShadowBullet;
import catcat20.core.utils.knn.GFData;
import catcat20.core.utils.knn.KNNData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.MessageEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Rules;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Surfing {
    public static boolean RABBIT_MODE = false;
    public static boolean TRON_MODE = false;
    public static boolean DIA_MODE = false;
    public static boolean CURVE_DECEL = false;
    public static boolean ZIGZAG = false;
    public static boolean PATH_RANDOM_SEARCH = false;
    public static boolean FLATTENER_ONLY_MODE = false;
    public static final double FLATTENER_WEIGHT = 0.5;
    public NonWaveMove nonWaveMove;
    public static int FIRST_DIRECTIONS = 16;
    public static int SECOND_DIRECTIONS = 6;
    public static double FIRST_LENGTH = 160.0;
    public static double SECOND_LENGTH = 100.0;
    public static int MELEE_DEPTH = 1;
    public static int DUEL_DEPTH = 3;
    public static double CURRENT_BESTDEST_BONUS = 1.0;
    public static int OUTSIDE_PENALTY = 100000;
    public static int OUTSIDE_PENALTY_MUL = 10;
    private static double DESIRED_DISTANCE = 650.0;
    private static double MAX_ATTACK_ANGLE = 1.413716694115407;
    public static int WALL_STICK = 150;
    public static int MELEE_STICK = 110;
    public boolean PATH_DRAW_MODE = false;
    public boolean drawListener = false;
    public boolean MELEE_BRANCH_MODE = false;
    public boolean MELEE_SURF_MODE = false;
    public boolean MELEE_BOTDANGER_MODE = false;
    public static int MAX_SURF;
    public static int WAVE_SAMPLE;
    public static boolean CORNER_STICK;
    public static double CORNER_STICK_MARGIN;
    public static double CORNER_STICK_DIST;
    public double duelHitLost = 0.0;
    public double meleeHitLost = 0.0;
    public TeamRobot _robot;
    public static Point2D.Double nextMyPos;
    public static ArrayList<SurfWave> _waves;
    Point2D.Double _myPos = new Point2D.Double();
    long _time;
    int _others;
    double _energy;
    public static final int BACK_STATE_LOG = 1;
    public boolean isProcessing = false;
    public int riskCalled;
    public int loops;
    public int nodes;
    public int dangerCalled;
    public long dangerTime;
    public int cutNodes;
    public int botRiskLoops;
    public double sumWaveRisk = 1.0;
    public double waveRiskCount = 1.0;
    public double waveRiskAve = 1.0;
    public double sumBotRisk = 1.0;
    public double botRiskCount = 1.0;
    public double botRiskAve = 1.0;
    public ArrayList<Double> medianPosDangers = new ArrayList(100);
    public ArrayList<Double> medianWaveDangers = new ArrayList(200);
    public double medianPos = 1.0;
    public double medianWave = 1.0;
    public boolean fallback_move = true;
    public static boolean drawMEA;
    Color whiteRed = new Color(255, 190, 190);
    Color whiteBlue = new Color(190, 190, 255);
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    public Point2D.Double duelEnPos;
    public double duelEnHeading;
    public double duelEnVelocity;
    boolean isContainingMyWave = false;
    public static double lastMaxVelocity;
    public static double lastDestX;
    public static double lastDestY;
    public static double lastSecondDestX;
    public static double lastSecondDestY;
    public static double lastSecondMaxVelocity;
    public static double lastSecondDestCacheX;
    public static double lastSecondDestCacheY;
    public static SurfWave currentSurfWave;
    public static final int BOT_HALFSIZE = 18;
    public static final int ORBIT_FORWARD = 1;
    public static final int ORBIT_REVERSE = 2;
    public static final int ORBIT_BACK = 4;
    public static final int ORBIT_SURFDISTANCER = 8;
    public static final int ORBIT_ANTIRAMDISTANCER = 16;
    public static final int HEADING = -1;
    Ellipse2D.Double cacheEllipse = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
    Rectangle2D.Double botRect = new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0);
    Point2D.Double cache = new Point2D.Double();
    ArrayList<SurfWave> removedWaveCache = new ArrayList(3);
    Line2D.Double currentGOTOLine = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    Point2D.Double currentCorner = new Point2D.Double();
    double currentCornerDist;
    Point2D.Double cornerCache = new Point2D.Double();
    Line2D line2D = new Line2D.Double();
    DistanceController distancer = new DistanceController();
    Point2D.Double enCache1 = new Point2D.Double();
    Point2D.Double enCache2 = new Point2D.Double();
    Graphics2D g = null;
    BasicStroke bs = new BasicStroke(1.5f);

    public Surfing(TeamRobot _robot) {
        this._robot = _robot;
        this.nonWaveMove = new NonWaveMove(_robot);
    }

    public void init() {
        _waves = new ArrayList();
        this.duelHitLost = 0.0;
        this.meleeHitLost = 0.0;
        lastDestX = Double.NaN;
        lastDestY = Double.NaN;
    }

    public void onTick() {
        this.PATH_DRAW_MODE = this.drawListener;
        this.duelEnPos = new Point2D.Double(LConstants.fieldCenter.x, LConstants.fieldCenter.y);
        nextMyPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._time = this._robot.getTime();
        this._others = this._robot.getOthers();
        this._energy = this._robot.getEnergy();
        this.isProcessing = true;
        this.loops = 0;
        this.botRiskLoops = 0;
        this.nodes = 0;
        this.riskCalled = 0;
        this.cutNodes = 0;
        this.dangerCalled = 0;
        this.dangerTime = 0L;
        this.waveRiskAve = (this.sumWaveRisk + 1.0E-5) / (this.waveRiskCount + 1.0E-5);
        this.botRiskAve = (this.sumBotRisk + 1.0E-5) / (this.botRiskCount + 1.0E-5);
        this.sumWaveRisk = 0.0;
        this.sumBotRisk = 0.0;
        this.waveRiskCount = 0.0;
        this.botRiskCount = 0.0;
        double tempMediPos = 1.0;
        if (!this.medianPosDangers.isEmpty()) {
            tempMediPos = this.getMedianNormalizeScale(this.medianPosDangers) + 1.0E-4;
        }
        tempMediPos *= (double)(50 * LUtils.limit(1, this._others * 2 + this._others * 3, 20)) * LUtils.limit(1.0, (double)this.medianWaveDangers.size() / ((double)this.medianPosDangers.size() + 0.1), 1000.0);
        if (this._others <= 1) {
            tempMediPos = 0.0;
        }
        this.medianPos = tempMediPos;
        double tempMediWave = 1.0;
        if (!this.medianWaveDangers.isEmpty()) {
            tempMediWave = this.getMedianNormalizeScale(this.medianWaveDangers) + 1.0E-4;
        }
        tempMediWave *= (double)(this._others * 2 + this._others * 3 + 25);
        this.medianWave = tempMediWave *= 1000.0;
        this.medianPosDangers.clear();
        this.medianWaveDangers.clear();
        this.setCorner(this._myPos.x, this._myPos.y, this.currentCorner);
        this.currentCornerDist = this._myPos.distance(this.currentCorner);
        if (_waves.isEmpty()) {
            this.fallback_move = true;
        }
        if (this._others <= 1) {
            this.fallback_move = false;
        }
        if (this._others > 1 && Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null) {
            this.duelEnPos.setLocation(Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
        }
        for (Bot bot : Radar.aliveEnemyList) {
            double dist;
            boolean isRam;
            if (!bot.isAlive || bot.states.size() <= 1 || bot.shotDataMaps.size() <= 1 || !bot.shotDataMaps.get(1).containsKey(bot.nearestBotName)) continue;
            if (this._others <= 1) {
                this.duelEnPos.setLocation(bot.currentState.x, bot.currentState.y);
                this.duelEnHeading = bot.currentState.heading;
                this.duelEnVelocity = bot.currentState.velocity;
            }
            boolean bl = isRam = (dist = this._myPos.distance(bot.currentState.x, bot.currentState.y)) <= 250.0;
            if (this._others > 1) {
                isRam = false;
            } else if (this._time <= 30L || bot.currentState.energy < 0.1) {
                isRam = false;
            }
            boolean canFire = false;
            if (this._others <= 1 && bot.gunHeat <= LConstants.GUN_COOLING_RATE * 2.0) {
                canFire = true;
            }
            if (this._others > 1) {
                canFire = true;
            }
            boolean gunHeatWave = bot.gunHeat < 0.0 && this._others <= 1 && this._time > 30L && bot.currentState.energy > 1.0;
            double energyDrop = bot.states.get((int)1).energy - bot.currentState.energy;
            if (energyDrop > 0.01 && energyDrop < 3.01 && canFire) {
                this.fallback_move = false;
                bot.waveFiredCount += 1.0;
                bot.firedPowerSum += energyDrop;
                if (this._others <= 1) {
                    ++bot.youShotsFiredDuel;
                    bot.gunHeat = LUtils.limit(0.0, Rules.getGunHeat((double)energyDrop) - LConstants.GUN_COOLING_RATE * 2.0, 3.0);
                } else {
                    bot.gunHeat = LUtils.limit(0.0, Rules.getGunHeat((double)energyDrop) - LConstants.GUN_COOLING_RATE * (double)(this._time - bot.gunHeatTime + 1L), 3.0);
                }
                bot.bulletPowerPredictor.addPoint(bot.bulletPowerDataPoint(bot.currentState.energy, bot.nearestBotEnergy, bot.nearestBotDist, this._others), energyDrop);
                long fireTime = (long)((double)(this._time + bot.lastScanTime) / 2.0 - 2.0);
                int ago = (int)(this._time - fireTime);
                BotState fireBotState = bot.states.get(ago - 1);
                SurfWave w = new SurfWave(fireBotState.x, fireBotState.y, bot.name, energyDrop, fireTime);
                w.nearestBotFromSource = bot.nearestBotName;
                w.myPos = (Point2D.Double)this._myPos.clone();
                w.isMyWave = bot.nearestBotName.equals(Radar.myName);
                if (this._others > 1) {
                    w.doBranchWave = false;
                    if (w.isMyWave) {
                        w.doBranchWave = true;
                    }
                } else {
                    w.doBranchWave = true;
                }
                w.isMeleeWave = this._others > 1;
                _waves.add(w);
            } else if (this.fallback_move || isRam || gunHeatWave) {
                BotState botState = bot.states.get(1);
                BotState youState = null;
                youState = bot.nearestBotName.equals(Radar.myName) ? Radar.myStates.get(1) : Radar.getBot((String)bot.nearestBotName).states.get(1);
                double absBearing = LUtils.absoluteBearing(botState.x, botState.y, youState.x, youState.y);
                long fireTime = this._time - 1L + bot.gunHeatTime;
                if (gunHeatWave) {
                    fireTime = this._time - 1L;
                }
                double ramPower = LUtils.bulletPowerFromVelocity(8.0);
                SurfWave w = new SurfWave(botState.x, botState.y, bot.name, ramPower, fireTime);
                w.nearestBotFromSource = bot.nearestBotName;
                w.myPos = (Point2D.Double)this._myPos.clone();
                w.isMeleeWave = this._others > 1;
                w.isMyWave = bot.nearestBotName.equals(Radar.myName);
                w.doBranchWave = this._others <= 1;
                if (this._others <= 1 || this.fallback_move) {
                    // empty if block
                }
                w.isRamWave = true;
                _waves.add(w);
            }
            ArrayList<KNNData<Double>> power = bot.bulletPowerPredictor.getNearestNeighborsList(bot.bulletPowerDataPoint(bot.currentState.energy, this._energy, this._myPos.distance(bot.currentState.x, bot.currentState.y), this._others), 1);
            bot.predictedPowerCache = power != null && !power.isEmpty() ? LUtils.limit(0.1, (Double)power.get((int)0).data, 3.0) : LUtils.limit(0.1, bot.firedPowerSum / bot.waveFiredCount, 3.0);
            if (this.PATH_DRAW_MODE) {
                this.g.setColor(Color.white);
                this.g.drawString("p: " + bot.predictedPowerCache, (int)bot.currentState.x - 50, (int)bot.currentState.y - 61);
            }
            if (this._others > 1 || power == null || power.isEmpty()) continue;
            this.getMea((Double)power.get((int)0).data, Radar.myState, bot.currentState.x, bot.currentState.y, 0L, this._robot.getGraphics(), LUtils.sign(Bot.lateralVelocity(bot.currentState, Radar.myState)));
        }
        this.updateWaves();
        if ((_waves.isEmpty() || this.getClosestSurfableWave(_waves, this._myPos.x, this._myPos.y, this._time) == null) && this._others <= 1) {
            this.nonWaveMove.onTick();
        } else {
            try {
                this.doSurfing();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isProcessing = false;
        this.drawListener = false;
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, Graphics2D g, int direction) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
            if (!drawMEA) continue;
            g.setColor(this.whiteRed);
            g.drawOval((int)dir1.x - 1, (int)dir1.y - 1, 2, 2);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, 1 * direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
            if (!drawMEA) continue;
            g.setColor(this.whiteBlue);
            g.drawOval((int)dir2.x - 1, (int)dir2.y - 1, 2, 2);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public void doSurfing() {
        this.g = this._robot.getGraphics();
        if (Double.isNaN(lastDestX) && Double.isNaN(lastDestY)) {
            lastDestX = this._myPos.x;
            lastDestY = this._myPos.y;
        }
        if (Double.isNaN(lastSecondDestX) && Double.isNaN(lastSecondDestY)) {
            lastSecondDestX = lastDestX;
            lastSecondDestY = lastDestY;
        }
        lastSecondDestCacheX = lastSecondDestX;
        lastSecondDestCacheY = lastSecondDestY;
        if (!_waves.isEmpty() && this.getClosestSurfableWave(_waves, this._myPos.x, this._myPos.y, this._time) != null) {
            double heading;
            this.MELEE_SURF_MODE = this._others > 1;
            this.MELEE_BRANCH_MODE = this._others > 1;
            boolean bl = this.MELEE_BOTDANGER_MODE = this._others > 1;
            if (DIA_MODE || TRON_MODE) {
                this.MELEE_SURF_MODE = true;
            }
            int waveCount = 0;
            if (this._others <= 1) {
                MAX_SURF = DUEL_DEPTH;
                waveCount = Math.min(_waves.size(), MAX_SURF);
            } else {
                waveCount = Math.min(_waves.size(), WAVE_SAMPLE);
                MAX_SURF = MELEE_DEPTH;
            }
            this.isContainingMyWave = false;
            ArrayList clonedWaves = (ArrayList)_waves.clone();
            ArrayList<SurfWave> surfWaves = new ArrayList<SurfWave>();
            SurfWave surfWave = null;
            double lastWaveDist = 0.0;
            for (int i = 0; i < waveCount; ++i) {
                SurfWave nearWave = this.getClosestSurfableWave(clonedWaves, this._myPos.x, this._myPos.y, this._time);
                if (nearWave == null) continue;
                double waveDist = this._myPos.distance(nearWave.x, nearWave.y) / nearWave.bulletVelocity;
                if (this._others <= 1) {
                    nearWave.doBranchWave = true;
                    this.isContainingMyWave = true;
                }
                if (nearWave.isMyWave) {
                    this.isContainingMyWave = true;
                }
                if (i == 0) {
                    currentSurfWave = nearWave;
                    surfWave = nearWave;
                    lastWaveDist = waveDist;
                }
                surfWaves.add(nearWave);
                clonedWaves.remove(nearWave);
                if (!(waveDist - lastWaveDist > 10.0)) continue;
                lastWaveDist = waveDist;
            }
            waveCount = Math.min(waveCount, MAX_SURF);
            double velocity = this._robot.getVelocity();
            double bestGoAngle = heading = this._robot.getHeadingRadians();
            double bestMaxVelocity = 8.0;
            double bestRisk = Double.POSITIVE_INFINITY;
            double bestDist = 100.0;
            ArrayList<SurfPathPos> bestPathPosList = null;
            ArrayList<SurfPathPos> pathPosList = null;
            if (!this.MELEE_SURF_MODE) {
                double nextRisk1;
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList<SurfPathPos>();
                }
                double goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 0.6, this.duelEnPos.x, this.duelEnPos.y);
                double nextRisk0 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, 9, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity);
                bestGoAngle = goAngle;
                bestMaxVelocity = 8.0;
                bestRisk = nextRisk0;
                bestPathPosList = pathPosList;
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList();
                }
                if ((nextRisk1 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 0.6, this.duelEnPos.x, this.duelEnPos.y), 10, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) < bestRisk) {
                    bestGoAngle = goAngle;
                    bestRisk = nextRisk1;
                    bestMaxVelocity = 8.0;
                    bestPathPosList = pathPosList;
                }
                if (!surfWave.isRamWave && surfWave.distanceSq(this._myPos) > 62500.0) {
                    double nextRisk2;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 0.0, waveCount - 1, goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 0.6, this.duelEnPos.x, this.duelEnPos.y), 9, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk2;
                        bestMaxVelocity = 0.0;
                        bestPathPosList = pathPosList;
                    }
                } else {
                    double nextRisk;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 1.0, this.duelEnPos.x, this.duelEnPos.y);
                    nextRisk0 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, 17, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity);
                    bestGoAngle = goAngle;
                    bestMaxVelocity = 8.0;
                    bestRisk = nextRisk0;
                    bestPathPosList = pathPosList;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk1 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 1.0, this.duelEnPos.x, this.duelEnPos.y), 18, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk1;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 10000.0, this.duelEnPos.x, this.duelEnPos.y), 5, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 10000.0, this.duelEnPos.x, this.duelEnPos.y), 6, this._time, pathPosList, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                }
            } else {
                double stopY;
                double stopX;
                double goAngle;
                double nextRisk;
                double nextRisk2;
                double bestDestX = lastDestX;
                double bestDestY = lastDestY;
                bestMaxVelocity = 8.0;
                int direction = FIRST_DIRECTIONS;
                double dist = FIRST_LENGTH;
                double offset = 0.0;
                if (PATH_RANDOM_SEARCH) {
                    offset = Math.random() * Math.PI * 10.0;
                }
                if (!DIA_MODE && !TRON_MODE) {
                    OptimalPointPlacer.computePoints((RoundRectangle2D.Double)LConstants.roundRect, this._myPos.x, this._myPos.y, heading, dist, OptimalPointPlacer.intersectionBuf, OptimalPointPlacer.resultX, OptimalPointPlacer.resultY);
                    double[] copyResultX = new double[4];
                    double[] copyResultY = new double[4];
                    System.arraycopy(OptimalPointPlacer.resultX, 0, copyResultX, 0, 4);
                    System.arraycopy(OptimalPointPlacer.resultY, 0, copyResultY, 0, 4);
                    for (int i = 0; i < 4; ++i) {
                        double nextRisk3;
                        nextDestX = copyResultX[i];
                        nextDestY = copyResultY[i];
                        double goAngle2 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, nextDestX, nextDestY);
                        if (this.g != null) {
                            double preX = this._myPos.x + Math.sin(goAngle2) * (double)MELEE_STICK;
                            double preY = this._myPos.y + Math.cos(goAngle2) * (double)MELEE_STICK;
                            this.g.setColor(new Color(255, 255, 255, 50));
                            this.g.fillOval((int)preX - 18, (int)preY - 18, 36, 36);
                        }
                        if (this.PATH_DRAW_MODE) {
                            this.g.setColor(Color.blue);
                            this.g.fillOval((int)nextDestX - 5, (int)nextDestY - 5, 10, 10);
                        }
                        if (this.PATH_DRAW_MODE) {
                            pathPosList = new ArrayList();
                        }
                        if (!(bestRisk > (nextRisk3 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle2, -1, this._time, pathPosList, nextDestX, nextDestY, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)))) continue;
                        bestRisk = nextRisk3;
                        bestMaxVelocity = 8.0;
                        bestGoAngle = goAngle2;
                        bestPathPosList = pathPosList;
                        bestDestX = nextDestX;
                        bestDestY = nextDestY;
                        bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, nextDestX, nextDestY);
                    }
                } else {
                    for (int i = 0; i < direction; ++i) {
                        if (this.PATH_DRAW_MODE) {
                            pathPosList = new ArrayList();
                        }
                        double goAngle3 = 0.0;
                        goAngle3 = DIA_MODE ? Math.toRadians(45.0 + (double)i * (360.0 / (double)direction)) : (TRON_MODE ? Math.toRadians((double)i * (360.0 / (double)direction)) : offset + heading + Math.toRadians((double)i * (360.0 / (double)direction)));
                        nextDestX = this._myPos.x + Math.sin(goAngle3) * dist;
                        nextDestY = this._myPos.y + Math.cos(goAngle3) * dist;
                        int margin = 20;
                        if (!DIA_MODE && !TRON_MODE) {
                            goAngle3 = this.meleePreciseSmooth(this._myPos.x, this._myPos.y, goAngle3);
                        } else if (!LConstants.safeField.contains(nextDestX = LUtils.limit((double)margin, nextDestX, LConstants.fieldWidth - (double)margin), nextDestY = LUtils.limit((double)margin, nextDestY, LConstants.fieldHeight - (double)margin))) continue;
                        LUtils.projectToBoundary(LConstants.roundRect, nextDestX, nextDestY, this.cache);
                        nextDestX = this.cache.x;
                        nextDestY = this.cache.y;
                        goAngle3 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, nextDestX, nextDestY);
                        if (this.g != null) {
                            double preX = this._myPos.x + Math.sin(goAngle3) * (double)MELEE_STICK;
                            double preY = this._myPos.y + Math.cos(goAngle3) * (double)MELEE_STICK;
                            this.g.setColor(new Color(255, 255, 255, 50));
                            this.g.fillOval((int)preX - 18, (int)preY - 18, 36, 36);
                        }
                        if (this.PATH_DRAW_MODE) {
                            this.g.setColor(Color.blue);
                            this.g.fillOval((int)nextDestX - 5, (int)nextDestY - 5, 10, 10);
                        }
                        if (!(bestRisk > (nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle3, -1, this._time, pathPosList, nextDestX, nextDestY, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)))) continue;
                        bestRisk = nextRisk2;
                        bestMaxVelocity = 8.0;
                        bestGoAngle = goAngle3;
                        bestPathPosList = pathPosList;
                        bestDestX = nextDestX;
                        bestDestY = nextDestY;
                        bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, nextDestX, nextDestY);
                    }
                }
                if (this.MELEE_SURF_MODE) {
                    double goAngle4;
                    double nextRisk4;
                    if (this.g != null) {
                        this.g.setColor(new Color(0, 255, 255));
                        this.g.fillOval((int)lastSecondDestX - 5, (int)lastSecondDestY - 5, 10, 10);
                        this.g.setColor(new Color(0, 255, 0));
                        this.g.fillOval((int)lastDestX - 5, (int)lastDestY - 5, 10, 10);
                    }
                    if (CORNER_STICK) {
                        double cornerPosY2;
                        double cornerPosX2;
                        double cornerPosY1;
                        double cornerPosX1;
                        double goAngle5;
                        int xdir = LUtils.sign(LConstants.fieldCenter.x - this.currentCorner.x);
                        int ydir = LUtils.sign(LConstants.fieldCenter.y - this.currentCorner.y);
                        if (this.PATH_DRAW_MODE) {
                            pathPosList = new ArrayList();
                        }
                        if (bestRisk > (nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle5 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, cornerPosX1 = this.currentCorner.x + CORNER_STICK_MARGIN * (double)xdir, cornerPosY1 = this.currentCorner.y + CORNER_STICK_DIST * (double)ydir), -1, this._time, pathPosList, cornerPosX1, cornerPosY1, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity))) {
                            bestRisk = nextRisk2;
                            bestMaxVelocity = 8.0;
                            bestGoAngle = goAngle5;
                            bestPathPosList = pathPosList;
                            bestDestX = cornerPosX1;
                            bestDestY = cornerPosY1;
                            bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, cornerPosX1, cornerPosY1);
                        }
                        if (this.PATH_DRAW_MODE) {
                            pathPosList = new ArrayList();
                        }
                        if (bestRisk > (nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle5 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, cornerPosX2 = this.currentCorner.x + CORNER_STICK_DIST * (double)xdir, cornerPosY2 = this.currentCorner.y + CORNER_STICK_MARGIN * (double)ydir), -1, this._time, pathPosList, cornerPosX2, cornerPosY2, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity))) {
                            bestRisk = nextRisk2;
                            bestMaxVelocity = 8.0;
                            bestGoAngle = goAngle5;
                            bestPathPosList = pathPosList;
                            bestDestX = cornerPosX2;
                            bestDestY = cornerPosY2;
                            bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, cornerPosX2, cornerPosY2);
                        }
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if (bestRisk > (nextRisk4 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle4 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, lastDestX, lastDestY), -1, this._time, pathPosList, lastDestX, lastDestY, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) * CURRENT_BESTDEST_BONUS) {
                        bestRisk = nextRisk4;
                        bestMaxVelocity = 8.0;
                        bestGoAngle = goAngle4;
                        bestPathPosList = pathPosList;
                        bestDestX = lastDestX;
                        bestDestY = lastDestY;
                        bestMaxVelocity = lastMaxVelocity;
                        bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, lastDestX, lastDestY);
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if (bestRisk > (nextRisk4 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle4 = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, lastSecondDestCacheX, lastSecondDestCacheY), -1, this._time, pathPosList, lastSecondDestCacheX, lastSecondDestCacheY, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity)) * CURRENT_BESTDEST_BONUS) {
                        bestRisk = nextRisk4;
                        bestMaxVelocity = 8.0;
                        bestGoAngle = goAngle4;
                        bestPathPosList = pathPosList;
                        bestDestX = lastSecondDestCacheX;
                        bestDestY = lastSecondDestCacheY;
                        bestMaxVelocity = lastSecondMaxVelocity;
                        bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, lastSecondDestCacheX, lastSecondDestCacheY);
                    }
                }
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList();
                }
                if (bestRisk > (nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = heading, -1, this._time, pathPosList, stopX = this._myPos.x + Math.sin(goAngle) * 20.0, stopY = this._myPos.y + Math.cos(goAngle) * 20.0, 8.0, bestRisk, this.duelEnPos.x, this.duelEnPos.y, this.duelEnHeading, this.duelEnVelocity))) {
                    bestRisk = nextRisk;
                    bestMaxVelocity = 8.0;
                    bestGoAngle = goAngle;
                    bestPathPosList = pathPosList;
                    bestDestX = stopX;
                    bestDestY = stopY;
                    bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, bestDestX, bestDestY);
                }
                lastDestX = bestDestX;
                lastDestY = bestDestY;
                lastMaxVelocity = bestMaxVelocity;
                if (this.g != null) {
                    this.g.setColor(Color.red);
                    this.g.fillOval((int)lastDestX - 6, (int)lastDestY - 6, 12, 12);
                    this.g.setColor(Color.orange);
                    this.g.fillOval((int)lastSecondDestX - 6, (int)lastSecondDestY - 6, 12, 12);
                }
            }
            if (this.PATH_DRAW_MODE && bestPathPosList != null) {
                double oldX = this._myPos.x;
                double oldY = this._myPos.y;
                Stroke reset = this.g.getStroke();
                this.g.setStroke(this.bs);
                for (SurfPathPos pos : bestPathPosList) {
                    this.g.setColor(pos.color);
                    int size = (int)pos.size;
                    if (pos.isConnected) {
                        if (size > 2) {
                            this.g.fillOval((int)(pos.x - (double)size), (int)(pos.y - (double)size), size * 2, size * 2);
                        }
                        this.g.drawLine((int)oldX, (int)oldY, (int)pos.x, (int)pos.y);
                        oldX = pos.x;
                        oldY = pos.y;
                        continue;
                    }
                    this.g.drawRect((int)(pos.x - (double)size), (int)(pos.y - (double)size), size * 2, size * 2);
                }
                this.g.setColor(Color.cyan);
                this.g.drawRect((int)(this._myPos.x - 18.0), (int)(this._myPos.y - 18.0), 36, 36);
                this.g.setStroke(reset);
            }
            double epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            if (RABBIT_MODE && bestMaxVelocity > 1.0) {
                bestMaxVelocity = Surfing.getRabbitVelocity(this._time);
            } else if (CURVE_DECEL && Math.abs(this._robot.getTurnRemaining()) > 22.5 && bestMaxVelocity > 0.0) {
                bestMaxVelocity = 3.0;
            }
            this._robot.setMaxVelocity(bestMaxVelocity + epsilon);
            if (ZIGZAG && Math.abs(this._robot.getVelocity()) > 4.0) {
                bestGoAngle += Surfing.getZigZag(this._robot.getTime());
            }
            if (this._others <= 1 && bestMaxVelocity <= 0.1 && Math.random() < 0.5) {
                bestGoAngle += Math.PI;
            }
            this.g.setColor(Color.white);
            this.g.drawString("vel: " + (bestMaxVelocity + epsilon), 30, 10);
            if (this.MELEE_SURF_MODE) {
                bestGoAngle = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, lastDestX, lastDestY);
                if (bestDist > 1.0) {
                    Surfing.setBackAsFront((AdvancedRobot)this._robot, bestGoAngle, bestDist);
                } else {
                    Surfing.setBackAsFront((AdvancedRobot)this._robot, this._robot.getHeadingRadians(), bestDist);
                }
                this.g.drawString("ahead m", 210, 10);
            } else {
                Surfing.setBackAsFront((AdvancedRobot)this._robot, bestGoAngle);
                this.g.drawString("ahead d", 210, 10);
            }
            LUtils.projectWithCache(nextMyPos, bestGoAngle, MovementPredictor.getVelocity(velocity, bestMaxVelocity + epsilon, Double.POSITIVE_INFINITY), nextMyPos);
        }
    }

    public double meleePreciseSmooth(double x, double y, double goAngle) {
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        double smoothed1 = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, x, y, 1);
        this.trig.sin = Math.sin(smoothed1);
        this.trig.cos = Math.cos(smoothed1);
        smoothed1 = LConstants.preciseWallSmooth.smoothHeading(smoothed1, this.trig, x, y, 1);
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        double smoothed2 = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, x, y, -1);
        this.trig.sin = Math.sin(smoothed2);
        this.trig.cos = Math.cos(smoothed2);
        smoothed2 = LConstants.preciseWallSmooth.smoothHeading(smoothed2, this.trig, x, y, -1);
        goAngle = Math.abs(Utils.normalRelativeAngle((double)(smoothed1 - goAngle))) > Math.abs(Utils.normalRelativeAngle((double)(smoothed2 - goAngle))) ? smoothed2 : smoothed1;
        return goAngle;
    }

    private void goTo(double x, double y) {
        Point2D.Double location = new Point2D.Double(this._robot.getX(), this._robot.getY());
        double distance = location.distance(x, y);
        double angle = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(this._robot.getX(), this._robot.getY(), x, y) - this._robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance = -distance;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this._robot.setTurnRightRadians(angle * (double)Math.signum(Math.abs((int)distance)));
        this._robot.setAhead(distance);
    }

    public double meleeWallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        double step = 0.0;
        double v = Math.toRadians(2.5);
        while (!LConstants.safeField.contains(LUtils.project(botLocation, angle, MELEE_STICK)) && step <= 720.0) {
            angle += (double)orientation * (step += 1.0) * v;
            orientation *= -1;
        }
        return angle;
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        Surfing.setBackAsFront(robot, goAngle, 100.0);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle, double dist) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(dist);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(dist);
        }
    }

    public double orbitAngle(int GO_TYPE, double x, double y, SurfWave surfWave, double mul, double enX, double enY) {
        int direction = 1;
        if (GO_TYPE == 2) {
            direction = -1;
        }
        double distancerAngle = this.distancer.attackAngle(surfWave.distance(x, y), mul);
        if (GO_TYPE - 4 > 0) {
            distancerAngle = 1.5707963267948966;
            direction = 1;
            if (2 == GO_TYPE - 4) {
                direction = -1;
            }
        }
        double goAngle = LUtils.absoluteBearing(x, y, enX, enY) + Math.PI + (double)direction * (1.5707963267948966 + distancerAngle);
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        goAngle = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, x, y, direction);
        if (surfWave.distanceSq(x, y) <= 62500.0) {
            goAngle = this.meleePreciseSmooth(x, y, goAngle);
        }
        return goAngle;
    }

    public static double getZigZag(long time) {
        int dir = (int)Math.signum(Math.sin(Math.toRadians(time * 40L)));
        return (double)dir * Math.toRadians(7.5);
    }

    public static double getRabbitVelocity(long time) {
        long mod = time % 20L;
        double vel = 8.0;
        if (mod >= 17L) {
            vel = 0.0;
        }
        return LUtils.limit(0.0, vel, 8.0);
    }

    public double simulate(ArrayList<SurfWave> waves, double x, double y, double heading, double velocity, double maxVelocity, int depth, double goAngle, int GO_TYPE, long simTime, ArrayList<SurfPathPos> drawPathDest, double duelEnX, double duelEnY, double duelEnHeading, double duelEnVelocity) {
        return this.simulate(waves, x, y, heading, velocity, maxVelocity, depth, goAngle, GO_TYPE, simTime, drawPathDest, Double.NaN, Double.NaN, maxVelocity, Double.POSITIVE_INFINITY, duelEnX, duelEnY, duelEnHeading, duelEnVelocity);
    }

    public double simulate(ArrayList<SurfWave> waves, double x, double y, double heading, double velocity, double maxVelocity, int depth, double goAngle, int GO_TYPE, long lastBranchSimTime, ArrayList<SurfPathPos> drawPathDest, double destX, double destY, double targetVel, double minimum, double duelEnX, double duelEnY, double duelEnHeading, double duelEnVelocity) {
        ++this.nodes;
        double firstX = x;
        double firstY = y;
        double addDistance = 0.0;
        double risk = 0.0;
        int hitCount = 0;
        int counter = 0;
        SurfWave surfWave = null;
        long simTime = lastBranchSimTime;
        while (counter < 60) {
            ++simTime;
            ++this.loops;
            ++counter;
            if (RABBIT_MODE && targetVel > 1.0) {
                maxVelocity = Surfing.getRabbitVelocity(simTime);
            }
            if (this._others <= 1) {
                surfWave = this.getClosestSurfableWave(waves, x, y, simTime);
            }
            double duelDist = (duelEnX - x) * (duelEnX - x) + (duelEnY - y) * (duelEnY - y);
            if (this._others <= 1 && duelDist <= 10000.0) {
                double enGoAngle = LUtils.absoluteBearing(duelEnX, duelEnY, x, y);
                int moveDir = 1;
                double relativeGoAngle = enGoAngle - duelEnHeading;
                if (Math.cos(relativeGoAngle) < 0.0) {
                    moveDir = -1;
                    relativeGoAngle += Math.PI;
                }
                relativeGoAngle = Utils.normalRelativeAngle((double)relativeGoAngle);
                double maxTurning = Math.toRadians(10.0 - 0.75 * Math.abs(duelEnVelocity));
                double turn = LUtils.limit(-maxTurning, relativeGoAngle, maxTurning);
                duelEnVelocity = MovementPredictor.getVelocity(duelEnVelocity, 8.0, Double.POSITIVE_INFINITY * (double)moveDir);
                duelEnX += Math.sin(duelEnHeading += turn) * duelEnVelocity;
                duelEnY += Math.cos(duelEnHeading) * duelEnVelocity;
            }
            double distRemaining = Double.POSITIVE_INFINITY;
            if (GO_TYPE > 0) {
                if (GO_TYPE - 16 > 0) {
                    goAngle = this.orbitAngle(GO_TYPE - 16, x, y, surfWave, 1.0, this.duelEnPos.x, this.duelEnPos.y);
                } else if (GO_TYPE - 8 > 0) {
                    goAngle = this.orbitAngle(GO_TYPE - 8, x, y, surfWave, 0.6, this.duelEnPos.x, this.duelEnPos.y);
                } else if (GO_TYPE - 4 == 0) {
                    goAngle = this.orbitAngle(GO_TYPE, x, y, surfWave, 10000.0, this.duelEnPos.x, this.duelEnPos.y);
                }
            }
            double posDist = Point2D.Double.distance(x, y, destX, destY);
            if (!Double.isNaN(destX) && !Double.isNaN(destY) && posDist >= 0.0) {
                goAngle = Utils.normalAbsoluteAngle((double)LUtils.absoluteBearing(x, y, destX, destY));
                distRemaining = posDist;
            }
            if (ZIGZAG && Math.abs(velocity) > 4.0) {
                goAngle += Surfing.getZigZag(simTime);
            }
            if (posDist < 1.0) {
                goAngle = heading;
            }
            int moveDir = 1;
            double relativeGoAngle = goAngle - heading;
            if (Math.cos(relativeGoAngle) < 0.0) {
                moveDir = -1;
                relativeGoAngle += Math.PI;
            }
            relativeGoAngle = Utils.normalRelativeAngle((double)relativeGoAngle);
            double maxTurning = Math.toRadians(10.0 - 0.75 * Math.abs(velocity));
            double turn = LUtils.limit(-maxTurning, relativeGoAngle, maxTurning);
            heading += turn;
            if (CURVE_DECEL && Math.abs(turn) > 0.39269908169872414 && maxVelocity > 0.0) {
                maxVelocity = 3.0;
            }
            velocity = MovementPredictor.getVelocity(velocity, maxVelocity, distRemaining * (double)moveDir);
            x += Math.sin(heading) * velocity;
            y += Math.cos(heading) * velocity;
            if (this.PATH_DRAW_MODE) {
                SurfPathPos pos = new SurfPathPos().setX(x).setY(y).setSize(1.0);
                if (!LConstants.roundRect.contains(x, y)) {
                    pos.color = Color.red;
                }
                drawPathDest.add(pos);
            }
            if (!LConstants.safeField.contains(x, y) && LConstants.safeField.contains(firstX, firstY)) {
                risk += (double)OUTSIDE_PENALTY;
                risk *= (double)OUTSIDE_PENALTY_MUL;
            }
            if (duelDist <= 2500.0) {
                risk += 5000.0 / duelDist;
            }
            if (duelDist <= 1764.0) {
                risk += 5000.0;
            }
            if (this.g != null && this.drawListener && depth == 1) {
                this.g.setColor(Color.gray);
                this.g.drawRect((int)x - 1, (int)y - 1, 2, 2);
            }
            this.botRect.setRect(x - 18.0, y - 18.0, 36.0, 36.0);
            boolean isBranch = false;
            for (int i = 0; i < waves.size(); ++i) {
                SurfWave otherWave = waves.get(i);
                double distanceTraveled = otherWave.getDistanceTraveled(simTime);
                this.cacheEllipse.x = otherWave.x - distanceTraveled;
                this.cacheEllipse.y = otherWave.y - distanceTraveled;
                this.cacheEllipse.width = distanceTraveled * 2.0;
                this.cacheEllipse.height = distanceTraveled * 2.0;
                boolean isHit = false;
                if (otherWave.isMeleeWave) {
                    isHit = this.cacheEllipse.intersects(this.botRect) && otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) >= 18.0 - otherWave.bulletVelocity - 1.0;
                } else {
                    boolean bl = isHit = otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) < 18.0 && otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) > -25.455599999999997 - otherWave.bulletVelocity;
                }
                if (isHit) {
                    double waveDist = otherWave.distance(x, y);
                    double bandwidth = 2.0 * Math.asin(18.0 / waveDist);
                    if (this.MELEE_BOTDANGER_MODE) {
                        bandwidth *= 1.125;
                    }
                    double hitAngle = LUtils.absoluteBearing(otherWave.x, otherWave.y, x, y);
                    ++hitCount;
                    double currentRisk = 0.0;
                    double waveRisk = this.getDangerScoreWithShadow(otherWave, hitAngle, bandwidth, false);
                    if (!otherWave.isRamWave) {
                        waveRisk = otherWave.isMeleeWave ? (waveRisk *= Rules.getBulletDamage((double)otherWave.bulletPower)) : (waveRisk *= Rules.getBulletDamage((double)otherWave.bulletPower));
                    }
                    if (this.MELEE_BOTDANGER_MODE) {
                        waveRisk += 1.0;
                        if (otherWave.isMyWave) {
                            waveRisk *= 1.1;
                        }
                        waveRisk /= waveDist;
                    }
                    this.waveRiskCount += 1.0;
                    this.sumWaveRisk += waveRisk;
                    if (this.MELEE_BOTDANGER_MODE) {
                        double waveWeight = this._others * 2 + 1;
                        waveWeight = 1.0;
                        if (otherWave.isMeleeWave && otherWave.isRamWave) {
                            waveWeight = 0.0;
                        }
                        currentRisk = waveWeight * waveRisk;
                    } else {
                        currentRisk = waveRisk;
                    }
                    if (this.MELEE_BOTDANGER_MODE) {
                        currentDistanceToWaveSource = otherWave.distance(x, y);
                        currentDistanceToWave = currentDistanceToWaveSource - otherWave.getDistanceTraveled(simTime);
                        timeToImpact = Math.max(1.0, currentDistanceToWave / otherWave.bulletVelocity);
                        currentRisk /= timeToImpact;
                    } else {
                        currentDistanceToWaveSource = otherWave.distance(x, y);
                        currentDistanceToWave = currentDistanceToWaveSource - otherWave.getDistanceTraveled(simTime);
                        timeToImpact = Math.max(1.0, currentDistanceToWave / otherWave.bulletVelocity);
                        currentRisk /= timeToImpact;
                    }
                    risk += currentRisk;
                    if (this.PATH_DRAW_MODE) {
                        SurfPathPos pathPos = new SurfPathPos().setX(x).setY(y).setSize(3.0);
                        if (otherWave.isMyWave) {
                            pathPos.color = Color.cyan;
                        }
                        drawPathDest.add(pathPos);
                    }
                }
                if (!this.MELEE_BRANCH_MODE) {
                    if (!(otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) <= otherWave.bulletVelocity) || !(otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) >= 0.0)) continue;
                    isBranch = true;
                    continue;
                }
                if (depth == 1 && isHit) {
                    isBranch = true;
                    continue;
                }
                if (simTime - this._time < 30L) continue;
                isBranch = true;
            }
            if (!isBranch) continue;
            if (this.PATH_DRAW_MODE) {
                SurfPathPos pos = new SurfPathPos().setX(x).setY(y).setSize(18.0);
                pos.isConnected = false;
                if (!LConstants.roundRect.contains(x, y)) {
                    pos.color = Color.red;
                }
                drawPathDest.add(pos);
            }
            if (this.MELEE_SURF_MODE) {
                risk /= (double)Math.max(1, hitCount);
            }
            if (depth > 0) {
                if (this._others <= 1 && !this.MELEE_SURF_MODE && !this.MELEE_BRANCH_MODE) {
                    lastDestX = x;
                    lastDestY = y;
                }
                double bestSecondRisk = Double.POSITIVE_INFINITY;
                ArrayList<SurfPathPos> bestSecondPaths = null;
                if (!this.MELEE_SURF_MODE) {
                    double nextRisk;
                    ArrayList<SurfPathPos> secondPaths = null;
                    if (this.PATH_DRAW_MODE) {
                        secondPaths = new ArrayList<SurfPathPos>();
                    }
                    if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, goAngle, 9, simTime, secondPaths, duelEnX, duelEnY, duelEnHeading, duelEnVelocity)) < bestSecondRisk) {
                        bestSecondRisk = nextRisk;
                        bestSecondPaths = secondPaths;
                    }
                    secondPaths = null;
                    if (this.PATH_DRAW_MODE) {
                        secondPaths = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, goAngle, 10, simTime, secondPaths, duelEnX, duelEnY, duelEnHeading, duelEnVelocity)) < bestSecondRisk) {
                        bestSecondRisk = nextRisk;
                        bestSecondPaths = secondPaths;
                    }
                    if (!surfWave.isRamWave && surfWave.distanceSq(this._myPos) > 62500.0) {
                        secondPaths = null;
                        if (this.PATH_DRAW_MODE) {
                            secondPaths = new ArrayList();
                        }
                        if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 0.0, depth - 1, goAngle, 9, simTime, secondPaths, duelEnX, duelEnY, duelEnHeading, duelEnVelocity)) < bestSecondRisk) {
                            bestSecondRisk = nextRisk;
                            bestSecondPaths = secondPaths;
                        }
                    }
                    risk += bestSecondRisk;
                } else {
                    double nextRisk;
                    double bestSecondDestX = lastSecondDestCacheX;
                    double bestSecondDestY = lastSecondDestCacheY;
                    double bestSecondMaxVelocity = 8.0;
                    ArrayList<SurfPathPos> secondPaths = null;
                    double bestDestX = x;
                    double bestDestY = y;
                    int direction = SECOND_DIRECTIONS;
                    double dist = FIRST_LENGTH;
                    double offset = 0.0;
                    if (PATH_RANDOM_SEARCH) {
                        offset = Math.random() * Math.PI * 10.0;
                    }
                    if (!DIA_MODE && !TRON_MODE) {
                        OptimalPointPlacer.computePoints((RoundRectangle2D.Double)LConstants.roundRect, x, y, heading, dist, OptimalPointPlacer.intersectionBuf, OptimalPointPlacer.resultX, OptimalPointPlacer.resultY);
                        for (i = 0; i < 4; ++i) {
                            double nextRisk2;
                            double nextDestX = OptimalPointPlacer.resultX[i];
                            double nextDestY = OptimalPointPlacer.resultY[i];
                            double dirAngle = LUtils.absoluteBearing(x, y, nextDestX, nextDestY);
                            if (this.PATH_DRAW_MODE) {
                                secondPaths = new ArrayList();
                            }
                            if (!(bestSecondRisk > (nextRisk2 = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle, -1, simTime, secondPaths, nextDestX, nextDestY, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity)))) continue;
                            bestSecondPaths = secondPaths;
                            bestSecondRisk = nextRisk2;
                            bestDestX = nextDestX;
                            bestDestY = nextDestY;
                            bestSecondDestX = lastSecondDestX;
                            bestSecondDestY = lastSecondDestY;
                        }
                    } else {
                        for (i = 0; i < direction; ++i) {
                            int margin;
                            if (this.PATH_DRAW_MODE) {
                                secondPaths = new ArrayList<SurfPathPos>();
                            }
                            double dirAngle = heading + Math.toRadians((double)i * (360.0 / (double)direction));
                            dirAngle = DIA_MODE ? Math.toRadians(45.0 + (double)i * (360.0 / (double)direction)) : (TRON_MODE ? Math.toRadians((double)i * (360.0 / (double)direction)) : offset + heading + Math.toRadians((double)i * (360.0 / (double)direction)));
                            double nextDestX = x + Math.sin(dirAngle) * dist;
                            double nextDestY = y + Math.cos(dirAngle) * dist;
                            if (!DIA_MODE && !TRON_MODE) {
                                dirAngle = this.meleePreciseSmooth(x, y, dirAngle);
                            } else {
                                margin = 20;
                                if (!LConstants.safeField.contains(nextDestX = LUtils.limit((double)margin, nextDestX, LConstants.fieldWidth - (double)margin), nextDestY = LUtils.limit((double)margin, nextDestY, LConstants.fieldHeight - (double)margin))) continue;
                            }
                            margin = 20;
                            LUtils.projectToBoundary(LConstants.roundRect, nextDestX, nextDestY, this.cache);
                            nextDestX = this.cache.x;
                            nextDestY = this.cache.y;
                            dirAngle = LUtils.absoluteBearing(x, y, nextDestX, nextDestY);
                            nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle, -1, simTime, secondPaths, nextDestX, nextDestY, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity);
                            if (!(bestSecondRisk > nextRisk)) continue;
                            bestSecondPaths = secondPaths;
                            bestSecondRisk = nextRisk;
                            bestDestX = nextDestX;
                            bestDestY = nextDestY;
                            bestSecondDestX = lastSecondDestX;
                            bestSecondDestY = lastSecondDestY;
                        }
                    }
                    if (!DIA_MODE && !TRON_MODE) {
                        double nextRisk3;
                        double stopY;
                        double stopX;
                        double dirAngle;
                        double nextRisk4;
                        if (this.PATH_DRAW_MODE) {
                            secondPaths = new ArrayList();
                        }
                        if (bestSecondRisk > (nextRisk4 = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle = heading, -1, simTime, secondPaths, stopX = x + Math.sin(dirAngle) * 20.0, stopY = y + Math.cos(dirAngle) * 20.0, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity))) {
                            bestSecondRisk = nextRisk4;
                            bestSecondPaths = secondPaths;
                            bestDestX = stopX;
                            bestDestY = stopY;
                            bestSecondDestX = stopX;
                            bestSecondDestY = stopY;
                            bestSecondMaxVelocity = 8.0;
                        }
                        if (CORNER_STICK) {
                            double cornerPosY1;
                            double cornerPosX1;
                            double dirAngle2;
                            int xdir = LUtils.sign(LConstants.fieldCenter.x - this.currentCorner.x);
                            int ydir = LUtils.sign(LConstants.fieldCenter.y - this.currentCorner.y);
                            if (this.PATH_DRAW_MODE) {
                                secondPaths = new ArrayList();
                            }
                            if (bestSecondRisk > (nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle2 = LUtils.absoluteBearing(x, y, cornerPosX1 = this.currentCorner.x + CORNER_STICK_MARGIN * (double)xdir, cornerPosY1 = this.currentCorner.y + CORNER_STICK_DIST * (double)ydir), -1, simTime, secondPaths, cornerPosX1, cornerPosY1, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity))) {
                                bestSecondPaths = secondPaths;
                                bestSecondRisk = nextRisk;
                                bestDestX = cornerPosX1;
                                bestDestY = cornerPosY1;
                                bestSecondDestX = lastSecondDestX;
                                bestSecondDestY = lastSecondDestY;
                            }
                            if (this.PATH_DRAW_MODE) {
                                secondPaths = new ArrayList();
                            }
                            double cornerPosX2 = this.currentCorner.x + CORNER_STICK_DIST * (double)xdir;
                            double cornerPosY2 = this.currentCorner.y + CORNER_STICK_MARGIN * (double)ydir;
                            dirAngle2 = LUtils.absoluteBearing(x, y, cornerPosX1, cornerPosY1);
                            nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle2, -1, simTime, secondPaths, cornerPosX2, cornerPosY2, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity);
                            if (bestSecondRisk > nextRisk) {
                                bestSecondPaths = secondPaths;
                                bestSecondRisk = nextRisk;
                                bestDestX = cornerPosX2;
                                bestDestY = cornerPosY2;
                                bestSecondDestX = lastSecondDestX;
                                bestSecondDestY = lastSecondDestY;
                            }
                        }
                        double dirAngle3 = LUtils.absoluteBearing(x, y, lastSecondDestCacheX, lastSecondDestCacheY);
                        if (this.PATH_DRAW_MODE) {
                            secondPaths = new ArrayList();
                        }
                        if (bestSecondRisk > (nextRisk3 = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle3, -1, simTime, secondPaths, lastSecondDestCacheX, lastSecondDestCacheY, 8.0, bestSecondRisk + risk, duelEnX, duelEnY, duelEnHeading, duelEnVelocity)) * CURRENT_BESTDEST_BONUS) {
                            bestSecondPaths = secondPaths;
                            bestSecondRisk = nextRisk3;
                            bestDestX = lastSecondDestCacheX;
                            bestDestY = lastSecondDestCacheY;
                            bestSecondDestX = lastSecondDestX;
                            bestSecondDestY = lastSecondDestY;
                        }
                    }
                    lastSecondDestX = bestDestX;
                    lastSecondDestY = bestDestY;
                    lastMaxVelocity = bestSecondMaxVelocity;
                    risk += bestSecondRisk;
                }
                if (this.PATH_DRAW_MODE && bestSecondPaths != null) {
                    drawPathDest.addAll(bestSecondPaths);
                }
            }
            if (this.MELEE_BOTDANGER_MODE) {
                double nextY;
                double botRisk = this.getBotRisk(x, y, heading, destX, destY, simTime, false) * (1.0 / (double)(depth + 1));
                this.sumBotRisk += botRisk;
                this.botRiskCount += 1.0;
                double nextX = x + Math.sin(heading) * velocity;
                if (!LConstants.safeField.contains(nextX, nextY = y + Math.cos(heading) * velocity) && LConstants.safeField.contains(firstX, firstY)) {
                    risk += (double)OUTSIDE_PENALTY / 5.0;
                    risk *= (double)OUTSIDE_PENALTY_MUL;
                }
                risk += botRisk;
            }
            return risk;
        }
        if (this.MELEE_BOTDANGER_MODE) {
            risk /= (double)Math.max(hitCount, 1);
            double botRisk = this.getBotRisk(x, y, heading, destX, destY, simTime, false) * (1.0 / (double)(depth + 1));
            this.sumBotRisk += botRisk;
            this.botRiskCount += 1.0;
            risk += botRisk;
        }
        return risk;
    }

    public double getBotRisk(double x, double y, double heading, double destX, double destY, long time, boolean isDrawMode) {
        double risk = 0.0;
        ++this.riskCalled;
        this.currentGOTOLine.setLine(x, y, destX, destY);
        x = destX;
        y = destY;
        double count = 0.0;
        for (Bot bot : Radar.aliveEnemyList) {
            ++this.botRiskLoops;
            if (!bot.isAlive || bot.currentState == null || bot.name.equals("aaa.r.ScalarR 0.005h.053") || bot.name.equals("aaa.r.ScalarR 0.005h.047") || bot.name.equals("eem.IWillFireNoBullet v2.8")) continue;
            count += 1.0;
            BotState state = bot.currentState;
            double energyRatio = LUtils.limit(0.5, 1.0 + state.energy / this._energy, 2.0);
            energyRatio = state.energy;
            double sui = 1.0 + Math.abs(Math.cos(LUtils.absoluteBearing(state.x, state.y, x, y) - heading));
            double pointDistance = Math.max(0.0, Point2D.distanceSq(x, y, state.x, state.y) - 30.0);
            int closer = bot.newBotsCloser(pointDistance, Radar.aliveEnemyList);
            double strongRatio = LUtils.limit(1.0, 1.0 + bot.getStrongScore() / Radar.totalStrengthValue / 2.0, 1.5);
            strongRatio = 1.0;
            double tempRisk = (energyRatio + 50.0) / (pointDistance + 0.01);
            if (this.isThisEnemyDanger(closer, bot, time)) {
                tempRisk *= 2.0 * sui;
            }
            risk += tempRisk;
        }
        if (!LConstants.roundRect.contains(destX, destY)) {
            risk *= 1.5;
        }
        double returnRisk = risk;
        if (!isDrawMode) {
            this.medianPosDangers.add(returnRisk);
        }
        return returnRisk * this.medianPos;
    }

    public boolean isThisEnemyDanger(Bot bot, long time) {
        return bot.lastAimedTime < 30L || bot.lastHitTime > time - 200L || bot.nearestBotName.equals(Radar.myName);
    }

    public boolean isThisEnemyDanger(int closer, Bot bot, long time) {
        return closer <= 1 || bot.lastAimedTime < 30L || bot.lastHitTime > time - 200L || bot.nearestBotName.equals(Radar.myName);
    }

    public void setCorner(double x, double y, Point2D.Double cache) {
        if (x <= LConstants.fieldWidth / 2.0) {
            if (y <= LConstants.fieldHeight / 2.0) {
                cache.setLocation(0.0, 0.0);
            } else {
                cache.setLocation(0.0, LConstants.fieldHeight);
            }
        } else if (y <= LConstants.fieldHeight / 2.0) {
            cache.setLocation(LConstants.fieldWidth, 0.0);
        } else {
            cache.setLocation(LConstants.fieldWidth, LConstants.fieldHeight);
        }
    }

    public double getDangerScoreWithShadow(SurfWave w, double hitAngle, double hitBandwidth, boolean isDrawMode) {
        double danger = this.getDangerScore(w, hitAngle, hitBandwidth, isDrawMode);
        double factor = LUtils.limit(0.1, 1.0 - w.coveredWidthByShadow(hitAngle, hitBandwidth), 1.0);
        return danger *= factor;
    }

    public double getDangerScore(SurfWave w, double hitAngle, double hitBandwidth, boolean isDrawMode) {
        long then = System.nanoTime();
        if (w.isFallbackWave) {
            return 0.0;
        }
        if (w.isRamWave) {
            return this.ramDanger(w, hitAngle, hitBandwidth) / 3.0;
        }
        int counter = 0;
        int totalEnableSize = 0;
        double totalDanger = 0.0;
        double totalScanWeight = 0.0;
        totalEnableSize += w.allNearestNeighbors.size();
        for (KNNResultWithWave knnResultWithWave : w.allNearestNeighbors) {
            ++counter;
            KNNData<GFData> gfData = knnResultWithWave.neighbor;
            double density = 0.0;
            double viewScanWeight = 0.0;
            double scanWeight = ((GFData)gfData.data).weight * gfData.treeWeight;
            if (w.isMeleeWave) {
                scanWeight *= knnResultWithWave.distanceWeight;
                if (w.nearestBotFromSource.equals(knnResultWithWave.waveData.name)) {
                    scanWeight *= 2.0;
                }
            }
            double xFiringAngle = LUtils.normalizeAngle(w.firingAngle(knnResultWithWave.waveData, ((GFData)gfData.data).guessFactor), hitAngle);
            double ux = (xFiringAngle - hitAngle) / hitBandwidth;
            totalScanWeight += (viewScanWeight += scanWeight);
            totalDanger += (density += (scanWeight /= Math.sqrt(gfData.distance + 1.0)) * Math.pow(2.0, -Math.abs(ux)));
        }
        double tempTotalDanger = totalDanger;
        if (w.isMeleeWave) {
            for (SurfWave.WaveData waveData : w.waveDataArrayList) {
                double scanWeight = 0.01;
                if (w.isMeleeWave && w.nearestBotFromSource.equals(waveData.name)) {
                    scanWeight *= 2.0;
                }
                double xFiringAngle = LUtils.normalizeAngle(waveData.directAngle, hitAngle);
                double ux = (xFiringAngle - hitAngle) / hitBandwidth;
                totalDanger += scanWeight * Math.pow(2.0, -Math.abs(ux));
                totalScanWeight += scanWeight;
            }
        }
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        this.dangerTime += millis;
        ++this.dangerCalled;
        double finalRisk = 0.0;
        finalRisk = totalEnableSize == 0 || counter <= 0 ? this.defaultDanger(w, hitAngle, hitBandwidth) : totalDanger / totalScanWeight;
        if (this.MELEE_BOTDANGER_MODE) {
            finalRisk = Math.pow(finalRisk, 3.0);
        }
        if (!isDrawMode) {
            this.medianWaveDangers.add(finalRisk);
        }
        return finalRisk * this.medianWave;
    }

    private double ramDanger(SurfWave w, double hitAngle, double hitBandwidth) {
        double[] guessFactors = new double[]{0.0};
        double[] weights = new double[]{1.0};
        double danger = 0.0;
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            for (int x = 0; x < guessFactors.length; ++x) {
                double firingAngle = waveData.directAngle + guessFactors[x] * (double)waveData.direction * w.maxEscapeAngle();
                double ux = (firingAngle - LUtils.normalizeAngle(hitAngle, firingAngle)) / hitBandwidth;
                danger += weights[x] * Math.exp(-0.5 * (ux * ux));
            }
        }
        return danger;
    }

    private double defaultDanger(SurfWave w, double hitAngle, double hitBandwidth) {
        double[] guessFactors = new double[]{0.0};
        double[] weights = new double[]{1.0};
        double totalDanger = 0.0;
        double totalWeight = 0.0;
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            double danger = 0.0;
            double weight = 0.0;
            if (w.sourceBot.useDefaultHOT) {
                for (int x = 0; x < guessFactors.length; ++x) {
                    weight += weights[x];
                    double xFiringAngle = LUtils.normalizeAngle(waveData.directAngle, hitAngle);
                    double ux = (xFiringAngle - hitAngle) / hitBandwidth;
                    danger += weights[x] * Math.pow(2.0, -Math.abs(ux));
                }
            }
            if (!w.isMeleeWave && w.sourceBot.useDefaultLinear) {
                double firingAngle = waveData.directAngle + Math.asin(waveData.targetGunData.youLatVel / w.bulletVelocity);
                weight += 1.0;
                double xFiringAngle = LUtils.normalizeAngle(firingAngle, hitAngle);
                double ux = (xFiringAngle - hitAngle) / hitBandwidth;
                danger += 1.0 * Math.pow(2.0, -Math.abs(ux));
            }
            totalDanger += danger;
            totalWeight += weight;
        }
        return totalDanger / totalWeight;
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * (double)WALL_STICK;
        double testY = y + Math.cos(angle) * (double)WALL_STICK;
        double extra = 18.5;
        double wallDistanceX = Math.min(x - extra, LConstants.fieldWidth - x - extra);
        double wallDistanceY = Math.min(y - extra, LConstants.fieldHeight - y - extra);
        double testDistanceX = Math.min(testX - extra, LConstants.fieldWidth - testX - extra);
        double testDistanceY = Math.min(testY - extra, LConstants.fieldHeight - testY - extra);
        double adjacent = 0.0;
        int g = 0;
        while (!LConstants.safeField.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / (double)WALL_STICK)) + 0.005)) * (double)WALL_STICK;
            testY = y + Math.cos(angle) * (double)WALL_STICK;
            testDistanceX = Math.min(testX - extra, LConstants.fieldWidth - testX - extra);
            testDistanceY = Math.min(testY - extra, LConstants.fieldHeight - testY - extra);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    public void updateWaves() {
        Graphics2D g = this._robot.getGraphics();
        ArrayList<ShadowBullet> realBullets = LambdaGun.realBullets;
        for (int i = 0; i < realBullets.size(); ++i) {
            ShadowBullet bullet = realBullets.get(i);
            if (this.PATH_DRAW_MODE) {
                Point2D.Double cur = bullet.simulatePos(this._time);
                Point2D.Double next = bullet.simulatePos(this._time + 1L);
                g.setColor(Color.white);
                g.drawLine((int)cur.x, (int)cur.y, (int)next.x, (int)next.y);
            }
            if (LConstants.field.contains(bullet.simulatePos(this._time))) continue;
            realBullets.remove(i);
            --i;
        }
        for (int x = 0; x < _waves.size(); ++x) {
            SurfWave w = _waves.get(x);
            w.updatedCount += 1.0;
            Bot bot = Radar.getBot(w.sourceName);
            if (this._others <= 1) {
                this.setShadows(w);
            }
            this.botRect.setRect(this._myPos.x - 18.0, this._myPos.y - 18.0, 36.0, 36.0);
            double distanceTraveled = w.getDistanceTraveled(this._time);
            this.cacheEllipse.x = w.x - distanceTraveled;
            this.cacheEllipse.y = w.y - distanceTraveled;
            this.cacheEllipse.width = distanceTraveled * 2.0;
            this.cacheEllipse.height = distanceTraveled * 2.0;
            if (w.getDistanceTraveled(this._time) > this._myPos.distance(w) + w.bulletVelocity * 1.0 + 18.0) {
                if (bot != null) {
                    for (SurfWave.WaveData waveData : w.waveDataArrayList) {
                        GFData data = new GFData();
                        data.guessFactor = w.guessFactor(waveData, this._myPos);
                        data.weight = 1.0;
                        if (w.isMeleeWave) continue;
                        if (bot.FLATTENER_LOG) {
                            for (SurfKNNModel surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                                surfKNNModel.addPoint(w, waveData, data);
                            }
                        }
                        if (!bot.FLATTENER_ENABLE && !FLATTENER_ONLY_MODE) continue;
                        for (SurfWave surfWave : _waves) {
                            this.updateNearestNeighbors(surfWave);
                        }
                    }
                }
                _waves.remove(x);
                --x;
                continue;
            }
            if (w.isRamWave && (this._time - w.fireTime > 1L || w.updatedCount > 2.0)) {
                _waves.remove(x);
                --x;
                continue;
            }
            if (w.hasNeighbors) continue;
            this.updateNearestNeighbors(w);
        }
    }

    public void setShadows(SurfWave w) {
        boolean updated = false;
        block0: for (ShadowBullet bullet : LambdaGun.realBullets) {
            long startTime = Math.max(w.fireTime, bullet.fireTime);
            if (w.processedBullets.containsKey(bullet) || !(w.distanceSq(bullet.simulatePos(startTime)) > LUtils.square(w.getDistanceTraveled(startTime)))) continue;
            long time = startTime;
            int counter = 0;
            do {
                if (!(w.distanceSq(bullet.simulatePos(++time)) < LUtils.square(w.getDistanceTraveled(time))) || ++counter >= 400) continue;
                w.addBulletShadows(bullet, time);
                updated = true;
                continue block0;
            } while (LConstants.field.contains(bullet.simulatePos(time)));
        }
        if (updated) {
            this.updateNearestNeighbors(w);
        }
    }

    public void updateNearestNeighbors(SurfWave w) {
        w.hasNeighbors = true;
        w.allNearestNeighbors = new ArrayList();
        Bot bot = Radar.getBot(w.sourceName);
        int discard = 0;
        int allData = 0;
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            ArrayList<KNNData<GFData>> nearestNeighbors = new ArrayList<KNNData<GFData>>();
            if (!w.isMeleeWave) {
                if (FLATTENER_ONLY_MODE) {
                    for (SurfKNNModel<GFData> surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                        nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                    }
                } else {
                    for (SurfKNNModel<GFData> surfKNNModel : bot.surfKNNModels.get(waveData.name)) {
                        nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData, surfKNNModel.kDivisor));
                    }
                    if (bot.FLATTENER_ENABLE) {
                        for (SurfKNNModel<GFData> surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                            nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                        }
                    }
                }
            } else {
                for (SurfKNNModel<GFData> surfKNNModel : bot.surfMeleeKNNModels.get(waveData.name)) {
                    nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                }
            }
            waveData.nearestNeighbors = nearestNeighbors;
            for (KNNData kNNData : nearestNeighbors) {
                ++allData;
                if (Math.abs(LUtils.absoluteBearing(w.x, w.y, this._myPos.x, this._myPos.y) - w.firingAngle(waveData, ((GFData)kNNData.data).guessFactor)) < w.maxEscapeAngle() + 1.0471975511965976) {
                    double dist = w.distance(waveData.targetState.x, waveData.targetState.y);
                    w.allNearestNeighbors.add(new KNNResultWithWave(kNNData, waveData).setDistanceWeight(1.0 / dist * dist));
                    continue;
                }
                ++discard;
            }
        }
    }

    public SurfWave getClosestSurfableWave(ArrayList<SurfWave> waves, double x, double y, long currentTime) {
        double closestBFT = Double.POSITIVE_INFINITY;
        SurfWave surfWave = null;
        int size = waves.size();
        if (size == 0) {
            return null;
        }
        for (SurfWave ew : waves) {
            if (this._others <= 1 && surfWave == null) {
                surfWave = ew;
            }
            double distance = ew.distance(x, y) - ew.getDistanceTraveled(currentTime);
            double bft = distance / ew.bulletVelocity;
            if (this._others > 1) {
                if (!(distance > 18.0 - ew.bulletVelocity - 1.0) || !(bft < closestBFT)) continue;
                surfWave = ew;
                closestBFT = bft;
                continue;
            }
            if (!(distance >= 0.0) || !(bft < closestBFT)) continue;
            surfWave = ew;
            closestBFT = bft;
        }
        return surfWave;
    }

    public void logHit(SurfWave w, Point2D.Double hitPos) {
        Bot bot = Radar.getBot(w.sourceName);
        if (bot != null) {
            for (SurfWave.WaveData waveData : w.waveDataArrayList) {
                double gf = w.guessFactor(waveData, hitPos);
                double botwidth = Math.asin(36.0 / w.distance(hitPos.x, hitPos.y));
                if (!(gf >= -w.maxEscapeAngle() - botwidth && gf <= w.maxEscapeAngle() + botwidth) && w.isMeleeWave) continue;
                GFData data = new GFData();
                data.guessFactor = gf;
                data.weight = 1.0;
                if (!w.isMeleeWave) {
                    for (SurfKNNModel<GFData> tree : bot.surfKNNModels.get(waveData.name)) {
                        tree.addPoint(w, waveData, data);
                    }
                } else {
                    for (SurfKNNModel<GFData> tree : bot.surfMeleeKNNModels.get(waveData.name)) {
                        tree.addPoint(w, waveData, data);
                    }
                }
                for (SurfKNNModel<GFData> tree : SurfDefaultTree.hotTrees) {
                    tree.addPoint(w, waveData, data);
                }
            }
            for (SurfWave ew : _waves) {
                this.updateNearestNeighbors(ew);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this._others <= 1) {
            this.duelHitLost += Rules.getBulletDamage((double)e.getPower());
        } else {
            this.meleeHitLost += Rules.getBulletDamage((double)e.getPower());
        }
        Bot bot = Radar.getBot(e.getName());
        if (bot != null && !_waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurfWave hitWave = null;
            SurfWave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < _waves.size(); ++x) {
                SurfWave w = _waves.get(x);
                if (Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - w.bulletVelocity) < 0.001 && Objects.equals(e.getBullet().getName(), w.sourceName)) {
                    hitWave = w;
                    break;
                }
                if (!Objects.equals(e.getBullet().getName(), w.sourceName) || !(this._myPos.distance(w) - w.getDistanceTraveled(e.getTime()) < bestDist)) continue;
                nearestWave = w;
                bestDist = this._myPos.distance(w) - w.getDistanceTraveled(e.getTime());
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                if (!hitWave.isMeleeWave) {
                    _waves.remove(hitWave);
                }
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("In \"onHitByBullet\" the nearest wave was recorded instead of the actual wave.");
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bot bot = Radar.getBot(e.getHitBullet().getName());
        if (bot != null && !_waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurfWave hitWave = null;
            SurfWave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            double bestScore = Double.POSITIVE_INFINITY;
            for (int x = 0; x < _waves.size(); ++x) {
                SurfWave w = _waves.get(x);
                if (Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w)) < bestScore && e.getHitBullet().getName().equals(w.sourceName)) {
                    hitWave = w;
                    bestScore = Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w));
                }
                if (!Objects.equals(e.getBullet().getName(), w.sourceName) || !(this._myPos.distance(w) - w.getDistanceTraveled(e.getTime()) < bestDist)) continue;
                nearestWave = w;
                bestDist = this._myPos.distance(w) - w.getDistanceTraveled(e.getTime());
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                if (!hitWave.isMeleeWave) {
                    _waves.remove(hitWave);
                }
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("In \"onBulletHitBullet\" the nearest wave was recorded instead of the actual wave.");
            }
        }
    }

    public void endTask() {
        System.out.println();
        System.out.println("duel pain: " + this.duelHitLost);
        System.out.println("melee pain: " + this.meleeHitLost);
        System.out.println();
        if (LConstants.LEARN_DEFAULTTREE_MODE) {
            Gson gson = new GsonBuilder().addReflectionAccessFilter(ReflectionAccessFilter.BLOCK_INACCESSIBLE_JAVA).create();
            String data = gson.toJson(SurfDefaultTree.hotTrees);
            System.out.println(data);
            try {
                String filename = "defaultTree";
                RobocodeFileOutputStream zipout = new RobocodeFileOutputStream(this._robot.getDataFile(filename + ".txt"));
                ObjectOutputStream out = new ObjectOutputStream((OutputStream)zipout);
                out.writeObject(data);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("***** skipped turn[" + e.getSkippedTurn() + "] *****");
        System.out.println("isProcessing?:" + this.isProcessing);
        System.out.println("node:" + this.nodes);
        System.out.println("cutNodes:" + this.cutNodes);
        System.out.println("riskCalled: " + this.riskCalled);
        System.out.println("loop:" + this.loops);
        System.out.println("check danger called:" + this.dangerCalled);
        System.out.println("danger time:" + this.dangerTime);
        System.out.println("*************************");
    }

    public void onMessageReceived(MessageEvent e) {
    }

    public void onPaint(Graphics2D g) {
        this.g = g;
        this.drawListener = true;
        g.setColor(Color.yellow);
        g.draw(LConstants.roundRect);
        g.setColor(Color.white);
        if (Radar.nearestBot != null && Radar.nearestBot.currentState != null) {
            g.drawString("distance:" + Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y), 30, 30);
        }
        g.drawString("doFallbackMove:" + this.fallback_move, 30, 270);
        g.drawString("riskRatio:" + (double)this.medianWaveDangers.size() / (double)this.medianPosDangers.size() + "  (" + this.medianWaveDangers.size() + "/" + this.medianPosDangers.size() + ")", 30, 250);
        g.drawString("waveMedian:" + this.medianWave, 30, 230);
        g.drawString("posMedian:" + this.medianPos, 30, 210);
        g.drawString("node:" + this.nodes, 30, 150);
        g.drawString("cutNodes:" + this.cutNodes, 30, 130);
        g.drawString("riskCalled:" + this.riskCalled, 30, 110);
        g.drawString("loop:" + this.loops, 30, 90);
        g.drawString("check danger called:" + this.dangerCalled, 30, 70);
        g.drawString("danger time:" + this.dangerTime, 30, 50);
        g.drawString("botRiskCount:" + this.botRiskCount, 30, 170);
        g.drawString("botRiskLoops:" + this.botRiskLoops, 30, 190);
        double vel = this._robot.getVelocity();
        double heading = this._robot.getHeadingRadians();
        Point2D.Double dangerLocation = new Point2D.Double();
        Point2D.Double oldDrawLocation = new Point2D.Double();
        Point2D.Double drawLocation = new Point2D.Double();
        Point2D.Double lengthLocation = new Point2D.Double();
        Point2D.Double drawLocationBuffer = null;
        if (this.MELEE_BOTDANGER_MODE) {
            double pointWidth = 20.0;
            double pointHeight = 20.0;
            Point2D.Double[] botRiskPosList = new Point2D.Double[(int)(pointWidth * pointHeight)];
            double[] botRiskPosDangerList = new double[(int)(pointWidth * pointHeight)];
            double maxPosDanger = Double.NEGATIVE_INFINITY;
            double minPosDanger = Double.POSITIVE_INFINITY;
            double totalPosDanger = 0.0;
            int i = 0;
            while ((double)i < pointWidth) {
                int j = 0;
                while ((double)j < pointHeight) {
                    double x = (double)i * (LConstants.fieldWidth / pointWidth) + LConstants.fieldWidth / pointWidth / 2.0;
                    double y = (double)j * (LConstants.fieldHeight / pointHeight) + LConstants.fieldHeight / pointHeight / 2.0;
                    double risk = this.getBotRisk(this._myPos.x, this._myPos.y, LUtils.absoluteBearing(this._myPos.x, this._myPos.y, x, y), x, y, this._time, true);
                    if ((risk = Math.pow(risk, -5.0)) > maxPosDanger) {
                        maxPosDanger = risk;
                    }
                    if (risk < minPosDanger) {
                        minPosDanger = risk;
                    }
                    totalPosDanger += risk;
                    botRiskPosList[(int)((double)i * pointWidth + (double)j)] = new Point2D.Double(x, y);
                    botRiskPosDangerList[(int)((double)i * pointWidth + (double)j)] = risk;
                    ++j;
                }
                ++i;
            }
            double avg = NonWaveMove.average(botRiskPosDangerList);
            double stDev = NonWaveMove.standardDeviation(botRiskPosDangerList);
            int posDrawSize = 5;
            for (int i2 = 0; i2 < botRiskPosList.length; ++i2) {
                Point2D.Double pos = botRiskPosList[i2];
                double risk = botRiskPosDangerList[i2];
                g.setColor(NonWaveMove.riskColor(risk - minPosDanger, avg - minPosDanger, stDev, false, 1.0));
                g.fillOval((int)pos.x - 3, (int)pos.y - 3, 6, 6);
            }
        }
        ArrayList<SurfWave> surfWaves = new ArrayList<SurfWave>();
        int waveCount = 0;
        int maxSurf = 1;
        if (this._others <= 1) {
            maxSurf = DUEL_DEPTH;
            waveCount = Math.min(_waves.size(), maxSurf);
        } else {
            waveCount = Math.min(_waves.size(), WAVE_SAMPLE);
            maxSurf = MELEE_DEPTH;
        }
        ArrayList clonedWaves = (ArrayList)_waves.clone();
        SurfWave surfWave = null;
        double lastWaveDist = 0.0;
        for (int i = 0; i < waveCount; ++i) {
            SurfWave nearWave = this.getClosestSurfableWave(clonedWaves, this._myPos.x, this._myPos.y, this._time);
            if (nearWave == null) continue;
            double waveDist = this._myPos.distance(nearWave.x, nearWave.y) / nearWave.bulletVelocity;
            if (this._others <= 1) {
                nearWave.doBranchWave = true;
                this.isContainingMyWave = true;
            }
            if (nearWave.isMyWave) {
                this.isContainingMyWave = true;
            }
            if (i == 0) {
                currentSurfWave = nearWave;
                surfWave = nearWave;
                lastWaveDist = waveDist;
            }
            surfWaves.add(nearWave);
            clonedWaves.remove(nearWave);
            if (!(waveDist - lastWaveDist > 10.0)) continue;
            lastWaveDist = waveDist;
        }
        SurfWave nearestWave = this.getClosestSurfableWave(_waves, this._myPos.x, this._myPos.y, this._time);
        for (SurfWave enemyWave : _waves) {
            int numBins = 360;
            if (!enemyWave.isMeleeWave) {
                numBins = 720;
            }
            double halfBins = (double)(numBins - 1) / 2.0;
            double[] gfDangers = new double[numBins];
            double[] gfShadowed = new double[numBins];
            double mea = Math.PI;
            g.setColor(Color.gray);
            if (surfWaves.contains(enemyWave)) {
                g.setColor(Color.orange);
            }
            if (enemyWave.isMyWave) {
                g.setColor(Color.white);
            }
            if (nearestWave == enemyWave) {
                g.setColor(Color.red);
            }
            int radius = (int)enemyWave.getDistanceTraveled(this._time);
            g.drawOval((int)(enemyWave.x - (double)radius), (int)(enemyWave.y - (double)radius), radius * 2, radius * 2);
            double currentDistanceToWaveSource = enemyWave.distance(this._myPos.x, this._myPos.y);
            double currentDistanceToWave = currentDistanceToWaveSource - enemyWave.getDistanceTraveled(this._time);
            double timeToImpact = Math.max(1.0, currentDistanceToWave / enemyWave.bulletVelocity);
            Color ori = g.getColor();
            Color col = new Color(g.getColor().getRed(), g.getColor().getGreen(), g.getColor().getBlue(), 75);
            for (SurfWave.WaveData data : enemyWave.waveDataArrayList) {
                if (data.name.equals(enemyWave.nearestBotFromSource)) {
                    g.setColor(ori);
                } else {
                    g.setColor(col);
                }
                Point2D.Double dirPos = LUtils.project(enemyWave, data.directAngle, radius);
                g.drawLine((int)enemyWave.x, (int)enemyWave.y, (int)dirPos.x, (int)dirPos.y);
                dirPos = LUtils.project(enemyWave, data.directAngle, radius + 5);
                g.drawString(data.name, (int)dirPos.x, (int)dirPos.y);
            }
            if (surfWaves.contains(enemyWave) || !enemyWave.isMeleeWave) {
                double minDanger = Double.POSITIVE_INFINITY;
                double maxDanger = Double.NEGATIVE_INFINITY;
                double maxPointDanger = Double.NEGATIVE_INFINITY;
                Point2D.Double maxDangerPos = null;
                double totalDanger = 0.0;
                for (int x = 0; x <= numBins - 1; ++x) {
                    double gf = ((double)x - halfBins) / halfBins;
                    double bearingOffset = gf * mea;
                    double absFiringAngle = 0.0 + bearingOffset;
                    LUtils.projectWithCache(enemyWave, absFiringAngle, enemyWave.getDistanceTraveled(this._time) + enemyWave.bulletVelocity, dangerLocation);
                    if (enemyWave.hasNeighbors) {
                        gfDangers[x] = this.getDangerScoreWithShadow(enemyWave, LUtils.absoluteBearing(enemyWave, dangerLocation), Math.asin(36.0 / enemyWave.distance(dangerLocation)), true);
                        totalDanger += gfDangers[x];
                    }
                    if (gfDangers[x] < minDanger) {
                        minDanger = gfDangers[x];
                    }
                    if (!(gfDangers[x] > maxDanger)) continue;
                    maxDanger = gfDangers[x];
                    maxDangerPos = dangerLocation;
                }
                totalDanger /= (double)numBins;
                Stroke cache = g.getStroke();
                g.setStroke(this.bs);
                for (int x = 0; x <= numBins - 1; ++x) {
                    double gf = ((double)x - halfBins) / halfBins;
                    double bearingOffset = gf * mea;
                    LUtils.projectWithCache(enemyWave, 0.0 + bearingOffset, enemyWave.getDistanceTraveled(this._time) - 10.0 + enemyWave.bulletVelocity, drawLocation);
                    if (maxPointDanger < gfDangers[x]) {
                        maxPointDanger = gfDangers[x];
                    }
                    int drawSize = 3;
                    if (enemyWave.isMeleeWave && gfDangers[x] / maxDanger > totalDanger / maxDanger + 0.5) {
                        Color binColor = this.getRedBlueColor(LUtils.limit(0.0, Math.pow(Math.max(0.0, gfDangers[x] - totalDanger) / (maxDanger - totalDanger), 2.0), 1.0));
                        g.setColor(binColor);
                        g.drawOval((int)drawLocation.x - drawSize, (int)drawLocation.y - drawSize, drawSize * 2, drawSize * 2);
                    } else if (!enemyWave.isMeleeWave && gfDangers[x] / maxDanger > 0.075) {
                        Color binColor = this.getRedBlueColor(gfDangers[x] / maxDanger);
                        g.setColor(binColor);
                        g.fillOval((int)drawLocation.x - drawSize, (int)drawLocation.y - drawSize, drawSize * 2, drawSize * 2);
                    }
                    if (!enemyWave.isMeleeWave) {
                        double length = 25.0 * (gfDangers[x] / maxDanger);
                        LUtils.projectWithCache(enemyWave, 0.0 + bearingOffset, enemyWave.getDistanceTraveled(this._time) - 10.0 + enemyWave.bulletVelocity + length, lengthLocation);
                        g.drawLine((int)drawLocation.x, (int)drawLocation.y, (int)lengthLocation.x, (int)lengthLocation.y);
                    }
                    drawLocationBuffer = oldDrawLocation;
                    oldDrawLocation = drawLocation;
                    drawLocation = drawLocationBuffer;
                }
                g.setStroke(cache);
            }
            Stroke cache = g.getStroke();
            g.setStroke(this.bs);
            for (SurfWave.BulletShadow shadow : enemyWave.shadows) {
                Point2D.Double p1 = LUtils.project(enemyWave, shadow.minAngle, enemyWave.getDistanceTraveled(this._time) - 2.0);
                Point2D.Double p2 = LUtils.project(enemyWave, shadow.maxAngle, enemyWave.getDistanceTraveled(this._time) - 2.0);
                g.setColor(Color.green);
                double rad = enemyWave.getDistanceTraveled(this._time) - 2.0;
                g.drawArc((int)(enemyWave.x - rad), (int)(enemyWave.y - rad), (int)(rad * 2.0), (int)(rad * 2.0), (int)Math.toDegrees(shadow.minAngle), (int)Math.toDegrees(Utils.normalRelativeAngle((double)(shadow.maxAngle - shadow.minAngle))));
            }
            g.setStroke(cache);
            for (SurfWave.WaveData waveData : enemyWave.waveDataArrayList) {
                for (KNNData<GFData> data : waveData.nearestNeighbors) {
                    g.setColor(data.color);
                    double bearingOffset = (double)waveData.direction * (((GFData)data.data).guessFactor * LUtils.maxEscapeAngle(enemyWave.bulletVelocity));
                    Point2D.Double pos = LUtils.project(enemyWave, waveData.directAngle + bearingOffset, enemyWave.getDistanceTraveled(this._time) - enemyWave.bulletVelocity);
                    int size = (int)(5.0 / Math.sqrt(data.order));
                    g.fillOval((int)pos.x - size, (int)pos.y - size, size * 2, size * 2);
                }
            }
        }
        g.setColor(Color.ORANGE);
        int radius = 5;
        g.fillOval((int)this.currentCorner.x - radius, (int)this.currentCorner.y - radius, radius * 2, radius * 2);
    }

    public Color getRedBlueColor(double d) {
        double colorAmp = 1.8;
        return new Color(Color.HSBtoRGB((float)(0.5 + Math.min(1.0, colorAmp * d / 3.6)), 1.0f, 1.0f));
    }

    public Color getColorForHitRate(double d) {
        return new Color((float)LUtils.limit(0.0, d, 1.0), (float)LUtils.limit(0, 0, 1), (float)LUtils.limit(0.0, 1.0 - d, 1.0));
    }

    public double median(double[] canBeDestroyedArray) {
        if (canBeDestroyedArray == null || canBeDestroyedArray.length == 0) {
            throw new IllegalArgumentException("\u914d\u5217\u304c\u7a7a\u3067\u3059");
        }
        int n = canBeDestroyedArray.length;
        if (n % 2 == 1) {
            return canBeDestroyedArray[n / 2];
        }
        return (canBeDestroyedArray[n / 2 - 1] + canBeDestroyedArray[n / 2]) / 2.0;
    }

    public double[] medianNormalize(double[] a) {
        double[] copy = Arrays.copyOf(a, a.length);
        Arrays.sort(copy);
        double scale = 1.0 / (1.0E-12 + this.median(copy));
        int i = 0;
        while (i < copy.length) {
            int n = i++;
            copy[n] = copy[n] * scale;
        }
        return copy;
    }

    public double[] medianNormalize(ArrayList<Double> list) {
        double[] a = new double[list.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = list.get(i);
        }
        return this.medianNormalize(a);
    }

    public double getMedianNormalizeScale(ArrayList<Double> list) {
        double[] a = new double[list.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = list.get(i);
        }
        Arrays.sort(a);
        return 1.0 / (1.0E-12 + this.median(a));
    }

    public double mad(double[] a) {
        double med = this.median(a);
        double[] diffs = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            diffs[i] = Math.abs(a[i] - med);
        }
        return this.median(diffs);
    }

    static {
        WAVE_SAMPLE = 8;
        CORNER_STICK = false;
        CORNER_STICK_MARGIN = 20.0;
        CORNER_STICK_DIST = 140.0;
        nextMyPos = new Point2D.Double();
        drawMEA = true;
        lastMaxVelocity = 8.0;
        lastDestX = Double.NaN;
        lastDestY = Double.NaN;
        lastSecondDestX = Double.NaN;
        lastSecondDestY = Double.NaN;
        lastSecondMaxVelocity = 8.0;
        lastSecondDestCacheX = Double.NaN;
        lastSecondDestCacheY = Double.NaN;
    }

    private static class DistanceController {
        private DistanceController() {
        }

        public double surfAttackAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.65);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            return this.attackAngle(currentDistance, 0.6);
        }

        public double surfEscapeFromRamAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.5);
            }
            return this.attackAngle(currentDistance, 1.0);
        }

        public double orbitAttackAngle(double currentDistance) {
            return this.attackAngle(currentDistance, 1.65);
        }

        private double attackAngle(double currentDistance, double offsetMultiplier) {
            double distanceFactor = (currentDistance - DESIRED_DISTANCE) / DESIRED_DISTANCE;
            return LUtils.limit(-MAX_ATTACK_ANGLE, distanceFactor * offsetMultiplier, MAX_ATTACK_ANGLE);
        }
    }
}

