/*
 * Decompiled with CFR 0.152.
 */
package pez.mako;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import pez.mako.AngularFactoredGun;
import pez.mako.BearingOffsetGun;
import pez.mako.Bot;
import pez.mako.CheckVirtualGunsCondition;
import pez.mako.DirectGun;
import pez.mako.FactorGun;
import pez.mako.LaserGun;
import pez.mako.RatingComparator;
import pez.mako.VirtualGun;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Mako
extends AdvancedRobot {
    private static Bot enemy;
    private static Bot me;
    private static final double DEFAULT_DISTANCE = 485.0;
    private static final double MAX_VELOCITY = 8.0;
    private static Rectangle2D fieldRectangle;
    private static Rectangle2D fluffedFieldRectangle;
    private static double velocity;
    private static boolean statsRestored;
    private static boolean isOneOnOne;
    private static int totalEncounters;
    private static RatingComparator ratingComparator;
    private static int wins;
    private static long enemyShots;
    private static long enemyHits;
    private static long hits;
    private double accumulatedAngle;
    private Point2D oldEnemyLocation;
    private Point2D oldRobotLocation;
    private boolean haveEnemy;
    private double enemyDistance;
    private double enemyEnergy;
    private String enemyName;
    private double enemyBulletPower = 3.0;
    private double absoluteBearing;
    private double deltaBearing;
    private double advancingVelocity;
    private boolean roundOver = false;

    public void run() {
        if (me == null) {
            me = new Bot(this.getName());
            fieldRectangle = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
            fluffedFieldRectangle = new Rectangle2D.Double(-125.0, -125.0, this.getBattleFieldWidth() + 125.0, this.getBattleFieldHeight() + 125.0);
            this.setColors(Color.gray, Color.gray, Color.black);
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        isOneOnOne = this.getOthers() == 1;
        double d = Math.random() < 0.5 ? 0.07 : 0.16;
        double d2 = Math.random() < 0.5 ? 48 : 80;
        while (true) {
            Bullet bullet;
            if (Math.random() < d) {
                velocity = Math.min(8.0, Math.random() * d2);
            }
            this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 45.0 ? 0.1 : velocity);
            if (!this.haveEnemy) {
                this.setTurnRadarLeft(22.5);
            }
            this.haveEnemy = false;
            if (this.getOthers() == 0) {
                this.move();
            }
            if (this.getOthers() > 0 && this.enemyEnergy > 0.0 && (this.getEnergy() > 0.3 || this.enemyDistance < 200.0 && (this.enemyEnergy < 1.0 || this.enemyEnergy > 10.0)) && (bullet = this.setFireBullet(this.bulletPower(this.enemyEnergy))) != null) {
                this.addCustomEvent(new CheckVirtualGunsCondition(bullet, this.deltaBearing, this.advancingVelocity, me, enemy, this));
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.enemyName = scannedRobotEvent.getName();
        if (enemy == null) {
            enemy = this.createEnemy(scannedRobotEvent.getName());
            this.restoreStats(scannedRobotEvent.getName());
        }
        me.updateLocation(this.getX(), this.getY());
        this.absoluteBearing = this.getHeading() + scannedRobotEvent.getBearing();
        this.advancingVelocity = -Math.cos(Math.toRadians(scannedRobotEvent.getHeading() - this.absoluteBearing)) * scannedRobotEvent.getVelocity();
        double d = this.enemyEnergy - scannedRobotEvent.getEnergy();
        if (d >= 0.1 && d <= 3.0) {
            ++enemyShots;
            this.enemyBulletPower = d;
        }
        this.enemyEnergy = scannedRobotEvent.getEnergy();
        this.enemyDistance = scannedRobotEvent.getDistance();
        Point2D.Double double_ = new Point2D.Double();
        Mako.toLocation(this.absoluteBearing, this.enemyDistance, me.getLocation(), double_);
        enemy.updateLocation(((Point2D)double_).getX(), ((Point2D)double_).getY());
        this.deltaBearing = Mako.rollingAvg(this.deltaBearing, Mako.absoluteBearing(me.getOldLocation(), enemy.getLocation()) - Mako.absoluteBearing(me.getOldLocation(), enemy.getOldLocation()), 5.0, 1.0);
        this.haveEnemy = true;
        double d2 = Mako.normalRelativeAngle(this.getHeading() + scannedRobotEvent.getBearing() - this.getRadarHeading()) * 1.6;
        this.setTurnRadarRight(d2);
        this.aimGun();
        this.move();
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        ++enemyHits;
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        ++hits;
    }

    public void onWin(WinEvent winEvent) {
        ++wins;
        if (!this.roundOver) {
            this.printStats();
            this.saveStats(this.enemyName);
        }
        this.roundOver = true;
    }

    public void onDeath(DeathEvent deathEvent) {
        if (!this.roundOver) {
            this.printStats();
            this.saveStats(this.enemyName);
        }
        this.roundOver = true;
    }

    private final void move() {
        if (this.oldEnemyLocation != null && Math.abs(this.getDistanceRemaining()) < 20.0) {
            Point2D.Double double_ = new Point2D.Double();
            double d = 20.0 - 3.0 * this.enemyBulletPower;
            double d2 = Math.toDegrees(Math.asin(8.0 / d));
            double d3 = Mako.absoluteBearing(this.oldEnemyLocation, me.getLocation()) - Mako.absoluteBearing(this.oldEnemyLocation, this.oldRobotLocation);
            this.accumulatedAngle += d3;
            double d4 = this.distanceFactor() * (d2 * 2.0 * Math.random() - d2);
            double d5 = Math.abs(this.accumulatedAngle + d4);
            if (d5 > d2) {
                d4 = (double)this.sign(d4) * (d2 - Math.abs(this.accumulatedAngle));
            } else if (d5 < d2 / 3.0) {
                d4 *= 1.7 * (double)this.sign(d3) * (Math.random() < 0.5 ? -0.2 : 1.0);
            }
            double d6 = this.distanceExtra() * Math.abs(d4);
            Mako.toLocation(this.absoluteBearing + 180.0 + d4, this.enemyDistance + d6, enemy.getLocation(), double_);
            if (!fluffedFieldRectangle.contains(double_)) {
                Mako.toLocation(this.absoluteBearing + 180.0 - d4, this.enemyDistance + d6, enemy.getLocation(), double_);
            }
            this.translateInsideField(double_, 35.0);
            this.oldEnemyLocation.setLocation(enemy.getLocation());
            this.oldRobotLocation.setLocation(me.getLocation());
            this.goTo(double_);
        } else {
            this.oldEnemyLocation = new Point2D.Double();
            this.oldEnemyLocation.setLocation(enemy.getLocation());
            this.oldRobotLocation = new Point2D.Double();
            this.oldRobotLocation.setLocation(me.getLocation());
        }
    }

    private final double distanceFactor() {
        if (this.enemyDistance < 190.0) {
            return 0.6;
        }
        if (this.enemyDistance < 250.0) {
            return 0.61;
        }
        if (this.enemyDistance > 500.0) {
            return 0.68;
        }
        return 0.635;
    }

    private final double distanceExtra() {
        double d = 3.0;
        if (this.enemyEnergy == 0.0 && this.getOthers() == 1) {
            d = -12.0;
        } else if (this.isCornered(me) && !this.isCornered(enemy)) {
            d = -1.0;
        } else if (this.enemyDistance < 100.0) {
            d = 12.0;
        } else if (this.enemyDistance > 485.0) {
            d = -1.0;
        }
        return d;
    }

    Bot createEnemy(String string) {
        Bot bot = new Bot(string);
        VirtualGun[][][] virtualGunArray = new VirtualGun[][][]{{{new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}}, {{new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}}, {{new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}, {new DirectGun(), new LaserGun(100.0), new AngularFactoredGun(10.0), new AngularFactoredGun(30.0), new AngularFactoredGun(70.0), new BearingOffsetGun(10.0), new BearingOffsetGun(30.0), new BearingOffsetGun(70.0)}}};
        bot.setVirtualGuns(virtualGunArray);
        return bot;
    }

    private final int sign(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    private final double bulletPower(double d) {
        double d2 = 2.0 + Math.random() * 30.0;
        d2 = Math.min(d2, 1800.0 / this.enemyDistance);
        d2 = Math.min(d2, d >= 4.0 ? (d + 2.0) / 6.0 : d / 4.0);
        d2 = Math.min(d2, this.getEnergy() / 4.0);
        return d2;
    }

    private final void aimGun() {
        VirtualGun[] virtualGunArray;
        double d = Mako.absoluteBearing(me.getLocation(), enemy.getLocation());
        double d2 = this.enemyDistance;
        double d3 = d;
        if (d2 > 60.0) {
            virtualGunArray = enemy.getVirtualGuns(this.deltaBearing, this.advancingVelocity);
            Arrays.sort(virtualGunArray, ratingComparator);
            VirtualGun virtualGun = virtualGunArray[0];
            if (virtualGun instanceof FactorGun) {
                d3 = ((FactorGun)virtualGun).guessedBearing(d, this.deltaBearing);
            }
        }
        virtualGunArray = new Point2D.Double();
        Mako.toLocation(d3, d2, me.getLocation(), (Point2D)virtualGunArray);
        this.translateInsideField((Point2D)virtualGunArray, 1.0);
        d3 = Mako.absoluteBearing(me.getLocation(), (Point2D)virtualGunArray);
        this.setTurnGunRight(Mako.normalRelativeAngle(d3 - this.getGunHeading()));
    }

    private final void goTo(Point2D point2D) {
        double d = me.getLocation().distance(point2D);
        double d2 = Mako.normalRelativeAngle(Mako.absoluteBearing(me.getLocation(), point2D) - this.getHeading());
        if (Math.abs(d2) > 90.0) {
            d *= -1.0;
            d2 = d2 > 0.0 ? (d2 -= 180.0) : (d2 += 180.0);
        }
        this.setTurnRight(d2);
        this.setAhead(d);
    }

    private final boolean isCornered(Bot bot) {
        double d;
        double d2 = d = 140.0;
        double d3 = d;
        double d4 = fieldRectangle.getWidth() - d;
        double d5 = fieldRectangle.getHeight() - d;
        double d6 = bot.getLocation().getX();
        double d7 = bot.getLocation().getY();
        return d6 < d2 && (d7 < d3 || d7 > d5) || d6 > d4 && (d7 < d3 || d7 > d5);
    }

    private static final double bulletVelocity(double d) {
        return 20.0 - 3.0 * d;
    }

    private static final double travelTime(double d, double d2) {
        return d / d2;
    }

    private final void translateInsideField(Point2D point2D, double d) {
        point2D.setLocation(Math.max(d, Math.min(fieldRectangle.getWidth() - d, point2D.getX())), Math.max(d, Math.min(fieldRectangle.getHeight() - d, point2D.getY())));
    }

    static void toLocation(double d, double d2, Point2D point2D, Point2D point2D2) {
        point2D2.setLocation(point2D.getX() + Math.sin(Math.toRadians(d)) * d2, point2D.getY() + Math.cos(Math.toRadians(d)) * d2);
    }

    static double absoluteBearing(Point2D point2D, Point2D point2D2) {
        return Math.toDegrees(Math.atan2(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY()));
    }

    static double normalRelativeAngle(double d) {
        double d2 = d % 360.0;
        if (d2 <= -180.0) {
            return 180.0 + d2 % 180.0;
        }
        if (d2 > 180.0) {
            return -180.0 + d2 % 180.0;
        }
        return d2;
    }

    public static double rollingAvg(double d, double d2, double d3, double d4) {
        return (d * d3 + d2 * d4) / (d3 + d4);
    }

    private final double percentageRounded(double d, double d2) {
        return (double)Math.round(10000.0 * d / d2) / 100.0;
    }

    private final double percentageRounded(long l, long l2) {
        return this.percentageRounded((double)l, (double)l2);
    }

    private final double percentageRounded(double d, long l) {
        return this.percentageRounded(d, (double)l);
    }

    private final double percentageRounded(long l, double d) {
        return this.percentageRounded((double)l, d);
    }

    private final void printStats() {
        ++totalEncounters;
        System.out.println("> " + hits + " / " + me.getShotCount() + " = " + this.percentageRounded(hits, me.getShotCount()) + "%");
        System.out.println("< " + enemyHits + " / " + enemyShots + " = " + this.percentageRounded(enemyHits, enemyShots) + "%");
        System.out.println("Wins: " + wins + " (" + this.percentageRounded((long)wins, (long)(this.getRoundNum() + 1)) + "%)");
    }

    private final void saveStats(String string) {
        try {
            PrintStream printStream = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(this.fileName(string))));
            printStream.println(totalEncounters);
            if (printStream.checkError()) {
                ((Robot)this).out.println("I could not write the stats!");
            }
            printStream.close();
        }
        catch (Exception exception) {
            ((Robot)this).out.println("An exception occured:" + exception);
        }
    }

    private final void restoreStats(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getDataFile(this.fileName(string))));
            totalEncounters = Integer.parseInt(bufferedReader.readLine());
        }
        catch (Exception exception) {
            ((Robot)this).out.println("Hmmm, maybe this guy is new in town: " + exception);
        }
        statsRestored = true;
    }

    private final String fileName(String string) {
        int n = string.indexOf(" ");
        String string2 = n != -1 ? string.substring(0, n) : string;
        if (!isOneOnOne) {
            string2 = string2 + "-Melee";
        }
        return string2;
    }

    static {
        velocity = 8.0;
        statsRestored = false;
        ratingComparator = new RatingComparator();
    }
}

