/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import java.awt.geom.Point2D;

public final class Enemy {
    private final String name;
    private double x;
    private double y;
    private double headingRadians;
    private double velocity;
    private double energy;
    private double danger;
    private double headingRadiansChange;
    private double acceleration;
    private long time;
    private final boolean target;

    public Enemy(String name, double x, double y) {
        this(name, x, y, 0.0, 0.0, 0.0, 0L, false, 1.0);
    }

    public Enemy(String name, double x, double y, double headingRadians, double velocity, double energy, long time, boolean target, double danger) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.headingRadians = headingRadians;
        this.velocity = velocity;
        this.energy = energy;
        this.time = time;
        this.target = target;
        this.danger = danger;
    }

    public String getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getHeadingRadians() {
        return this.headingRadians;
    }

    public void setHeadingRadians(double headingRadians) {
        this.headingRadians = headingRadians;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isTarget() {
        return this.target;
    }

    public double getDanger() {
        return this.danger;
    }

    public void setDanger(double danger) {
        this.danger = danger;
    }

    public double getHeadingRadiansChange() {
        return this.headingRadiansChange;
    }

    public void setHeadingRadiansChange(double headingRadiansChange) {
        this.headingRadiansChange = headingRadiansChange;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(double acceleration) {
        this.acceleration = acceleration;
    }

    public Point2D.Double guessPosition(long when) {
        double newX;
        double newY;
        double diff = when - this.time;
        if (Math.abs(this.headingRadiansChange) > 1.0E-5) {
            double radius = this.velocity / this.headingRadiansChange;
            double tothead = diff * this.headingRadiansChange;
            newY = this.y + Math.sin(this.headingRadians + tothead) * radius - Math.sin(this.headingRadians) * radius;
            newX = this.x + Math.cos(this.headingRadians) * radius - Math.cos(this.headingRadians + tothead) * radius;
        } else {
            newY = this.y + Math.cos(this.headingRadians) * this.velocity * diff;
            newX = this.x + Math.sin(this.headingRadians) * this.velocity * diff;
        }
        return new Point2D.Double(newX, newY);
    }
}

