/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.FastGoto;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.RobotInformation;
import java.util.Random;
import robocode.AdvancedRobot;

public class LingerNavStrategy
extends AdvancedRobotAdapter
implements NavigationStrategy {
    RobotInformation ri = null;
    AdvancedRobot ar = null;
    Coord centrePoint = null;
    Coord targetPoint = null;
    GotoMethod gotoTargetStrat = null;
    double radius = 160.0;
    Random rand = new Random();

    public LingerNavStrategy(RobotInformation info, Coord linger) {
        this.ri = info;
        this.ar = this.ri.getAdvancedRobot();
        this.centrePoint = linger;
        this.targetPoint = linger;
        this.gotoTargetStrat = new FastGoto(this.ri, this.targetPoint);
        this.ri.addListener(this);
    }

    public void discard() {
        this.ri.removeListener(this);
    }

    public boolean isDone() {
        return false;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public Navigation navigate() {
        Navigation navinfo = null;
        Coord currentPos = this.ri.getPosition();
        if (this.gotoTargetStrat.isDone()) {
            this.targetPoint = this.newRandomLocation();
            this.gotoTargetStrat.discard();
            this.gotoTargetStrat = new FastGoto(this.ri, this.targetPoint);
        }
        navinfo = this.gotoTargetStrat.navigate();
        return navinfo;
    }

    Coord newRandomLocation() {
        Compass heading = new Compass(360.0 * this.rand.nextDouble());
        return this.centrePoint.applyVector(heading, this.radius);
    }

    public String toString() {
        return "Linger strategy " + (int)this.radius + " around " + this.centrePoint;
    }
}

