/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

public class RollingAverage {
    private double average;
    private double total;
    private long count;
    private double max;
    private double min;

    public RollingAverage(double firstValue) {
        this.firstValue(firstValue);
    }

    public RollingAverage() {
        this.count = 0L;
        this.total = 0.0;
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
    }

    private void firstValue(double firstValue) {
        this.average = firstValue;
        this.total = firstValue;
        this.max = firstValue;
        this.min = firstValue;
        this.count = 1L;
    }

    public void nextValue(double latest) {
        if (this.count == 0L) {
            this.firstValue(latest);
        } else {
            this.max = Math.max(this.max, latest);
            this.min = Math.min(this.min, latest);
            this.total += latest;
            ++this.count;
            this.average = this.total / (double)this.count;
        }
    }

    public double getAverage() {
        return this.average;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return String.valueOf(this.average);
    }

    public static String testRollingAverage() {
        StringBuffer out = new StringBuffer(300);
        out.append("RollingAverage test rig");
        RollingAverage av = new RollingAverage(6.0);
        av.nextValue(8.0);
        av.nextValue(11.0);
        av.nextValue(13.0);
        av.nextValue(12.0);
        av.nextValue(7.0);
        out.append("Average is 9.5? " + (av.getAverage() == 9.5) + "\n");
        out.append("Max is 13? " + (av.getMax() == 13.0) + "\n");
        out.append("Min is 6? " + (av.getMin() == 6.0) + "\n");
        out.append("Count is 6? " + (av.getCount() == 6L) + "\n");
        out.append("Total is 57? " + (av.getTotal() == 57.0) + "\n");
        return out.toString();
    }

    public static void main(String[] argv) {
        System.out.println(RollingAverage.testRollingAverage());
    }
}

