/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.segmentTree;

import rampancy.util.RRobotState;
import rampancy.util.data.segmentTree.RSTNode;

public class RSegmentTree {
    private RSTNode rootNode;
    private RSTNode[] nodeOrder;
    private int visitsBeforeBranch;

    public RSegmentTree(RSTNode[] order, int visitsBeforeBranch, int numGuessFactorBins) {
        this.visitsBeforeBranch = visitsBeforeBranch;
        this.nodeOrder = order;
        double[] seed = new double[numGuessFactorBins];
        this.rootNode = this.nodeOrder[0].newInstance(seed, 0, this);
        this.rootNode.setBranched();
    }

    public RSTNode getSegmentForState(RRobotState state) {
        return this.rootNode.getSegmentForState(state);
    }

    public RSTNode getTemplateNodeForDepth(int depth) {
        if (depth >= this.nodeOrder.length) {
            return new RSTNode(null, 0);
        }
        return this.nodeOrder[depth];
    }

    public int getVisitsBeforeBranch() {
        return this.visitsBeforeBranch;
    }
}

