/*
 * Decompiled with CFR 0.152.
 */
package whitesquare.robots;

public class Point {
    public double x;
    public double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point plus(Point v) {
        return new Point(this.x + v.x, this.y + v.y);
    }

    public Point minus(Point v) {
        return new Point(this.x - v.x, this.y - v.y);
    }

    public Point mix(Point v, double a) {
        double ia = 1.0 - a;
        return new Point(ia * this.x + a * v.x, ia * this.y + a * v.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double toAngle() {
        return Math.atan2(this.x, this.y);
    }

    public static Point makeVector(double angle) {
        return new Point(Math.sin(angle), Math.cos(angle));
    }

    public static Point makeVector(double angle, double length) {
        return new Point(Math.sin(angle) * length, Math.cos(angle) * length);
    }
}

