/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Pray;
import cbot.cbot.gun.CircularGunStrategy;
import cbot.cbot.gun.DefaultGunStrategy;
import cbot.cbot.gun.GunStrategy;
import cbot.cbot.gun.LinearGunStrategy;
import cbot.cbot.gun.PatternMatcherGunStrategy;
import cbot.cbot.gun.RandomGaussianGunStrategy;
import cbot.cbot.gun.RandomNarrowGunStrategy;
import cbot.cbot.gun.RandomSideGunStrategy;
import cbot.cbot.gun.SectorStatisticGunStrategy;
import cbot.cbot.gun.VirtualBulletHandler;
import java.util.Hashtable;
import java.util.Iterator;

public class Gun {
    private CBot robot;
    public GunStrategy[] strategys;
    private GunStrategy selectedStrategy;
    private GunStrategy defaultStrategy;
    private Hashtable virtualBulletHandler;
    int selectedIndex;
    private GunStrategy linearGunStrategy;
    private GunStrategy circularGunStrategy;
    private GunStrategy patternMatcherGunStrategy;
    private GunStrategy randomGunStrategy;
    private GunStrategy randomNarrowGunStrategy;
    private GunStrategy randomLeftGunStrategy;
    private GunStrategy randomRightGunStrategy;
    private GunStrategy randomGaussianGunStrategy;
    public GunStrategy sectorsStatisticGunStrategy;

    public void update(CBot robot) {
        this.robot = robot;
        int i = 0;
        while (i < this.strategys.length) {
            this.strategys[i].update(robot);
            ++i;
        }
        Iterator itr = this.virtualBulletHandler.values().iterator();
        while (itr.hasNext()) {
            ((VirtualBulletHandler)itr.next()).update(robot, robot);
        }
    }

    public void aimAndFire(Pray pray) {
        this.checkVirtualBullets(pray);
        if (this.robot.getGunHeat() == 0.0) {
            this.selectGunStrategy(pray);
            this.selectedStrategy.aim(pray);
            if (this.selectedStrategy.fire(pray)) {
                ((VirtualBulletHandler)this.virtualBulletHandler.get(pray.getName())).fireVirtualBullets(pray);
                CU.log(this.selectedStrategy.getGunSign());
            }
        }
    }

    public void aim(Pray pray) {
        String name = pray.getName();
        if (this.virtualBulletHandler.get(name) == null) {
            this.virtualBulletHandler.put(name, new VirtualBulletHandler(this.robot, this.robot, this.strategys));
        }
        this.selectGunStrategy(pray);
        this.selectedStrategy.aim(pray);
    }

    private final void checkVirtualBullets(Pray pray) {
        Iterator itr = this.virtualBulletHandler.values().iterator();
        while (itr.hasNext()) {
            ((VirtualBulletHandler)itr.next()).checkBullets();
        }
    }

    public String getHittingRate() {
        String str = "\n . . . HITTINGRATE . . . . . . . . . . . . . . . . . .\n";
        int allHit = 0;
        int allFired = 0;
        int i = 0;
        while (i < this.strategys.length) {
            allHit += this.strategys[i].bulletsHit;
            allFired += this.strategys[i].bulletsFired;
            ++i;
        }
        String allRate = CU.formatNumber(100.0 * ((double)allHit / (double)allFired));
        GunStrategy cfr_ignored_0 = this.strategys[0];
        GunStrategy cfr_ignored_1 = this.strategys[0];
        str = str + "  [TOT] [" + GunStrategy.totHit + '/' + GunStrategy.totFired + "] " + this.strategys[0].getGunHittingRate() + "% [" + allHit + '/' + allFired + "] " + allRate + "%\n";
        int i2 = 0;
        while (i2 < this.strategys.length) {
            this.strategys[i2].updateStatistics();
            str = str + "    [" + this.strategys[i2].getGunSign() + "] [" + this.strategys[i2].allBulletsHit + '/' + this.strategys[i2].allBulletsFired + "] " + this.strategys[i2].getTotHittingRate() + "% [" + this.strategys[i2].bulletsHit + '/' + this.strategys[i2].bulletsFired + "] " + this.strategys[i2].getHittingRate() + "%\n";
            ++i2;
        }
        Iterator itr = this.virtualBulletHandler.values().iterator();
        while (itr.hasNext()) {
            str = str + ((VirtualBulletHandler)itr.next()).getStatistics() + '\n';
        }
        str = str + ((SectorStatisticGunStrategy)this.sectorsStatisticGunStrategy).getStatistics();
        return str;
    }

    public double[] getDistanceHittingRates() {
        return GunStrategy.getDistanceHittingRates();
    }

    private final void selectGunStrategy(Pray pray) {
        int[] sortedIndexes = ((VirtualBulletHandler)this.virtualBulletHandler.get(pray.getName())).getSortedIndexes(pray);
        this.selectedIndex = sortedIndexes[0];
        this.selectedStrategy = this.strategys[this.selectedIndex];
    }

    public Gun(CBot robot) {
        this.robot = robot;
        this.defaultStrategy = new DefaultGunStrategy(robot);
        this.linearGunStrategy = new LinearGunStrategy(robot);
        this.circularGunStrategy = new CircularGunStrategy(robot);
        this.patternMatcherGunStrategy = new PatternMatcherGunStrategy(robot);
        this.randomNarrowGunStrategy = new RandomNarrowGunStrategy(robot);
        this.randomLeftGunStrategy = new RandomSideGunStrategy(robot, -1);
        this.randomRightGunStrategy = new RandomSideGunStrategy(robot, 1);
        this.randomGaussianGunStrategy = new RandomGaussianGunStrategy(robot);
        this.sectorsStatisticGunStrategy = new SectorStatisticGunStrategy(robot);
        int NUM_OF_GUNS = 9;
        this.strategys = new GunStrategy[NUM_OF_GUNS];
        this.strategys[0] = this.defaultStrategy;
        this.strategys[1] = this.linearGunStrategy;
        this.strategys[2] = this.defaultStrategy;
        this.strategys[3] = this.randomNarrowGunStrategy;
        this.strategys[4] = this.randomLeftGunStrategy;
        this.strategys[5] = this.randomRightGunStrategy;
        this.strategys[6] = this.randomGaussianGunStrategy;
        this.strategys[7] = this.patternMatcherGunStrategy;
        this.strategys[8] = this.sectorsStatisticGunStrategy;
        this.selectedStrategy = this.strategys[0];
        this.virtualBulletHandler = new Hashtable(robot.getOthers());
    }
}

