/*
 * Decompiled with CFR 0.152.
 */
package matt;

import java.awt.geom.Point2D;

public class Utils {
    public static double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static boolean strContains(String base, String target) {
        base = base.toUpperCase();
        target = target.toUpperCase();
        for (int l = 0; l < base.length(); ++l) {
            if (target.length() > base.length() - l) {
                return false;
            }
            if (!base.substring(l, l + 1).equalsIgnoreCase(target.substring(0, 1))) continue;
            int s = 0;
            boolean ok = true;
            while (ok) {
                if (s >= target.length()) {
                    return true;
                }
                if (!base.substring(l + s, l + s + 1).equalsIgnoreCase(target.substring(s, s + 1))) {
                    ok = false;
                }
                ++s;
            }
        }
        return false;
    }
}

