/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Enemy;
import et.EtMath;
import et.Location;
import et.Navigator;
import et.Predator;
import java.io.PrintStream;
import robocode.HitRobotEvent;

public abstract class Driver {
    protected static double stra = 0.0;
    protected static double rl = 0.0;
    protected static double mo = 0.0;
    protected static double ar = 0.0;
    protected static double hitRobot = 0.0;
    protected static double hitRobot2 = 0.0;
    protected static double ramRobot = 0.0;
    protected static double gear = 0.0;
    protected static double cha = 0.0;
    protected static double sem = 0.0;
    protected static double rm = 0.0;
    protected static long hitWall = 0L;
    protected double vd = 0.0;
    protected static Predator thePredator;
    protected static Navigator theNavigator;
    protected long lastSlowo = 0L;
    protected long lastReverse = 0L;
    Location dest = new Location(0.0, 0.0);

    public Driver(Predator predator) {
        theNavigator = new Navigator(predator);
        thePredator = predator;
    }

    public void printStats(PrintStream printStream) {
        printStream.println("Hit robots " + (int)hitRobot + " times (" + EtMath.percent(ramRobot / hitRobot) + " was on purpose). ");
        printStream.print("Hit walls " + hitWall + " times.  ");
    }

    public void reset() {
        this.lastReverse = -100L;
        theNavigator.reset();
        this.vd = 0.0;
    }

    public final void setAhead(double d) {
        thePredator.setAhead(d * Driver.thePredator.direction);
    }

    public final void reverse() {
        Driver.thePredator.direction *= -1.0;
        this.lastReverse = thePredator.getTime();
    }

    public final void setTurnRight(double d) {
        thePredator.setTurnRight(EtMath.normalRelativeAngle(d));
    }

    public final void setTurnRight(double d, boolean bl) {
        d = EtMath.normalRelativeAngle(d);
        if (bl && Math.abs(d) > 90.0) {
            d = (double)(EtMath.sign(d) * 180L) - d;
            d *= -1.0;
            this.reverse();
        }
        this.setTurnRight(d);
    }

    protected final void setTurnTo(double d, boolean bl) {
        double d2 = thePredator.getHeading();
        if (Driver.thePredator.direction == -1.0) {
            d2 = EtMath.normalAbsoluteAngle(d2 + 180.0);
        }
        this.setTurnRight(d - d2, bl);
    }

    protected final void setTurnTo(double d, double d2, boolean bl) {
        double d3 = thePredator.getAngleToLocation(d, d2);
        this.setTurnRight(d3, bl);
    }

    protected final void setTurnTo(Location location, boolean bl) {
        this.setTurnRight(thePredator.getAngleToLocation(location), bl);
    }

    public void move() {
        this.move(true);
    }

    public abstract void move(boolean var1);

    public final void handleHitWall() {
        if (thePredator.getOthers() > 0) {
            ++hitWall;
        }
        this.move();
        thePredator.fireOrExecute(false);
    }

    public void handleHitRobot(HitRobotEvent hitRobotEvent) {
        hitRobot += 1.0;
        double d = Driver.thePredator.direction;
        if (Predator.theEnemyMap.get(hitRobotEvent.getName()).isRammable()) {
            ramRobot += 1.0;
            this.move(false);
        } else {
            if (hitRobotEvent.isMyFault()) {
                this.reverse();
            }
            this.setTurnTo(theNavigator.getDestination(40.0, false), false);
        }
        this.setAhead(100.0);
        thePredator.fireOrExecute(Driver.thePredator.direction == d);
    }

    protected boolean onCollisionCourse(Enemy enemy) {
        if (enemy == null || enemy.isRammable() || enemy.ramIt) {
            return false;
        }
        double d = enemy.getDistance();
        double d2 = EtMath.normalAbsoluteAngle(thePredator.getHeading(true) - enemy.getHeading(true));
        double d3 = Math.min(90.0, 130.0 - d);
        return d < 130.0 && (d2 < d3 || d2 > 360.0 - d3);
    }

    public void victoryDance(Location location) {
        if (thePredator.getPosition().distance(location) > 4.0) {
            this.setTurnTo(location, true);
            this.setAhead(thePredator.getPosition().distance(location));
        } else {
            this.setTurnRight(this.vd / 50.0);
        }
        this.vd += 1.0;
        thePredator.execute();
    }
}

