/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.EtMath;
import et.Location;

class Tensor
extends Location {
    private double heading;
    private double velocity;

    public Tensor(double d, double d2, double d3, double d4) {
        super(d, d2);
        this.heading = d3;
        this.velocity = d4;
    }

    public Tensor(Location location, double d, double d2) {
        this(location.getX(), location.getY(), d, d2);
    }

    public Tensor() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public double getHeading() {
        return this.getHeading(false);
    }

    public double getHeading(boolean bl) {
        if (bl && this.getVelocity() < 0.0) {
            return EtMath.normalAbsoluteAngle(this.heading + 180.0);
        }
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setTensor(Tensor tensor) {
        this.setLocation(tensor.getX(), tensor.getY());
        this.velocity = tensor.getVelocity();
        this.heading = tensor.getHeading();
    }
}

