/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector.sparse;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.VectorIterator;
import org.la4j.vector.SparseVector;
import org.la4j.vector.VectorFactory;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorProcedure;

public class CompressedVector
extends SparseVector {
    private static final byte VECTOR_TAG = 16;
    private static final int MINIMUM_SIZE = 32;
    private double[] values;
    private int[] indices;

    public static CompressedVector zero(int length) {
        return new CompressedVector(length);
    }

    public static CompressedVector zero(int length, int capacity) {
        return new CompressedVector(length, capacity);
    }

    public static CompressedVector random(int length, double density, Random random) {
        if (density < 0.0 || density > 1.0) {
            throw new IllegalArgumentException("The density value should be between 0 and 1.0");
        }
        int cardinality = (int)((double)length * density);
        double[] values2 = new double[cardinality];
        int[] indices = new int[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            values2[i] = random.nextDouble();
            indices[i] = random.nextInt(length);
        }
        Arrays.sort(indices);
        return new CompressedVector(length, cardinality, values2, indices);
    }

    public static CompressedVector fromArray(double[] array) {
        int length = array.length;
        CompressedVector result = CompressedVector.zero(length);
        for (int i = 0; i < length; ++i) {
            if (array[i] == 0.0) continue;
            result.set(i, array[i]);
        }
        return result;
    }

    public static CompressedVector fromBinary(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 16) {
            throw new IllegalArgumentException("Can not decode CompressedVector from the given byte array.");
        }
        int length = buffer.getInt();
        int cardinality = buffer.getInt();
        double[] values2 = new double[cardinality];
        int[] indices = new int[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            indices[i] = buffer.getInt();
            values2[i] = buffer.getDouble();
        }
        return new CompressedVector(length, cardinality, values2, indices);
    }

    public static CompressedVector fromCSV(String csv) {
        return Vector.fromCSV(csv).to(Vectors.COMPRESSED);
    }

    public static CompressedVector fromMatrixMarket(String mm) {
        return Vector.fromMatrixMarket(mm).to(Vectors.COMPRESSED);
    }

    public static CompressedVector fromCollection(Collection<? extends Number> list) {
        return Vector.fromCollection(list).to(Vectors.COMPRESSED);
    }

    public static CompressedVector fromMap(Map<Integer, ? extends Number> map, int length) {
        int cardinality = map.size();
        int[] indices = new int[cardinality];
        double[] values2 = new double[cardinality];
        int i = 0;
        for (Map.Entry<Integer, ? extends Number> entry : map.entrySet()) {
            int index = entry.getKey();
            if (index < 0 || index >= length) {
                throw new IllegalArgumentException("Check your map: Index must be 0..n-1");
            }
            indices[i] = index;
            values2[i] = entry.getValue().doubleValue();
            ++i;
        }
        return new CompressedVector(length, cardinality, values2, indices);
    }

    public CompressedVector() {
        this(0);
    }

    public CompressedVector(int length) {
        this(length, 0);
    }

    public CompressedVector(int length, int capacity) {
        super(length);
        int alignedSize = this.align(length, capacity);
        this.values = new double[alignedSize];
        this.indices = new int[alignedSize];
    }

    public CompressedVector(int length, int cardinality, double[] values2, int[] indices) {
        super(length, cardinality);
        this.values = values2;
        this.indices = indices;
    }

    @Override
    public double getOrElse(int i, double defaultValue) {
        this.ensureIndexIsInBounds(i);
        int k = this.searchForIndex(i);
        if (k < this.cardinality && this.indices[k] == i) {
            return this.values[k];
        }
        return defaultValue;
    }

    @Override
    public void set(int i, double value) {
        this.ensureIndexIsInBounds(i);
        int k = this.searchForIndex(i);
        if (k < this.cardinality && this.indices[k] == i) {
            if (value != 0.0) {
                this.values[k] = value;
            } else {
                this.remove(k);
            }
        } else {
            this.insert(k, i, value);
        }
    }

    @Override
    public void setAll(double value) {
        if (value == 0.0) {
            this.cardinality = 0;
        } else {
            if (this.values.length < this.length) {
                this.values = new double[this.length];
                this.indices = new int[this.length];
            }
            for (int i = 0; i < this.length; ++i) {
                this.indices[i] = i;
                this.values[i] = value;
            }
            this.cardinality = this.length;
        }
    }

    @Override
    public void swapElements(int i, int j) {
        boolean jjNotZero;
        if (i == j) {
            return;
        }
        int ii = this.searchForIndex(i);
        int jj = this.searchForIndex(j);
        boolean iiNotZero = ii < this.cardinality && i == this.indices[ii];
        boolean bl = jjNotZero = jj < this.cardinality && j == this.indices[jj];
        if (iiNotZero && jjNotZero) {
            double sd = this.values[ii];
            this.values[ii] = this.values[jj];
            this.values[jj] = sd;
        } else {
            int rightIndex;
            double notZero = this.values[iiNotZero ? ii : jj];
            int leftIndex = ii < jj ? ii : jj;
            int n = rightIndex = ii > jj ? ii : jj;
            if ((iiNotZero && leftIndex == ii || jjNotZero && leftIndex == jj) && ii != jj) {
                System.arraycopy(this.values, leftIndex + 1, this.values, leftIndex, this.cardinality - leftIndex);
                System.arraycopy(this.values, rightIndex - 1, this.values, rightIndex, this.cardinality - rightIndex);
                this.values[rightIndex - 1] = notZero;
                System.arraycopy(this.indices, leftIndex + 1, this.indices, leftIndex, this.cardinality - leftIndex);
                System.arraycopy(this.indices, rightIndex - 1, this.indices, rightIndex, this.cardinality - rightIndex);
                this.indices[rightIndex - 1] = jjNotZero ? i : j;
            } else if (iiNotZero && rightIndex == ii || jjNotZero && rightIndex == jj) {
                System.arraycopy(this.values, rightIndex + 1, this.values, rightIndex, this.cardinality - rightIndex);
                System.arraycopy(this.values, leftIndex, this.values, leftIndex + 1, this.cardinality - leftIndex);
                this.values[leftIndex] = notZero;
                System.arraycopy(this.indices, rightIndex + 1, this.indices, rightIndex, this.cardinality - rightIndex);
                System.arraycopy(this.indices, leftIndex, this.indices, leftIndex + 1, this.cardinality - leftIndex);
                this.indices[leftIndex] = jjNotZero ? i : j;
            }
        }
    }

    @Override
    public Vector copyOfLength(int length) {
        this.ensureLengthIsCorrect(length);
        int $cardinality = length >= this.length ? this.cardinality : this.searchForIndex(length);
        int capacity = this.align(length, $cardinality);
        double[] $values = new double[capacity];
        int[] $indices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, $cardinality);
        System.arraycopy(this.indices, 0, $indices, 0, $cardinality);
        return new CompressedVector(length, $cardinality, $values, $indices);
    }

    @Override
    public void each(VectorProcedure procedure) {
        int k = 0;
        for (int i = 0; i < this.length; ++i) {
            if (k < this.cardinality && this.indices[k] == i) {
                procedure.apply(i, this.values[k++]);
                continue;
            }
            procedure.apply(i, 0.0);
        }
    }

    @Override
    public void eachNonZero(VectorProcedure procedure) {
        for (int i = 0; i < this.cardinality; ++i) {
            procedure.apply(this.indices[i], this.values[i]);
        }
    }

    @Override
    public void updateAt(int i, VectorFunction function) {
        int k = this.searchForIndex(i);
        if (k < this.cardinality && this.indices[k] == i) {
            double value = function.evaluate(i, this.values[k]);
            if (value != 0.0) {
                this.values[k] = value;
            } else {
                this.remove(k);
            }
        } else {
            this.insert(k, i, function.evaluate(i, 0.0));
        }
    }

    @Override
    public boolean nonZeroAt(int i) {
        int k = this.searchForIndex(i);
        return k < this.cardinality && this.indices[k] == i;
    }

    @Override
    public <T extends Vector> T to(VectorFactory<T> factory) {
        if (factory.outputClass == CompressedVector.class) {
            return (T)((Vector)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Vector blankOfLength(int length) {
        return CompressedVector.zero(length);
    }

    @Override
    public byte[] toBinary() {
        int size = 9 + 8 * this.cardinality + 8 * this.cardinality;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)16);
        buffer.putInt(this.length);
        buffer.putInt(this.cardinality);
        for (int i = 0; i < this.cardinality; ++i) {
            buffer.putInt(this.indices[i]);
            buffer.putDouble(this.values[i]);
        }
        return buffer.array();
    }

    private int searchForIndex(int i) {
        if (this.cardinality == 0 || i > this.indices[this.cardinality - 1]) {
            return this.cardinality;
        }
        int left = 0;
        int right = this.cardinality;
        while (left < right) {
            int p = (left + right) / 2;
            if (this.indices[p] > i) {
                right = p;
                continue;
            }
            if (this.indices[p] < i) {
                left = p + 1;
                continue;
            }
            return p;
        }
        return left;
    }

    private void insert(int k, int i, double value) {
        if (value == 0.0) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growUp();
        }
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
            System.arraycopy(this.indices, k, this.indices, k + 1, this.cardinality - k);
        }
        this.values[k] = value;
        this.indices[k] = i;
        ++this.cardinality;
    }

    private void remove(int k) {
        --this.cardinality;
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
            System.arraycopy(this.indices, k + 1, this.indices, k, this.cardinality - k);
        }
    }

    private void growUp() {
        if (this.values.length == this.length) {
            throw new IllegalStateException("This vector can't grow up.");
        }
        int capacity = Math.min(this.length, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $indices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.indices, 0, $indices, 0, this.cardinality);
        this.values = $values;
        this.indices = $indices;
    }

    private int align(int length, int capacity) {
        if (capacity < 0) {
            this.fail("Cardinality should be positive: " + capacity + ".");
        }
        if (capacity > length) {
            this.fail("Cardinality should be less then or equal to capacity: " + capacity + ".");
        }
        return Math.min(length, (capacity / 32 + 1) * 32);
    }

    @Override
    public VectorIterator nonZeroIterator() {
        return new VectorIterator(this.length){
            private boolean currentIsRemoved;
            private int k;
            private int removedIndex;
            {
                this.currentIsRemoved = false;
                this.k = -1;
                this.removedIndex = -1;
            }

            @Override
            public int index() {
                return this.currentIsRemoved ? this.removedIndex : CompressedVector.this.indices[this.k];
            }

            @Override
            public double get() {
                return this.currentIsRemoved ? 0.0 : CompressedVector.this.values[this.k];
            }

            @Override
            public void set(double value) {
                if (value == 0.0 && !this.currentIsRemoved) {
                    this.currentIsRemoved = true;
                    this.removedIndex = CompressedVector.this.indices[this.k];
                    CompressedVector.this.remove(this.k--);
                } else if (value != 0.0 && !this.currentIsRemoved) {
                    ((CompressedVector)CompressedVector.this).values[this.k] = value;
                } else {
                    this.currentIsRemoved = false;
                    CompressedVector.this.insert(++this.k, this.removedIndex, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.k + 1 < CompressedVector.this.cardinality;
            }

            @Override
            public Double next() {
                this.currentIsRemoved = false;
                return CompressedVector.this.values[++this.k];
            }
        };
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIterator(this.length){
            private int k;
            private int i;
            private boolean currentNonZero;
            {
                this.k = 0;
                this.i = -1;
                this.currentNonZero = false;
            }

            @Override
            public int index() {
                return this.i;
            }

            @Override
            public double get() {
                return this.currentNonZero ? CompressedVector.this.values[this.k] : 0.0;
            }

            @Override
            public void set(double value) {
                if (this.currentNonZero) {
                    if (value == 0.0) {
                        CompressedVector.this.remove(this.k);
                        this.currentNonZero = false;
                    } else {
                        ((CompressedVector)CompressedVector.this).values[this.k] = value;
                    }
                } else {
                    CompressedVector.this.insert(this.k, this.i, value);
                    this.currentNonZero = true;
                }
            }

            @Override
            public boolean hasNext() {
                return this.i + 1 < this.length;
            }

            @Override
            public Double next() {
                if (this.currentNonZero) {
                    ++this.k;
                }
                ++this.i;
                this.currentNonZero = this.k < CompressedVector.this.cardinality && CompressedVector.this.indices[this.k] == this.i;
                return this.get();
            }
        };
    }
}

