/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import pulsar.util.RobotData;

public abstract class Segmentation {
    public static final int LOW_SEGMENTATION = 0;
    public static final int MEDIUM_SEGMENTATION = 1;
    public static final int HIGH_SEGMENTATION = 2;
    protected double[] limits = new double[0];

    public int getIndex(RobotData firedFrom, RobotData firedAt) {
        return this.getIndex(firedFrom, firedAt, 0);
    }

    public int getIndex(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        return this.getIndex(this.getValue(firedFrom, firedAt, stepsBack));
    }

    protected abstract double getValue(RobotData var1, RobotData var2, int var3);

    public String getName() {
        String className = this.getClass().getName();
        int begin = className.lastIndexOf(46) + 1;
        int end = className.lastIndexOf("Segmentation");
        return className.substring(begin, end);
    }

    public String toString() {
        return this.getName();
    }

    public int getNoSegments() {
        return this.limits.length + 1;
    }

    protected void setLimits(double[] limits) {
        this.limits = limits;
    }

    protected int getIndex(double value) {
        return Segmentation.getIndex(this.limits, value);
    }

    protected static int getIndex(double[] limits, double value) {
        int i = 0;
        while (i < limits.length) {
            if (value < limits[i]) {
                return i;
            }
            ++i;
        }
        return limits.length;
    }
}

