/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.BattleField;
import dk.Enemy;
import dk.Point;
import dk.Util;

public class Factors {
    protected Enemy target;
    protected Point position;
    protected double heading;
    protected double distance;
    protected double velocity;
    protected double acceleration;
    protected double headingChange;
    protected double averageHeading;
    protected double averageVelocity;
    protected double averageAcceleration;
    protected double averageHeadingChange;
    protected double bulletPower;
    protected boolean melee;
    protected Point robotPosition;
    protected double robotHeading;
    protected long timeSinceLastDirectionChange;
    protected long timeSinceFire;
    protected long timeSinceHit;

    public Factors(Base r, Enemy e, double power) {
        long now = r.getTime();
        this.melee = r.getOthers() > 1;
        this.bulletPower = power;
        this.target = e;
        this.position = e.getEstimatedPosition(now);
        this.heading = e.getHeading();
        this.distance = Util.range(r.getPosition(), this.position);
        this.velocity = e.getVelocity();
        this.acceleration = e.getAcceleration();
        this.headingChange = e.getHeadingChange();
        this.timeSinceLastDirectionChange = now - e.getLastDirectionChange();
        this.timeSinceFire = now - e.getLastFired();
        this.timeSinceHit = now - e.getLastHit();
        this.averageAcceleration = e.getAverageAcceleration();
        this.averageHeading = e.getAverageHeading();
        this.averageHeadingChange = e.getAverageHeadingChange();
        this.averageVelocity = e.getAverageVelocity();
        this.robotHeading = r.getHeadingRadians();
        this.robotPosition = r.getPosition();
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getHeadingChange() {
        return this.headingChange;
    }

    public boolean isMelee() {
        return this.melee;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public Enemy getTarget() {
        return this.target;
    }

    public String getName() {
        return this.target.getName();
    }

    public double getHeading() {
        return this.heading;
    }

    public Point getPosition() {
        return this.position;
    }

    public double getDistanceFromWall() {
        return BattleField.getDistanceFromWall(this.position);
    }

    public long getTimeSinceLastDirectionChange() {
        return this.timeSinceLastDirectionChange;
    }

    public double getAverageAcceleration() {
        return this.averageAcceleration;
    }

    public double getAverageHeading() {
        return this.averageHeading;
    }

    public double getAverageHeadingChange() {
        return this.averageHeadingChange;
    }

    public double getAverageVelocity() {
        return this.averageVelocity;
    }

    public double getBulletPower() {
        return this.bulletPower;
    }

    public double getBulletVelocity() {
        return Util.bulletVelocity(this.bulletPower);
    }

    public double getRobotHeading() {
        return this.robotHeading;
    }

    public Point getRobotPosition() {
        return this.robotPosition;
    }

    public long getTimeSinceFire() {
        return this.timeSinceFire;
    }

    public long getTimeSinceHit() {
        return this.timeSinceHit;
    }
}

