/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.Point;
import dk.Util;
import dk.predict.Factors;
import dk.predict.Tracer;

public abstract class Predictor {
    protected Enemy enemy_;

    public Predictor(Enemy enemy) {
        this.enemy_ = enemy;
    }

    public abstract Point getEstimatedPosition(Base var1, long var2);

    public abstract Point getEstimatedPosition(Base var1, Tracer var2, long var3);

    public abstract void tracerDidHit(Base var1, Tracer var2, Histogram var3);

    public double getGunTurnAngleToEnemy(Base robot, double power) {
        return this.getGunTurnAngleToEnemy(robot, power, 5);
    }

    public double getGunTurnAngleToEnemy(Base robot, double power, int iterations) {
        Point enemyEstimatedPosition = this.getEstimatedPosition(robot, robot.getTime());
        double estimatedDistance = Util.range(robot.getPosition(), enemyEstimatedPosition);
        int bulletTravelTime = Util.bulletTravelTime(estimatedDistance, power);
        enemyEstimatedPosition = this.enemy_.getEstimatedPosition(robot.getTime() + (long)bulletTravelTime);
        double enemyBearing = Util.bearing(robot.getPosition(), enemyEstimatedPosition);
        double angle = Math.abs(Util.normalizeBearing(enemyBearing - robot.getGunHeadingRadians()));
        int timeToTurn = (int)(angle / Base.RATE_GUN_TURN);
        int timeToCool = (int)(robot.getGunHeat() / robot.getGunCoolingRate());
        int timeToFire = Math.max(timeToTurn, timeToCool);
        long fireTime = robot.getTime() + (long)timeToFire;
        Point estimatedPosition = robot.getEstimatedPosition(fireTime);
        int iter = 0;
        while (iter < iterations) {
            long hitTime = fireTime + (long)bulletTravelTime;
            enemyEstimatedPosition = Util.clamp(this.getEstimatedPosition(robot, hitTime));
            enemyBearing = Util.bearing(estimatedPosition, enemyEstimatedPosition);
            angle = Util.normalizeBearing(enemyBearing - robot.getGunHeadingRadians());
            timeToTurn = (int)(angle / Base.RATE_GUN_TURN);
            timeToFire = Math.max(timeToTurn, timeToCool);
            fireTime = robot.getTime() + (long)timeToFire;
            long newHitTime = fireTime + (long)(bulletTravelTime = Util.bulletTravelTime(estimatedDistance = Util.range(estimatedPosition = robot.getEstimatedPosition(fireTime), enemyEstimatedPosition), power));
            if (newHitTime == hitTime) break;
            hitTime = newHitTime;
            ++iter;
        }
        return Util.normalizeBearing(angle);
    }

    public double getPredictedAngleForTracer(Base robot, Tracer t) {
        return this.getPredictedAngleForTracer(robot, t, 5);
    }

    public double getPredictedAngleForTracer(Base robot, Tracer t, int iterations) {
        Factors f = t.getFactors();
        Point enemyEstimatedPosition = f.getPosition();
        Point estimatedPosition = t.getRobotStartPosition();
        double estimatedDistance = Util.range(estimatedPosition, enemyEstimatedPosition);
        int bulletTravelTime = Util.bulletTravelTime(estimatedDistance, t.getPower());
        int iter = 0;
        double enemyBearing = 0.0;
        while (iter < iterations) {
            long hitTime = t.getStart() + (long)bulletTravelTime;
            enemyEstimatedPosition = Util.clamp(this.getEstimatedPosition(robot, t, hitTime));
            enemyBearing = Util.bearing(estimatedPosition, enemyEstimatedPosition);
            estimatedDistance = Util.range(estimatedPosition, enemyEstimatedPosition);
            int newBulletTravelTime = Util.bulletTravelTime(estimatedDistance, t.getPower());
            if (newBulletTravelTime == bulletTravelTime) break;
            bulletTravelTime = newBulletTravelTime;
            ++iter;
        }
        return Util.normalizeHeading(enemyBearing);
    }

    public interface Factory {
        public Predictor newInstance(Enemy var1);
    }
}

