/*
 * Decompiled with CFR 0.152.
 */
package dk.scan;

import dk.Base;
import dk.Enemy;
import dk.Point;
import dk.Util;
import dk.scan.Scanner;
import java.util.Iterator;

public class OptimalSweep
extends Scanner {
    protected static final int SCAN_ALL = 0;
    protected static final int SCAN_LEFT = 1;
    protected static final int SCAN_RIGHT = 2;
    protected static final int SCAN_WAIT = 3;
    protected int scanMode = 0;
    protected double leftAngle = 0.0;
    protected double rightAngle = 0.0;

    public void setScan(Base robot) {
        if (this.scanMode == 3 && robot.getRadarTurnRemainingRadians() == 0.0) {
            this.computeScanRangeAndDirection(robot);
        }
        double currentAngle = robot.getRadarHeadingRadians();
        switch (this.scanMode) {
            case 0: {
                robot.setTurnRadarRightRadians(Math.PI * 2);
                this.scanMode = 3;
                break;
            }
            case 1: {
                double amount = Util.normalizeHeading(currentAngle - this.leftAngle);
                robot.setTurnRadarLeftRadians(amount);
                this.scanMode = 3;
                break;
            }
            case 2: {
                double amount = Util.normalizeHeading(this.rightAngle - currentAngle);
                robot.setTurnRadarRightRadians(amount);
                this.scanMode = 3;
            }
        }
    }

    public void computeScanRangeAndDirection(Base robot) {
        double dl;
        Point robotPosition = robot.getPosition();
        double currentAngle = robot.getRadarHeadingRadians();
        long now = robot.getTime();
        boolean rangeSet = false;
        Iterator iter = robot.getEnemyController().getEnemies().iterator();
        while (iter.hasNext()) {
            double dl2;
            Point position;
            Enemy e = (Enemy)iter.next();
            if (!e.isAlive() || (position = e.getEstimatedPosition(now)) == null) continue;
            double bearing = Util.bearing(robotPosition, position);
            if (!rangeSet) {
                this.leftAngle = bearing;
                this.rightAngle = bearing;
                rangeSet = true;
                continue;
            }
            if (bearing >= this.leftAngle && bearing <= this.rightAngle) continue;
            double dr = Util.normalizeBearing(bearing - this.rightAngle);
            if (dr > (dl2 = Util.normalizeBearing(this.leftAngle - bearing))) {
                this.rightAngle = bearing;
                continue;
            }
            this.leftAngle = bearing;
        }
        this.leftAngle = Util.normalizeHeading(this.leftAngle - robot.config.SCAN_OPTIMAL_OVERSCAN);
        this.rightAngle = Util.normalizeHeading(this.rightAngle + robot.config.SCAN_OPTIMAL_OVERSCAN);
        double dr = Util.normalizeBearing(this.rightAngle - currentAngle);
        this.scanMode = dr > (dl = Util.normalizeBearing(currentAngle - this.leftAngle)) ? 2 : 1;
    }
}

