/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.DynamicMovementSequence;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategyUsingEnemySimulator;
import dmh.robocode.gunner.simulator.MovementSequenceReplayEnemySimulator;
import dmh.robocode.robot.CommandBasedRobot;
import java.awt.Color;

public class AimByMovementSequenceReplay
extends CalibratedAimingStrategyUsingEnemySimulator {
    boolean isLearningAllowed;

    public AimByMovementSequenceReplay(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
        this.isLearningAllowed = isLearningAllowed;
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        if (this.isLearningAllowed) {
            return this.getDefaultEstimatedSuccess(bulletSpeed);
        }
        return 0.0;
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        if (!this.isLearningAllowed) {
            return null;
        }
        DynamicMovementSequence currentMovements = this.getEnemy().getCurrentMovementSequence();
        if (currentMovements.areUpToDate(this.getMyRobot().getTime())) {
            MovementSequenceReplayEnemySimulator simulator = new MovementSequenceReplayEnemySimulator(this.getEnemy());
            return this.getSimulatorIntercept(simulator, bulletSpeed);
        }
        return null;
    }
}

