/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.simulate;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;

public class RobotMovementSimulator
implements SimulateableRobot {
    private Location location;
    private double heading;
    private double velocity;
    private long time;

    public RobotMovementSimulator(Location location, double heading, double velocity, long time) {
        this.location = location;
        this.heading = heading;
        this.velocity = velocity;
        this.time = time;
    }

    public void takeTurn(double rightTurn, double ahead, double maxVelocity) {
        double maxAllowedTurn = 10.0 - 0.75 * Math.abs(this.velocity);
        if (Math.abs(rightTurn) > maxAllowedTurn) {
            rightTurn = Math.signum(rightTurn) * maxAllowedTurn;
        }
        this.heading += rightTurn;
        double acceleration = 0.0;
        boolean gettingFaster = false;
        if (ahead > 0.0) {
            if (this.velocity > 0.0) {
                if (ahead > this.velocity) {
                    acceleration = Math.min(1.0, ahead - this.velocity);
                    gettingFaster = true;
                } else {
                    acceleration = Math.max(-2.0, maxVelocity - this.velocity);
                }
            } else {
                acceleration = Math.min(2.0, -this.velocity);
                acceleration += (2.0 - acceleration) / 2.0;
            }
        } else if (this.velocity > 0.0) {
            acceleration = Math.max(-2.0, -this.velocity);
            acceleration -= (acceleration + 2.0) / 2.0;
        } else if (ahead > this.velocity) {
            acceleration = Math.max(2.0, maxVelocity - this.velocity);
        } else if (maxVelocity > this.velocity) {
            acceleration = Math.min(2.0, maxVelocity - this.velocity);
        } else {
            acceleration = Math.max(-1.0, ahead - this.velocity);
            gettingFaster = true;
        }
        this.velocity += acceleration;
        if (gettingFaster) {
            if (maxVelocity > 0.0 && this.velocity > Math.min(maxVelocity, 8.0)) {
                this.velocity = Math.min(maxVelocity, 8.0);
            } else if (maxVelocity < 0.0 && this.velocity < Math.max(maxVelocity, -8.0)) {
                this.velocity = Math.max(maxVelocity, -8.0);
            }
        }
        this.location = Geometry.getLocationAtBearing(this.location, this.heading, this.velocity);
        ++this.time;
        this.preventGoingOffEdge();
    }

    private void preventGoingOffEdge() {
        double xGap = BattleConstants.getInstance().getRobotWidth() / 2.0;
        double yGap = BattleConstants.getInstance().getRobotHeight() / 2.0;
        this.location.chopNearEdgesOfBattlefield(xGap, yGap);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public double getHeading() {
        return this.heading;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }
}

