/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import rampancy.RTargetingManager;
import rampancy.util.REnemyRobot;
import rampancy.util.wave.RBulletWave;
import rampancy.util.weapon.RDisabledEnemyGun;
import rampancy.util.weapon.RFiringSolution;
import rampancy.util.weapon.RGun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDefaultTargetingManager
implements RTargetingManager {
    private RDisabledEnemyGun disabledEnemyGun = new RDisabledEnemyGun();
    private ArrayList<RGun> guns = new ArrayList();
    private ArrayList<RFiringSolution> examinedSolutions;

    public RDefaultTargetingManager(RGun[] guns) {
        int i = 0;
        while (i < guns.length) {
            this.guns.add(guns[i]);
            ++i;
        }
    }

    @Override
    public List<RFiringSolution> getBestFiringSolutions(REnemyRobot enemy) {
        ArrayList<RFiringSolution> firingSolutions = new ArrayList<RFiringSolution>();
        if (enemy.getCurrentState().energy == 0.0) {
            firingSolutions.add(this.disabledEnemyGun.getFiringSolution(enemy));
        } else {
            for (RGun gun : this.guns) {
                RFiringSolution fs = gun.getFiringSolution(enemy);
                if (fs == null) continue;
                firingSolutions.add(fs);
            }
            if (firingSolutions.isEmpty()) {
                return firingSolutions;
            }
            RFiringSolution bestSolution = firingSolutions.get(0);
            double bestHitPercent = 0.0;
            for (RFiringSolution solution : firingSolutions) {
                double percent = solution.gun.getStats().getWeightedHitPercent();
                if (!(percent > bestHitPercent)) continue;
                bestHitPercent = percent;
                bestSolution = solution;
            }
            firingSolutions.remove(bestSolution);
            firingSolutions.add(0, bestSolution);
        }
        return firingSolutions;
    }

    @Override
    public void draw(Graphics2D g) {
    }

    @Override
    public void updateGuns(RBulletWave wave) {
        for (RGun gun : this.guns) {
            if (!gun.getName().equals(wave.getFiringSolution().gun.getName())) continue;
            gun.update(wave);
        }
    }

    @Override
    public void updateNewRound() {
        System.out.println("Gun Stats\n************");
        for (RGun gun : this.guns) {
            System.out.println(gun.toString());
        }
        System.out.println();
        for (RGun gun : this.guns) {
            gun.updateNewRound();
        }
    }

    public String getGunStatistics() {
        String str = "Targeting manager statistics:\n****************\n";
        for (RGun gun : this.guns) {
            str = String.valueOf(str) + gun.getOverview() + "\n";
        }
        return String.valueOf(str) + "\n";
    }
}

