/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import synapse.Enemy;
import synapse.Module;
import synapse.Util;

public abstract class BaseBot
extends AdvancedRobot {
    protected Vector<Module> modules;
    protected boolean fighting = true;
    public Hashtable<String, Enemy> targets;
    public Enemy target;
    public Point2D.Double location;
    public Point2D.Double oldLocation;
    public Point2D.Double oldOldLocation;
    public double velocity;
    public double oldVelocity;
    public double oldOldVelocity;
    public double rollingAverageVelocity;
    public double heading = 0.0;
    public int deadBots = 0;
    public int numForeignBots = 0;
    public long time = 0L;
    public long lastStopped = 0L;
    public int lastIncomingBulletFlightTime = 0;
    public double preferredDistance = 1.0;
    public long numTargetScans = 0L;
    public long initializedTime;
    public long skippedTurns = 0L;
    public long shotsFired = 0L;
    public long shotsHit = 0L;
    public long shotsFiredEnemy = 0L;
    public long shotsHitEnemy = 0L;
    public static long shotsFiredBattle = 0L;
    public static long shotsHitBattle = 0L;
    public static long shotsFiredBattleEnemy = 0L;
    public static long shotsHitBattleEnemy = 0L;
    public double totalPowerFired = 0.0;
    public double totalPowerHit = 0.0;
    public double totalDamageInflicted = 0.0;
    public double totalPowerFiredEnemy = 0.0;
    public double totalPowerHitEnemy = 0.0;
    public double totalDamageInflictedEnemy = 0.0;
    public static final boolean DEBUG_ENABLED = true;

    protected void updateInternalVars() {
        this.oldOldLocation = this.oldLocation;
        this.oldLocation = this.location;
        this.location = new Point2D.Double(this.getX(), this.getY());
        this.oldOldVelocity = this.oldVelocity;
        this.oldVelocity = this.velocity;
        this.velocity = this.getVelocity();
        this.rollingAverageVelocity = this.rollingAverageVelocity * 0.72 + this.velocity * 0.25;
        this.heading = this.getHeadingRadians();
        this.time = this.getTime();
        if (this.oldVelocity * this.velocity <= 0.0) {
            this.lastStopped = this.time;
        }
    }

    protected final void printStats() {
        if (this.target != null && this.target.name != null) {
            this.out.println("            Geomancy | " + this.target.name.substring(this.target.name.lastIndexOf(".", this.target.name.lastIndexOf(" ")) + 1, this.target.name.lastIndexOf(" ")) + "\nBullets              |" + "\n     Fired     " + Util.formatNumber(this.shotsFired, 6) + "| " + Util.formatNumber(this.shotsFiredEnemy, 6) + "\n     Landed    " + Util.formatNumber(this.shotsHit, 6) + "| " + Util.formatNumber(this.shotsHitEnemy, 6) + "\n     Round %   " + Util.formatNumber(100.0 * (double)this.shotsHit / (double)this.shotsFired, 6, 2) + "| " + Util.formatNumber(100.0 * (double)this.shotsHitEnemy / (double)this.shotsFiredEnemy, 6, 2) + "\n     Battle %  " + Util.formatNumber(100.0 * (double)shotsHitBattle / (double)shotsFiredBattle, 6, 2) + "| " + Util.formatNumber(100.0 * (double)shotsHitBattleEnemy / (double)shotsFiredBattleEnemy, 6, 2) + "\nPower                |" + "\n     Fired     " + Util.formatNumber(this.totalPowerFired, 6, 1) + "| " + Util.formatNumber(this.totalPowerFiredEnemy, 6, 1) + "\n     Landed    " + Util.formatNumber(this.totalPowerHit, 6, 1) + "| " + Util.formatNumber(this.totalPowerHitEnemy, 6, 1) + "\n     Percent   " + Util.formatNumber(100.0 * this.totalPowerHit / this.totalPowerFired, 6, 2) + "| " + Util.formatNumber(100.0 * this.totalPowerHitEnemy / this.totalPowerFiredEnemy, 6, 2) + "\n     Average   " + Util.formatNumber(this.shotsFired > 0L ? this.totalPowerFired / (double)this.shotsFired : 0.0, 6, 2) + "| " + Util.formatNumber(this.shotsFiredEnemy > 0L ? this.totalPowerFiredEnemy / (double)this.shotsFiredEnemy : 0.0, 6, 2) + "\nDamage Dealt   " + Util.formatNumber(this.totalDamageInflicted, 6, 1) + "| " + Util.formatNumber(this.totalDamageInflictedEnemy, 6, 1) + "\n");
        } else {
            this.out.println("No opponents? Hmm.");
        }
        this.out.println("                     +\n              Module | Time");
        long allTimeSpent = 0L;
        for (Module m : this.modules) {
            allTimeSpent += m.getRunTime();
        }
        for (Module m : this.modules) {
            this.out.println(String.valueOf(Util.padString(m.toString(), 20, false, 2)) + " | " + Util.formatNumber((double)m.getRunTime() * 100.0 / (double)allTimeSpent, 4) + "%");
        }
        this.out.println("Average ms per turn: " + allTimeSpent / this.time);
    }

    protected abstract void onWin();

    public Point2D.Double goTo(double x, double y) {
        double a = Math.atan2(x -= this.getX(), y -= this.getY()) - this.getHeadingRadians();
        this.setTurnRightRadians(Math.tan(a));
        this.setAhead(Math.hypot(x, y) * Math.cos(a));
        return new Point2D.Double(x, y);
    }

    public final void onBulletHit(BulletHitEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onBulletHitBullet(BulletHitBulletEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onHitByBullet(HitByBulletEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onHitRobot(HitRobotEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onHitWall(HitWallEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onRobotDeath(RobotDeathEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onSkippedTurn(SkippedTurnEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onBattleEnded(BattleEndedEvent e) {
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
    }

    public final void onWin(WinEvent e) {
        this.fighting = false;
        Vector unprocessedEvents = this.getAllEvents();
        for (Module m : this.modules) {
            for (Event unprocessedEvent : unprocessedEvents) {
                if (unprocessedEvent instanceof WinEvent) continue;
                m.useEvent(unprocessedEvent);
            }
        }
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
        this.printStats();
        System.gc();
        this.onWin();
    }

    public final void onDeath(DeathEvent e) {
        this.fighting = false;
        Vector unprocessedEvents = this.getAllEvents();
        for (Module m : this.modules) {
            for (Event unprocessedEvent : unprocessedEvents) {
                if (unprocessedEvent instanceof DeathEvent) continue;
                m.useEvent(unprocessedEvent);
            }
        }
        for (Module m : this.modules) {
            m.useEvent((Event)e);
        }
        this.printStats();
        System.gc();
    }
}

