/*
 * Decompiled with CFR 0.152.
 */
package metal.small.dna2;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import metal.small.dna2.GunWave;
import metal.small.dna2.PUtils;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MGunB {
    static final double BULLET_POWER = 2.3;
    static final double MAX_BULLET_POWER = 3.0;
    static final double MAX_DISTANCE = 900.0;
    static final double WALL_MARGIN = 18.0;
    static double enemyDistance;
    static Point2D enemyLocation;
    Rectangle2D fieldRectangle;
    public static boolean isTC;
    static double lastEnemyBearingDirection;
    static double lastVelocity;
    AdvancedRobot robot;
    static double roundNum;
    static int timeSinceVChange;

    static {
        isTC = false;
        enemyLocation = new Point2D.Double();
        lastEnemyBearingDirection = 0.73;
    }

    public MGunB(AdvancedRobot robot) {
        this.robot = robot;
        this.fieldRectangle = PUtils.fieldRectangle(robot, 18.0);
        if (roundNum > 0.0) {
            System.out.println("range hits given: " + (int)GunWave.rangeHits + " (average / round: " + NumberFormat.getNumberInstance().format(GunWave.rangeHits / roundNum) + ")");
        }
        roundNum += 1.0;
    }

    static int getVelocityIndex(double velocity) {
        if ((velocity = Math.abs(velocity)) > 7.5) {
            return 4;
        }
        if (velocity > 5.0) {
            return 3;
        }
        if (velocity > 2.5) {
            return 2;
        }
        if (velocity > 0.0) {
            return 1;
        }
        return 0;
    }

    public void onBulletHit(BulletHitEvent e) {
        GunWave.hits += 1.0;
        if (enemyDistance > 150.0) {
            GunWave.rangeHits += 1.0;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double wantedBulletPower;
        GunWave wave = new GunWave(this.robot);
        enemyDistance = e.getDistance();
        wave.distanceIndexFaster = (int)Math.min(2.0, enemyDistance / 300.0);
        wave.distanceIndex = (int)Math.min(4.0, enemyDistance / 180.0);
        double bulletPower = wantedBulletPower = isTC ? 3.0 : (wave.distanceIndex > 0 ? 2.3 : 3.0);
        if (!isTC) {
            bulletPower = Math.min(Math.min(e.getEnergy() / 4.0, this.robot.getEnergy() / 7.0), wantedBulletPower);
        }
        wave.bulletPowerIndex = (int)(bulletPower / 0.65);
        Point2D.Double robotLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        wave.setGunLocation(robotLocation);
        double enemyBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        wave.setStartBearing(enemyBearing);
        wave.setTargetLocation(enemyLocation);
        enemyLocation.setLocation(PUtils.project(robotLocation, enemyBearing, enemyDistance));
        wave.velocityIndex = MGunB.getVelocityIndex(e.getVelocity());
        wave.lastVelocityIndex = MGunB.getVelocityIndex(lastVelocity);
        if (Math.abs(lastVelocity - e.getVelocity()) > 0.1) {
            timeSinceVChange = 0;
        }
        lastVelocity = e.getVelocity();
        double approachVelocity = e.getVelocity() * -Math.cos(e.getHeadingRadians() - enemyBearing);
        wave.approachSignIndex = 1 + (Math.abs(approachVelocity) < 1.5 ? 0 : PUtils.sign(approachVelocity));
        double bulletVelocity = PUtils.bulletVelocity(bulletPower);
        double bulletFlightTime = enemyDistance / bulletVelocity;
        wave.setBulletVelocity(bulletVelocity);
        if (e.getVelocity() != 0.0) {
            lastEnemyBearingDirection = wave.maxEscapeAngle() * (double)PUtils.sign(e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyBearing));
        }
        double bearingDirection = lastEnemyBearingDirection / 13.0;
        wave.setBearingDirection(bearingDirection);
        wave.wallIndex = 0;
        while (++wave.wallIndex < 4 && this.fieldRectangle.contains(PUtils.project(robotLocation, enemyBearing + bearingDirection * ((double)wave.wallIndex * 5.5), enemyDistance))) {
        }
        --wave.wallIndex;
        wave.wallIndexFaster = 0;
        while (++wave.wallIndexFaster < 3 && this.fieldRectangle.contains(PUtils.project(robotLocation, enemyBearing + bearingDirection * ((double)wave.wallIndexFaster * 7.5), enemyDistance))) {
        }
        --wave.wallIndexFaster;
        wave.velocityChangedIndex = (int)PUtils.minMax(Math.pow(bulletVelocity * (double)timeSinceVChange / (enemyDistance / (double)timeSinceVChange), 0.35), 0.0, 4.0);
        wave.velocityChangedIndexFaster = (int)PUtils.minMax(Math.pow(bulletVelocity * (double)timeSinceVChange / (enemyDistance / (double)timeSinceVChange), 0.35), 0.0, 2.0);
        ++timeSinceVChange;
        this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyBearing - this.robot.getGunHeadingRadians() + bearingDirection * (double)(wave.mostVisited() - 13))));
        if ((isTC || this.robot.getEnergy() >= 2.3 || e.getEnergy() < this.robot.getEnergy() / 3.0 || wave.distanceIndex < 1) && this.robot.setFireBullet(bulletPower) != null) {
            wave.weight = 2.5;
        }
        if (this.robot.getOthers() > 0 && this.robot.getEnergy() > 0.0) {
            this.robot.addCustomEvent((Condition)wave);
        }
    }
}

