/*
 * Decompiled with CFR 0.152.
 */
package simonton.core;

import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import simonton.core.Bot;
import simonton.core.SelfSynchronizer;
import simonton.core.SlaveBot;
import simonton.utils.FastMath;
import simonton.utils.Util;

public class OneOnOneBot
extends AdvancedRobot
implements Bot {
    private static SelfSynchronizer gunAdapter;
    private static SelfSynchronizer legAdapter;
    private static int skippedTurns;
    private static double damageTaken;
    private static double damageGiven;
    private double enemyEnergy;
    private double energy;
    private boolean roundOver;
    private static long gunTime;
    private static long legTime;
    private static int gunTurns;
    private static int legTurns;
    private ScannedRobotEvent scan;

    protected SlaveBot getGun() {
        return null;
    }

    protected SlaveBot getMovement() {
        return null;
    }

    @Override
    public void run() {
        SlaveBot leg;
        SlaveBot gun;
        this.enemyEnergy = 100.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Util.startRound(this);
        if (gunAdapter == null && (gun = this.getGun()) != null) {
            gunAdapter = new SelfSynchronizer(this, gun);
        }
        if (legAdapter == null && (leg = this.getMovement()) != null) {
            legAdapter = new SelfSynchronizer(this, leg);
        }
        if (gunAdapter != null) {
            gunAdapter.run();
        }
        if (legAdapter != null) {
            legAdapter.run();
        }
        while (true) {
            Util.startTurn(this);
            if (this.scan == null) {
                if (this.getTime() > 20L && !this.roundOver) {
                    Util.log("RADAR SLIP!!!", new Object[0]);
                }
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            } else {
                double bearing = Util.getAbsoluteBearing(this, this.scan);
                double turn = FastMath.normalize(bearing - this.getRadarHeadingRadians());
                this.setTurnRadarRightRadians(turn);
            }
            if (gunAdapter != null) {
                long time = System.nanoTime();
                gunAdapter.shootLikeHim();
                gunTime += System.nanoTime() - time;
                ++gunTurns;
            }
            if (legAdapter != null) {
                long time = System.nanoTime();
                legAdapter.moveLikeHim();
                legTime += System.nanoTime() - time;
                ++legTurns;
            }
            this.energy = this.getEnergy();
            this.scan = null;
            this.scan();
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.scan = e;
        this.enemyEnergy = e.getEnergy();
        if (gunAdapter != null) {
            gunAdapter.onScannedRobot(e);
        }
        if (legAdapter != null) {
            legAdapter.onScannedRobot(e);
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (gunAdapter != null) {
            gunAdapter.onBulletHitBullet(e);
        }
        if (legAdapter != null) {
            legAdapter.onBulletHitBullet(e);
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.enemyEnergy += 3.0 * e.getPower();
        damageTaken += Util.getBulletDamage(e.getPower());
        if (gunAdapter != null) {
            gunAdapter.onHitByBullet(e);
        }
        if (legAdapter != null) {
            legAdapter.onHitByBullet(e);
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = FastMath.min(Util.getBulletDamage(power), this.enemyEnergy);
        damageGiven += damage;
        this.enemyEnergy -= damage;
        if (gunAdapter != null) {
            gunAdapter.onBulletHit(e);
        }
        if (legAdapter != null) {
            legAdapter.onBulletHit(e);
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        if (gunAdapter != null) {
            gunAdapter.onBulletMissed(e);
        }
        if (legAdapter != null) {
            legAdapter.onBulletMissed(e);
        }
    }

    @Override
    public void onHitWall(HitWallEvent e) {
        Util.log("Hit wall!", new Object[0]);
        if (gunAdapter != null) {
            gunAdapter.onHitWall(e);
        }
        if (legAdapter != null) {
            legAdapter.onHitWall(e);
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        Util.log("Collide", new Object[0]);
        if (gunAdapter != null) {
            gunAdapter.onHitRobot(e);
        }
        if (legAdapter != null) {
            legAdapter.onHitRobot(e);
        }
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
        Util.log("Skipped Turn!", new Object[0]);
        ++skippedTurns;
        if (gunAdapter != null) {
            gunAdapter.onSkippedTurn(e);
        }
        if (legAdapter != null) {
            legAdapter.onSkippedTurn(e);
        }
    }

    @Override
    public void onDeath(DeathEvent e) {
        for (Event event : this.getAllEvents()) {
            if (!(event instanceof HitByBulletEvent)) continue;
            damageTaken += this.energy;
        }
        if (gunAdapter != null) {
            gunAdapter.handleDeathEvent(this, e);
        }
        if (legAdapter != null) {
            legAdapter.handleDeathEvent(this, e);
        }
        this.endRound();
    }

    @Override
    public void onWin(WinEvent e) {
        if (gunAdapter != null) {
            gunAdapter.onWin(e);
        }
        if (legAdapter != null) {
            legAdapter.onWin(e);
        }
        this.endRound();
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (gunAdapter != null) {
            gunAdapter.onPaint(g);
        }
        if (legAdapter != null) {
            legAdapter.onPaint(g);
        }
    }

    protected void endRound() {
        if (gunAdapter != null) {
            gunAdapter.printStats();
        }
        if (legAdapter != null) {
            legAdapter.printStats();
        }
        this.roundOver = true;
        double round = this.getRoundNum() + 1;
        Util.log(String.valueOf(skippedTurns) + " skipped turns", new Object[0]);
        Util.log("Gun time: %.4f ms/turn, %.2f ms/round", new Object[]{(double)gunTime / (double)gunTurns / 1000000.0, (double)gunTime / round / 1000000.0});
        Util.log("Movement time: %.4f ms/turn, %.2f ms/round", new Object[]{(double)legTime / (double)legTurns / 1000000.0, (double)legTime / round / 1000000.0});
        double percent = damageTaken / round;
        Util.log("Damage taken: %.2f (%.2f/%.2f)", new Object[]{damageTaken, percent, 100.0 - percent});
        percent = damageGiven / (double)(this.getRoundNum() + 1);
        Util.log("Damage given: %.2f (%.2f/%.2f)", new Object[]{damageGiven, percent, 100.0 - percent});
        if (this.getRoundNum() + 1 == this.getNumRounds()) {
            gunAdapter = null;
            legAdapter = null;
            Util.endBattle();
        }
    }
}

