/*
 * Decompiled with CFR 0.152.
 */
package barontrozo.dataStructures.trees;

import barontrozo.dataStructures.BinaryHeap;
import barontrozo.dataStructures.IntervalHeap;
import barontrozo.dataStructures.MinHeap;
import barontrozo.dataStructures.trees.DistanceFunction;
import barontrozo.dataStructures.trees.KdNode;
import barontrozo.dataStructures.trees.KdTree;
import java.util.Arrays;
import java.util.Iterator;

public class NearestNeighborIterator<T>
implements Iterator<T>,
Iterable<T> {
    private DistanceFunction distanceFunction;
    private double[] searchPoint;
    private MinHeap<KdNode<T>> pendingPaths;
    private IntervalHeap<T> evaluatedPoints;
    private int pointsRemaining;
    private double lastDistanceReturned;

    protected NearestNeighborIterator(KdNode<T> treeRoot, double[] searchPoint, int maxPointsReturned, DistanceFunction distanceFunction) {
        this.searchPoint = Arrays.copyOf(searchPoint, searchPoint.length);
        this.pointsRemaining = Math.min(maxPointsReturned, treeRoot.size());
        this.distanceFunction = distanceFunction;
        this.pendingPaths = new BinaryHeap.Min<KdNode<T>>();
        this.pendingPaths.offer(0.0, treeRoot);
        this.evaluatedPoints = new IntervalHeap();
    }

    @Override
    public boolean hasNext() {
        return this.pointsRemaining > 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public T next() {
        if (this.hasNext()) ** GOTO lbl4
        throw new IllegalStateException("NearestNeighborIterator has reached end!");
lbl-1000:
        // 1 sources

        {
            KdTree.nearestNeighborSearchStep(this.pendingPaths, this.evaluatedPoints, this.pointsRemaining, this.distanceFunction, this.searchPoint);
lbl4:
            // 2 sources

            ** while (this.pendingPaths.size() > 0 && (this.evaluatedPoints.size() == 0 || this.pendingPaths.getMinKey() < this.evaluatedPoints.getMinKey()))
        }
lbl5:
        // 1 sources

        --this.pointsRemaining;
        this.lastDistanceReturned = this.evaluatedPoints.getMinKey();
        value = this.evaluatedPoints.getMin();
        this.evaluatedPoints.removeMin();
        return value;
    }

    public double distance() {
        return this.lastDistanceReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

