/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.geom.Point2D;
import jwirde.BaseGun;
import jwirde.CoordUtils;
import jwirde.Ghost;
import jwirde.VectPol;
import robocode.AdvancedRobot;
import robocode.Rules;

public class LinearGun
extends BaseGun {
    double maxX;
    double maxY;

    public LinearGun(AdvancedRobot robot) {
        super(robot);
        this.maxX = this.myRobot.getBattleFieldWidth();
        this.maxY = this.myRobot.getBattleFieldHeight();
    }

    @Override
    protected void doAim(Ghost ghost) {
        Point2D predictedPosition;
        Point2D.Double myPos = new Point2D.Double(this.myRobot.getX(), this.myRobot.getY());
        double bulletSpeed = Rules.getBulletSpeed((double)this.nextBulletPower);
        long deltaTime = 1L;
        while (true) {
            double bulletDistance = (double)deltaTime * bulletSpeed;
            predictedPosition = CoordUtils.getCoordFromBearing(ghost.coord, new VectPol(ghost.heading, (double)(deltaTime + (this.myRobot.getTime() - ghost.timeSpotted)) * ghost.velocity));
            if (predictedPosition.distance(myPos) < bulletDistance || this.isPositionAtWall(predictedPosition)) break;
            ++deltaTime;
        }
        double angle = CoordUtils.getRelativeAngle(myPos, predictedPosition, this.myRobot.getGunHeadingRadians());
        this.myRobot.setTurnGunRightRadians(angle);
    }

    private boolean isPositionAtWall(Point2D predictedPosition) {
        return predictedPosition.getX() < 0.0 || predictedPosition.getX() > this.maxX || predictedPosition.getY() < 0.0 || predictedPosition.getY() > this.maxY;
    }

    @Override
    public String getName() {
        return "LinearGun";
    }
}

