/*
 * Decompiled with CFR 0.152.
 */
package lunchie;

import java.io.PrintStream;
import lunchie.Position;
import lunchie.RobotInfo;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class RobotEvent {
    long time;
    double dx;
    double dy;
    double dv;
    double velocity;
    double av;
    double energy;
    double range;
    double headingR;
    Position pos;
    Position me;

    private final void init() {
        this.dx = 0.0;
        this.dy = 0.0;
        this.av = 0.0;
        this.dv = 0.0;
    }

    public void calcDifferentials(RobotEvent last) {
        long ticks = this.time - last.time;
        this.av = RobotInfo.normaliseHeadingR(this.headingR - last.headingR) / (double)ticks;
        this.dx = (this.pos.getX() - last.pos.getX()) / (double)ticks;
        this.dy = (this.pos.getY() - last.pos.getY()) / (double)ticks;
        this.dv = (this.velocity - last.velocity) / (double)ticks;
    }

    public void updateRange(Position newPos) {
        this.range = this.pos.getRangeTo(newPos);
    }

    public String toString() {
        return "<" + this.time + "> " + this.pos.toString() + " dx=" + this.dx + " dy=" + this.dy + " v=" + this.velocity + " headR=" + this.headingR + " e=" + this.energy + " range=" + this.range;
    }

    public void dump(PrintStream ostr) {
        ostr.print(this.toString());
    }

    public RobotEvent(HitRobotEvent ev, Position here, AdvancedRobot r) {
        this.init();
        this.time = r.getTime();
        this.velocity = 0.0;
        this.range = 40.0;
        this.energy = ev.getEnergy();
        this.headingR = 0.0;
        this.pos = here.getRelative(r.getHeadingRadians() + ev.getBearingRadians(), this.range);
        this.me = here;
    }

    public RobotEvent(ScannedRobotEvent ev, Position here, AdvancedRobot r) {
        this.init();
        this.time = r.getTime();
        this.range = ev.getDistance();
        this.velocity = ev.getVelocity();
        this.energy = ev.getEnergy();
        this.headingR = ev.getHeadingRadians();
        this.pos = here.getRelative(r.getHeadingRadians() + ev.getBearingRadians(), this.range);
        this.me = here;
    }
}

