/*
 * Decompiled with CFR 0.152.
 */
package jaybot.tactics;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import jaybot.bots.BaseBot;
import jaybot.intel.Enemy;
import jaybot.strategies.Tactic;
import jaybot.tactics.BasePersonality;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class SitAndSpinPersonality
extends BasePersonality
implements Tactic {
    protected boolean giveUpTactic = false;
    protected boolean fastGiveUp = false;
    private static final int _$4730 = 150;
    private boolean _$4731 = true;
    private boolean _$4732 = true;

    public SitAndSpinPersonality(boolean fastGiveUp) {
        this.fastGiveUp = fastGiveUp;
    }

    public boolean isGivingUp() {
        return this.giveUpTactic;
    }

    public void doStartupAction() {
        this.myBot.setColors(this.myBot.getTankColor(), this.myBot.getGunColor(), Color.red);
        this.myBot.setAdjustGunForRobotTurn(true);
        this.myBot.setAdjustRadarForGunTurn(false);
        this.myBot.logTactical("Performing proximity scan");
        this.myBot.turnGunRight(360.0);
        this.myBot.logTactical("Found " + this.opponentTracker.getTrackedAllCompetitorCount() + " other bots");
        boolean anyNearby = false;
        Collection enemies = this.opponentTracker.getAliveEnemies();
        Iterator i = enemies.iterator();
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            double distance = badGuy.getDistanceToLastPosition();
            this.myBot.logTactical("   " + badGuy.getName() + " at distance " + dblfmt.format(distance));
            if (distance == Double.POSITIVE_INFINITY || !(distance <= 150.0)) continue;
            anyNearby = true;
        }
        if (!anyNearby) {
            this.myBot.logTactical("No bots nearby after first complete scan, skipping this mode!");
            this.giveUpTactic = true;
        } else if (this.fastGiveUp) {
            this.myBot.logTactical("Giving up quickly upon request from controller");
            this.giveUpTactic = true;
        }
    }

    public void doRunIteration() {
        this.myBot.turnGunRight(3600.0);
    }

    public void reactToYouHitByEnemyBullet(HitByBulletEvent event, Enemy badGuy) {
        int multiplier = 1;
        if (new Random().nextInt(2) == 1) {
            multiplier = -1;
        }
        this.myBot.turnTankToBearingDegrees(event.getBearing() - (double)(90 * multiplier));
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event) {
        this.myBot.stop();
        double gunToCollisionAngle = BaseBot.diffBetweenRelativeAnglesDegrees(this.myBot.getGunBearingInDegrees(), event.getBearing());
        if (Math.abs(gunToCollisionAngle) < 20.0) {
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        } else if (Math.abs(gunToCollisionAngle) < 45.0) {
            this.myBot.turnGunToBearingDegrees(event.getBearing());
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        }
        this.myBot.resume();
        if (event.isMyFault()) {
            this.myBot.back(new Random().nextInt(50) + 50);
        } else {
            double absBearing = Math.abs(event.getBearing());
            int multiplier = 1;
            if (new Random().nextInt(2) == 1) {
                multiplier = -1;
            }
            if (absBearing <= 45.0) {
                this.myBot.back(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (absBearing >= 135.0) {
                this.myBot.ahead(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (event.getBearing() < 0.0) {
                this.myBot.turnTankToBearingDegrees(event.getBearing() + 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            } else {
                this.myBot.turnTankToBearingDegrees(event.getBearing() - 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            }
        }
    }

    public void reactToYouHitWall(HitWallEvent event) {
        if (this._$4732) {
            this._$4732 = false;
            return;
        }
        this.myBot.turnTankToBearingDegrees(event.getBearing());
        this.myBot.back(new Random().nextInt(50) + 50);
        this.myBot.turnTankToBearingDegrees(180.0);
    }

    public void reactToSeeingEnemyRobot(ScannedRobotEvent event, Enemy badGuy) {
        if (this._$4731) {
            // empty if block
        }
        if (this.myBot.getGunHeat() <= 0.0) {
            if (event.getDistance() <= 150.0 || event.getVelocity() == 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, event.getDistance());
            }
        } else {
            this.myBot.scan();
        }
        this.myBot.ahead(new Random().nextInt(200) - 100);
        this.myBot.turnTankToBearingDegrees(new Random().nextInt(90) - 45);
    }

    public void reactToBulletHitTarget(BulletHitEvent event, Enemy actualTarget, Enemy intendedTarget) {
    }

    public void reactToBulletHitAnotherBullet(BulletHitBulletEvent event, Enemy ownerOfOtherBullet, Enemy intendedTarget) {
    }

    public void reactToBulletMissedTarget(BulletMissedEvent event, Enemy intendedTarget) {
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event, Enemy badGuy) {
    }

    public void reactToAnotherRobotDeath(RobotDeathEvent event, Enemy deadBadGuy) {
    }
}

