/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.MovementChange;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RamMoving;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.util.Utils;

public class CircleMoving
extends RamMoving {
    protected int direction;
    protected double heading;
    protected double diveAllowance = 1.0471975511965976;
    protected double slowSpeed = 2.0;
    protected int slowPeriod = 4;
    protected BulletTracking evading = null;
    protected double maxSpeed = 8.0;
    protected double movingBudget = -1.0;
    private Position pivot = null;

    public CircleMoving(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot, tracking);
    }

    protected void setPivot(Position position) {
        this.pivot = position;
    }

    @Override
    public void init() {
        this.heading = this.robot.getHeadingRadians();
        this.direction = 1;
    }

    public void setMovingBudget(double d) {
        this.movingBudget = d;
    }

    protected void setMovingBudget(double d, Position position) {
        this.movingBudget = d * position.distance(new Position((Robot)this.robot));
    }

    public void setMaxSpeed(double d) {
        this.movingBudget = -1.0;
        this.maxSpeed = d;
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.emergencyDirectionChange();
    }

    protected void emergencyDirectionChange() {
        this.direction *= -1;
    }

    protected double getCurrentDistanceCorrection(Opponent opponent) {
        Position position = new Position((Robot)this.robot);
        if (position.inCorner(150)) {
            return -0.25;
        }
        double d = -0.1;
        double d2 = opponent.getSuggestedDistance();
        if (!Double.isNaN(d2)) {
            double d3 = d2 - position.distance(opponent.getLastPosition());
            d = d3 / (this.robot.getBattleFieldHeight() / 0.6);
            if (d > 0.25) {
                d = 0.25;
            }
            if (d < -0.25) {
                d = -0.25;
            }
        }
        return d;
    }

    protected MovementChange getNeededDirChange(Opponent opponent, Position position, Position position2, int n, boolean bl) {
        boolean bl2;
        double d;
        int n2 = n;
        double d2 = -0.05;
        if (bl && opponent != null) {
            d2 = this.getCurrentDistanceCorrection(opponent);
            Log.log(4, "Distance correction: " + d2);
        }
        while (true) {
            this.heading = position.getDirectionTo(position2);
            d = this.heading = Utils.normalAbsoluteAngle((double)(this.heading - (1.5707963267948966 + (double)n * d2)));
            if (n == -1) {
                d = Utils.normalAbsoluteAngle((double)(d + Math.PI));
            }
            Position position3 = new Position(position);
            position3.modify(1L, 140.0, d);
            bl2 = position3.adjustForWalls(position, 1, null, 0.0, d);
            d = position.getDirectionTo(position3);
            if (opponent == null || !bl2 || position.inCorner(60)) break;
            double d3 = AngleUtils.difference(d, position.getDirectionTo(position2));
            double d4 = 9.0 * this.diveAllowance / 10.0;
            if (d3 > 0.0 && d3 < d4) {
                n *= -1;
                continue;
            }
            if (d3 < 0.0 && d3 > -d4) {
                n *= -1;
                continue;
            }
            if (d3 < -(Math.PI - d4)) {
                n *= -1;
                continue;
            }
            if (!(d3 > Math.PI - d4)) break;
            n *= -1;
        }
        if (bl2 && n == -1) {
            this.heading = Utils.normalAbsoluteAngle((double)(d + Math.PI));
        }
        d = Utils.normalRelativeAngle((double)(this.heading - this.robot.getHeadingRadians()));
        return new MovementChange(n != n2, d);
    }

    @Override
    public void turn() {
        Position position = new Position((Robot)this.robot);
        double d = 20.0;
        Opponent opponent = this.tracking.getLastHitBy();
        MovementChange movementChange = null;
        if (this.pivot != null) {
            movementChange = this.getNeededDirChange(opponent, position, this.pivot, this.direction, false);
            Log.paintLine(4, position, this.pivot, new Color(0, 0, 255, 100), 0);
        } else if (opponent == null && this.pivot == null) {
            movementChange = this.getNeededDirChange(opponent, position, Position.getCenter(), this.direction, false);
            Log.paintLine(4, position, Position.getCenter(), new Color(0, 0, 255, 100), 0);
        } else {
            movementChange = this.getNeededDirChange(opponent, position, opponent.getLastPosition(), this.direction, true);
            Log.paintLine(4, position, opponent.getLastPosition(), new Color(0, 0, 255, 100), 0);
        }
        assert (movementChange != null);
        if (movementChange.revert) {
            this.emergencyDirectionChange();
        }
        this.evading = this.tracking.getClosestBullet();
        if (this.evading != null && this.evading.getSource().distance(position) > 300.0) {
            int n;
            long l = this.robot.getTime();
            long l2 = this.evading.getETA(position) - 1L;
            if (l2 >= l - (long)(n = (int)((double)(this.slowPeriod / 2) + (Math.abs(this.robot.getVelocity()) - this.slowSpeed) / 2.0)) && l2 < l + (long)n - 1L) {
                d = this.slowSpeed;
            }
        }
        if (opponent != null && position.distance(opponent.getLastPosition()) > 150.0) {
            if (d > this.maxSpeed) {
                d = this.maxSpeed;
            }
            if (d < -this.maxSpeed) {
                d = -this.maxSpeed;
            }
        }
        if (opponent != null && opponent.getLastEnergy() == 0.0 && this.tracking.getClosestBullet() == null) {
            d = 0.0;
        }
        if (this.movingBudget == -1.0) {
            d += d / 2.0 * (d / 2.0);
            this.robot.setAhead(d * (double)this.direction);
        } else if (this.movingBudget > 0.0) {
            this.robot.setAhead(this.movingBudget * (double)this.direction);
            this.movingBudget = 0.0;
        }
        this.robot.setTurnRightRadians(movementChange.dirChange);
        super.turn();
    }

    public void bulletHitMe(BulletTracking bulletTracking) {
        bulletTracking.setEvaded();
    }
}

