/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import java.util.Enumeration;
import rz.a.AbstractRobot;
import rz.a.Enemy;
import rz.a.Point;
import rz.a.Strategy;
import rz.a.Wave;

public class Movement {
    private static final double BEST_DIST = 600.0;
    private static final double DIST_WEIGHT = 400.0;
    private static final double OFFSET_LIMIT = 0.9;
    private static final double STICK_LENGTH = 160.0;
    private static final double FLAT_FACTOR = 1.5;
    private static AbstractRobot ar;
    public double bestBearing;
    public int direction;
    public Point next;
    public Point lastPos;
    public double risk;

    public void initNewRound() {
        this.direction = 2 * (int)Math.rint(Math.random()) - 1;
        this.next = new Point(AbstractRobot.myPos.x, AbstractRobot.myPos.y);
        this.lastPos = new Point(AbstractRobot.myPos.x, AbstractRobot.myPos.y);
    }

    public void melee() {
        double myY;
        double myX;
        block10: {
            block9: {
                myX = AbstractRobot.myPos.x;
                myY = AbstractRobot.myPos.y;
                double thisRisk = this.evaluate(this.next.x, this.next.y);
                double factor = 10.0 / Math.max(150.0, AbstractRobot.target.distToMe);
                if (ar.getDistanceRemaining() == 0.0 || this.next.distance(myX, myY) < 15.0 || Math.random() > Math.pow(factor, factor) || Strategy.intersection) break block9;
                int n = AbstractRobot.target.distToMe > 250.0 ? 2 : (AbstractRobot.target.distToMe > 100.0 ? 3 : 1000);
                if (!(thisRisk > (double)n * this.risk)) break block10;
            }
            double dist = 0.8 * AbstractRobot.target.distToMe;
            this.risk = Double.POSITIVE_INFINITY;
            double a = 0.0;
            while (a < Math.PI * 2) {
                double pY;
                double pX = myX + dist * Math.sin(a);
                if (AbstractRobot.distToWall(pX, pY = myY + dist * Math.cos(a)) <= 30.0) {
                    pX = myX + dist / (double)2 * Math.sin(a);
                    pY = myY + dist / (double)2 * Math.cos(a);
                }
                double riskNow = this.evaluate(pX, pY);
                if (AbstractRobot.distToWall(pX, pY) > 30.0 && riskNow + 0.2 / this.lastPos.distanceSq(pX, pY) < this.risk + 0.2 / this.lastPos.distanceSq(this.next)) {
                    this.next.x = pX;
                    this.next.y = pY;
                    this.risk = riskNow;
                }
                a += 0.07;
            }
            this.lastPos.x = myX;
            this.lastPos.y = myY;
        }
        double angle = AbstractRobot.myPos.bearingTo(this.next) - ar.getHeadingRadians();
        int dir = 1;
        if (Math.cos(angle) < 0.0) {
            angle += Math.PI;
            dir = -1;
        }
        angle = AbstractRobot.normalAngle(angle);
        ar.setTurnRightRadians(angle);
        ar.setAhead(AbstractRobot.myPos.distance(this.next) * (double)dir);
        if (AbstractRobot.distToWall(myX, myY) < 100.0) {
            ar.setMaxVelocity(Math.abs(angle) > Math.min((AbstractRobot.distToWall(myX, myY) - 16.0) / 100.0, 1.0) ? 0 : 8);
        } else {
            ar.setMaxVelocity((double)2 / Math.max(0.01, Math.pow(Math.abs(angle), 2)));
        }
    }

    private final double evaluate(double pX, double pY) {
        double eval = 0.0;
        double distFac = (AbstractRobot.target.scanTime < 50L ? 4 : 2) * (AbstractRobot.isLeader + 1);
        double dirFac = Math.max((double)2 - (double)AbstractRobot.others / 10.0, 1.1);
        double f1 = 0.0;
        double f2 = 0.0;
        Enumeration enumeration = AbstractRobot.targets.elements();
        while (enumeration.hasMoreElements()) {
            Enemy en = (Enemy)enumeration.nextElement();
            if (!en.live) continue;
            if (ar.isTeammate(en.name)) {
                eval += 20.0 * (1.0 + 0.2 * Math.abs(Math.cos(Math.atan2(AbstractRobot.myPos.x - pX, AbstractRobot.myPos.y - pY) - Math.atan2(en.pos.x - pX, en.pos.y - pY)))) / en.pos.distanceSq(pX, pY);
                continue;
            }
            f2 = 1.0;
            f1 = 1.0;
            if (!AbstractRobot.team) {
                if (en.pos.distance(pX, pY) < 1.5 * en.minDistance) {
                    f1 = (double)2 * en.minDistance / en.pos.distance(pX, pY);
                    f2 = f1 < 1.5 ? 0.5 : 1.0;
                    eval += f1 / en.pos.distanceSq(pX, pY);
                } else {
                    f2 = 0.2;
                }
                f2 = Math.min(1.0, en.hitFactor > 0.8 ? 1.0 : f2);
            }
            eval += f1 * en.dangerFactor / en.pos.distanceSq(pX, pY) * (distFac + (Math.min(en.hitFactor, 2.5) + f2 * dirFac) * Math.abs(Math.cos(Math.atan2(AbstractRobot.myPos.x - pX, AbstractRobot.myPos.y - pY) - Math.atan2(en.pos.x - pX, en.pos.y - pY))));
        }
        return eval * 100.0;
    }

    public void meleeNear() {
        double value;
        double offset;
        if (AbstractRobot.target.distToMe > 100.0) {
            offset = AbstractRobot.target.isLeader && !AbstractRobot.isLeader ? 1.5707963267948966 : 1.8707963267948966;
        } else {
            offset = 1.5707963267948966 + AbstractRobot.limit(-1.0, (500.0 - AbstractRobot.target.distToMe) / 400.0, 1.0);
            this.direction = Math.cos(AbstractRobot.target.angleToMe - ar.getHeadingRadians()) > 0.0 ? -AbstractRobot.sign(AbstractRobot.normalAngle(ar.getHeadingRadians() - AbstractRobot.target.angleToMe)) : AbstractRobot.sign(AbstractRobot.normalAngle(ar.getHeadingRadians() - AbstractRobot.target.angleToMe));
        }
        offset = this.getWallCutOffset(AbstractRobot.myPos.x, AbstractRobot.myPos.y, offset, AbstractRobot.target.angleToMe, this.direction);
        this.next = AbstractRobot.myPos.projectPoint(150.0, AbstractRobot.target.angleToMe + (double)this.direction * offset);
        double d = value = AbstractRobot.target.distToMe > 300.0 ? 0.59 * AbstractRobot.limit(11.0, AbstractRobot.target.fireSpeed, 20.0) / AbstractRobot.target.distToMe : Math.min(0.075, 6.0 / AbstractRobot.target.distToMe);
        if (AbstractRobot.target.distToMe > 100.0 && (Math.random() > Math.pow(value, value) || offset < 1.0471975511965976)) {
            this.direction = -this.direction;
        }
        this.lastPos.x = AbstractRobot.myPos.x;
        this.lastPos.y = AbstractRobot.myPos.y;
        this.goTo(this.next, 1.4, 8.0);
    }

    public void oneOnOne() {
        Point myPos = AbstractRobot.myPos;
        Point ePos = AbstractRobot.target.pos;
        double dist = myPos.distance(ePos);
        double angle = myPos.bearingTo(ePos);
        double offset = 1.5707963267948966 + AbstractRobot.limit(-0.9, (600.0 - dist) / 400.0, 0.9);
        Wave wave = AbstractRobot.target.statistics.getClosestWave(false);
        if (wave != null) {
            double momBearing = wave.gunLocation.bearingTo(myPos);
            if (!wave.done) {
                wave.referencePoint = new Point(ePos.x, ePos.y);
                double angle1 = wave.gunLocation.bearingTo(this.predict(wave, this.direction));
                double angle2 = wave.gunLocation.bearingTo(this.predict(wave, -this.direction));
                if (AbstractRobot.normalAngle(angle2 - angle1) < 0.0) {
                    double dummy = angle2;
                    angle2 = angle1;
                    angle1 = dummy;
                }
                this.bestBearing = this.getBestAngle(wave, angle1, angle2);
                wave.done = true;
            }
            if (dist > 100.0) {
                this.direction = AbstractRobot.normalAngle(this.bestBearing - momBearing) > 0.0 ? -1 : 1;
                angle = myPos.bearingTo(wave.referencePoint);
                offset = 1.5707963267948966 + AbstractRobot.limit(-0.9, (600.0 - myPos.distance(wave.referencePoint)) / 400.0, 0.9);
                offset = this.getWallCutOffset(myPos.x, myPos.y, offset, angle, this.direction);
                Point p = myPos.projectPoint(160.0, angle + (double)this.direction * offset);
                this.goTo(p, 1.0, 8.0);
            } else {
                this.closeMove();
            }
        } else {
            if ((offset = this.getWallCutOffset(myPos.x, myPos.y, offset, angle, this.direction)) < 0.6707963267948965 || dist < 400.0 && offset < 1.0) {
                this.direction = -this.direction;
            }
            Point p = myPos.projectPoint(160.0, angle + (double)this.direction * offset);
            this.goTo(p, 0.2, 8.0);
        }
    }

    public void closeMove() {
        this.next.x = AbstractRobot.target.pos.x;
        this.next.y = AbstractRobot.target.pos.y;
        double d = 150.0;
        double a = 0.0;
        while (a <= Math.PI * 2) {
            double nY;
            double nX = AbstractRobot.myPos.x + d * Math.sin(a);
            if (AbstractRobot.distToWall(nX, nY = AbstractRobot.myPos.y + d * Math.cos(a)) < 23.0) {
                nX = AbstractRobot.myPos.x + d / (double)2 * Math.sin(a);
                nY = AbstractRobot.myPos.y + d / (double)2 * Math.cos(a);
            }
            if (AbstractRobot.distToWall(nX, nY) > 23.0 && AbstractRobot.target.pos.distance(nX, nY) > AbstractRobot.target.pos.distance(this.next)) {
                this.next.x = nX;
                this.next.y = nY;
            }
            a += 0.1;
        }
        double ang = AbstractRobot.myPos.bearingTo(this.next) - ar.getHeadingRadians();
        int dir = 1;
        if (Math.cos(ang) < 0.0) {
            ang += Math.PI;
            dir = -1;
        }
        ang = AbstractRobot.normalAngle(ang);
        ar.setAhead(100 * dir);
        ar.setTurnRightRadians(ang);
        if (AbstractRobot.target.pos.distance(AbstractRobot.myPos) > 100.0) {
            ar.setMaxVelocity((double)4 / Math.max(Math.abs(ang), 0.01));
        } else {
            ar.setMaxVelocity(8.0);
        }
    }

    public double getBestAngle(Wave wave, double minAngle, double maxAngle) {
        double absBearing = wave.absBearing;
        double dangerBearing = wave.dangerBearing;
        double bearingDirection = wave.bearingDirection;
        double sizeDiff = 40.0 / AbstractRobot.myPos.distance(wave.gunLocation);
        double bestValue = Double.POSITIVE_INFINITY;
        double angleDiff = Math.max(AbstractRobot.normalAngle(maxAngle - minAngle), 0.01);
        int size = wave.hitFactors.length;
        double mid = ((double)size - 1.0) / (double)2;
        double hSum = AbstractRobot.target.statistics.getSum(wave.hitFactors) + 1.0;
        double fSum = AbstractRobot.target.statistics.getSum(wave.flatFactors) + 1.0;
        double[] array = new double[size];
        int i = 0;
        while (i < size) {
            array[i] = (double)wave.flat * 1.5 * (wave.flatFactors[i] / fSum) * (wave.flatFactors[i] / fSum) + wave.hitFactors[i] / hSum * (wave.hitFactors[i] / hSum);
            ++i;
        }
        double bestAngle = minAngle + angleDiff / (double)2;
        double a = minAngle;
        while (a <= minAngle + angleDiff) {
            double dummy = 0.0;
            double b = -sizeDiff / (double)2;
            while (b <= sizeDiff / (double)2) {
                double value = AbstractRobot.normalAngle(a + b - absBearing) / bearingDirection + mid;
                int leftOne = (int)Math.floor(value);
                double weight = value - (double)leftOne;
                dummy += (1.0 - weight) * array[Math.max(0, Math.min(leftOne, size - 1))] + weight * array[Math.max(0, Math.min(leftOne + 1, size - 1))];
                b += sizeDiff / 8.0;
            }
            if (dummy < bestValue || dummy == bestValue && this.angleDist(dangerBearing, a) > this.angleDist(dangerBearing, bestAngle)) {
                bestValue = dummy;
                bestAngle = AbstractRobot.normalAngle(a);
            }
            a += angleDiff / 50.0;
        }
        return bestAngle;
    }

    public double angleDist(double a1, double a2) {
        return Math.abs(AbstractRobot.normalAngle(a1 - a2));
    }

    public Point predict(Wave nearWave, int dir) {
        double predictedX = AbstractRobot.myPos.x;
        double predictedY = AbstractRobot.myPos.y;
        double velocity = ar.getVelocity();
        double heading = ar.getHeadingRadians();
        double travel = nearWave.travel(ar.getTime());
        do {
            double dist = nearWave.referencePoint.distance(predictedX, predictedY);
            double angle = Math.atan2(nearWave.referencePoint.x - predictedX, nearWave.referencePoint.y - predictedY);
            double offset = 1.5707963267948966 + AbstractRobot.limit(-0.9, (600.0 - dist) / 400.0, 0.9);
            offset = this.getWallCutOffset(predictedX, predictedY, offset, angle, dir);
            double pX = predictedX + 160.0 * Math.sin(angle + (double)dir * offset);
            double pY = predictedY + 160.0 * Math.cos(angle + (double)dir * offset);
            double moveAngle = Math.atan2(pX - predictedX, pY - predictedY) - heading;
            int moveDir = 1;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1;
            }
            moveAngle = AbstractRobot.normalAngle(moveAngle);
            double maxTurning = Math.PI * (40.0 - (double)3 * Math.abs(velocity)) / 720.0;
            heading = AbstractRobot.normalAngle(heading + AbstractRobot.limit(-maxTurning, moveAngle, maxTurning));
            double maxVelocity = Math.abs(moveAngle) > 1.0 ? 0 : 8;
            velocity = Math.abs(velocity) > maxVelocity ? (Math.abs(velocity) < (double)2 ? 0.0 : (velocity -= (double)(2 * AbstractRobot.sign(velocity)))) : AbstractRobot.limit(-maxVelocity, velocity + (double)(velocity * (double)moveDir < 0.0 ? 2 * moveDir : moveDir), maxVelocity);
            predictedX += velocity * Math.sin(heading);
            predictedY += velocity * Math.cos(heading);
            travel += nearWave.bulletVelocity;
            if (!(offset < 0.7 && dist < 750.0 || dist < 300.0 && offset < 1.0) && !(AbstractRobot.distToWall(predictedX, predictedY) < 18.0)) continue;
            return new Point(predictedX, predictedY);
        } while (travel < nearWave.gunLocation.distance(predictedX, predictedY));
        return new Point(predictedX, predictedY);
    }

    public double getWallCutOffset(double refX, double refY, double offset, double angle, int dir) {
        double pY;
        double pX = refX + 160.0 * Math.sin(angle + (double)dir * offset);
        double distToWall = AbstractRobot.distToWall(pX, pY = refY + 160.0 * Math.cos(angle + (double)dir * offset));
        if (distToWall <= 18.0) {
            double offsetDown = 0.0;
            double offsetUp = offset;
            int i = 0;
            while ((distToWall <= 18.0 || distToWall > 19.0) && ++i < 30) {
                offset = (offsetDown + offsetUp) / (double)2;
                pX = refX + 160.0 * Math.sin(angle + (double)dir * offset);
                distToWall = AbstractRobot.distToWall(pX, pY = refY + 160.0 * Math.cos(angle + (double)dir * offset));
                if (distToWall > 18.5) {
                    offsetDown = offset;
                    continue;
                }
                offsetUp = offset;
            }
        }
        return offset;
    }

    public void idle() {
        Point center = new Point(AbstractRobot.maxX / (double)2, AbstractRobot.maxY / (double)2);
        double rad = Math.min(AbstractRobot.maxX, AbstractRobot.maxY) / (double)3;
        double distToCenter = this.next.distance(center);
        if (AbstractRobot.myPos.distance(this.next) < 15.0 || distToCenter > rad || Strategy.intersection) {
            double angle = Math.PI * 2 * Math.random();
            this.next = center.projectPoint(rad *= Math.random(), angle);
            this.lastPos = center.projectPoint(rad, angle);
        }
        this.goTo(this.next, 1.0, 8.0);
    }

    public void goTo(Point nextPos, double factor, double maxVelocity) {
        double angle = AbstractRobot.myPos.bearingTo(nextPos) - ar.getHeadingRadians();
        int dir = 1;
        if (Math.cos(angle) < 0.0) {
            angle += Math.PI;
            dir = -1;
        }
        angle = AbstractRobot.normalAngle(angle);
        ar.setAhead(AbstractRobot.myPos.distance(nextPos) * (double)dir);
        ar.setTurnRightRadians(angle);
        ar.setMaxVelocity(Math.abs(angle) > factor ? 0.0 : maxVelocity);
    }

    public Movement(AbstractRobot ar) {
        Movement.ar = ar;
    }
}

