package dam.util;

import java.util.Vector;
/**
 * BotMath.java
 * A class that provides a lot of reusable Math that is useful for bots.
 * 
 * @author David Mold
 *
 * Jun 27, 2002
 */
public class BotMath {
	
	public static double normaliseBearing(double ang) {
		if (ang > Math.PI)
			ang -= 2 * Math.PI;
		if (ang < -Math.PI)
			ang += 2 * Math.PI;
		return ang;
	}
	
	/**
	 * if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
	 */
	public static double normaliseHeading(double ang) {
		if (ang > 2 * Math.PI)
			ang -= 2 * Math.PI;
		if (ang < 0)
			ang += 2 * Math.PI;
		return ang;
	}
	
	public static double normaliseBearingDegrees(double ang) {
		if (ang > 180)
			ang -= 360;
		if (ang < -180)
			ang += 360;
		return ang;
	}
	
	/**
	 * returns the distance between two x,y coordinates
	 */
	public static double getRange(double x1, double y1, double x2, double y2) {
		double xo = x2 - x1;
		double yo = y2 - y1;
		return Math.sqrt(xo * xo + yo * yo);
	}
	
	/**
	 * gets the absolute bearing between to x,y coordinates
	 */
	public static double absbearing( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = BotMath.getRange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
		   return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 )
		{
		   return Math.PI - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 )
		{
		   return Math.PI + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 )
		{
		   return 2.0*Math.PI - Math.asin( -xo / h );
		}
		return 0;
	}
	
	public static int sign(double d)
	{
		if(d > 0) return 1;
		else if(d < 0) return -1;
		return 0;
	}
	
	/**
	* Take a vector of doubles, and provide a simple moving average for
	* the last depth items.
	*/
	protected static double getMovingAverage(Vector v, int depth)
	{
		int start = v.size() - depth;
	   if(start < 0) start = 0;
	   double tot = 0;
	   int ctr = 0;
	   for(int i = start; i < v.size(); i++)
	   {
	   	tot += ((Double)v.elementAt(i)).doubleValue();
			ctr++;
		}
	   return tot / ctr;
	}
	
	public static BotPoint getNextPosition(double x, double y, double heading, double speed, long timeDiff)
	{
		double newx = x + (Math.sin(heading) * speed * timeDiff);
		double newy = y + (Math.cos(heading) * speed * timeDiff);
		return new BotPoint(newx, newy);
	}

}
