// MyAgileRobot (C) 2006 Kim, Tae-gyoon
package stelo;


import robocode.*;
import java.awt.Color;

/**
 * 
 * 
 * This robot moves around in a crazy pattern
 */
public class MyAgileRobot extends AdvancedRobot {
	boolean movingForward;
	
	
	/**
	 * run: Crazy's main run function
	 */	
	public void run() {
		setColors(Color.red, Color.blue, Color.green);
		while (true) {
			setMaxVelocity(6);
			// Tell the game we will want to move ahead 40000 -- some large number
			setAhead(40000);
			movingForward = true;
			// Tell the game we will want to turn right 90
			setTurnRight(90);
			// At this point, we have indicated to the game that *when we do something*, 
			// we will want to move ahead and turn right.  That's what "set" means.
			// It is important to realize we have not done anything yet!
			// In order to actually move, we'll want to call a method that
			// takes real time, such as waitFor.
			// waitFor actually starts the action -- we start moving and turning.
			// It will not return until we have finished turning.
			waitFor(new TurnCompleteCondition(this));
			// Note:  We are still moving ahead now, but the turn is complete.
			// Now we'll turn the other way...
			setTurnLeft(180);
			// ... and wait for the turn to finish ...
			waitFor(new TurnCompleteCondition(this));
			// ... then the other way ...
			setTurnRight(180);
			// .. and wait for that turn to finish.
			waitFor(new TurnCompleteCondition(this));
			// then back to the top to do it all again
		}
	}
	
	/**
	 * onHitWall:  Handle collision with wall.
	 */	
	public void onHitWall(HitWallEvent e) {
		// Bounce off!
		reverseDirection();
	}
	
	/**
	 * reverseDirection: switch from ahead to back & vice versa
	 */	
	public void reverseDirection() {
		if (movingForward) {
			setBack(40000);
			movingForward = false;
		} else {
			setAhead(40000);
			movingForward = true;
		}
	}
	
	/**
	 * onScannedRobot:  Fire!
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bulletPower;
		bulletPower = Math.min(3.0, e.getEnergy());
		bulletPower = Math.min(bulletPower, getEnergy() / 8.0); // 1.72 ? 
				
		fire(bulletPower);
		setMaxVelocity(8);
		
		//if (getEnergy() > 50) {
			// charge!
			setTurnRight(0);
			// setBack(5); // stay out of harm's way.
		//}			
	}

	/**
	 * onHitRobot:  Back up!
	 */
	/*	
	public void onHitRobot(HitRobotEvent e) {
		// If we're moving the other robot, reverse!
		if (e.isMyFault()) {
			reverseDirection();
		}
	}
	*/
	
	
	/**
	 * onHitRobot:  Turn to face robot, fire hard, and ram him again!
	 */
	public void onHitRobot(HitRobotEvent e) {
		turnRight(e.getBearing());
		
		// Determine a shot that won't kill the robot...
		// We want to ram him instead for bonus points
		
		
		if (e.getEnergy() > 16) {
			fire(3);
		} else if (e.getEnergy() > 10) {
			fire(2);
		} else if (e.getEnergy() > 4) {
			fire(1);
		} else if (e.getEnergy() > 2) {
			fire(.5);
		} else if (e.getEnergy() > .4) {
			fire(.1);
		}
		
		
		ahead(40); // Ram him again!
	}
		
	/**
	 * We were hit!  Turn perpendicular to the bullet,
	 * so our seesaw might avoid a future shot.
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// turnLeft(90 - e.getBearing());
		//ahead(50);
		setMaxVelocity(8);
	}	
	
	
}		

				