package nat;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;

import nat.VCSBufferManager.SingleBuffer;
import nat.move.BHMove;
import nat.sGun.SamekhGun;
import robocode.*;
import robocode.util.Utils;

public class Samekh extends AdvancedRobot {
	public static boolean _MC = false, _TC = false, _MC2K7 = false;

	public static final int BINS = 121;
	
	public BHMove move;

	// VCS Buffers
	static ArrayList<VCSBufferManager.StatBuffer> surfStats, flatStats,
			nonFiringStats;

	// DC Buffers

	// NN Buffers

	// Extra layer
	static float[] hitGFFast = new float[BINS], hitGFUf = new float[BINS];
	static float[] visitGFFast = new float[BINS], visitGFUf = new float[BINS];

	// Bullet Power Tree
	static KdTree<Float> bulletPowerTree = new KdTree.SqrEuclid<Float>(3, null);

	// Point Location
	public Point2D _myLocation;
	public Point2D _enemyLocation;
	public Point2D _orbitLocation;

	// Wave Surfing
	public ArrayList<Wave> _enemyWaves;
	public ArrayList<Store> _surfData;
	public double enemyDistance;

	WeakHashMap<Wave, ArrayList<SingleBuffer>> wavesStats = new WeakHashMap<Wave, ArrayList<SingleBuffer>>();
	WeakHashMap<Wave, ArrayList<SingleBuffer>> wavesFlatStats = new WeakHashMap<Wave, ArrayList<SingleBuffer>>();
	WeakHashMap<Wave, ArrayList<SingleBuffer>> wavesNonFiringStats = new WeakHashMap<Wave, ArrayList<SingleBuffer>>();

	// Energy Drop Surfing
	public static double _oppEnergy = 100.0;

	// Wall Smoothing
	public static Rectangle2D.Double _fieldRect = null;
	public static double WALL_STICK = 160;
	public double _bfWidth, _bfHeight;

	// Dynamic Distancing
	public static double preferredDistance = 500d;
	public static double fearDistance = 80d;

	public static final double DANGER_FACTOR = 1.5d;
	public static final double DANGER_FACTOR_FEAR = 4d;

	// Enemy hit percent
	public static double enemyShotFire = 0;
	public static double enemyShotHit = 0;

	// Corner escaped mode
	boolean cornerEscapedMode = false;

	// Flattener status
	public static boolean flattener = false;

	// Simple Movement
	int simpleMoveDirection = 1;

	boolean firstScan = true;

	// Painting
	ArrayList<PredictionResult> paintingPosition = new ArrayList<PredictionResult>();

	ScannedRobotEvent lastSRE;

	// Gun
	SamekhGun _gun = null;
	RaikoGun _raikogun = null;

	static {
		M.init();
	}

	public void run() {
		String name = getName();

		if (name.endsWith("TC"))
			_MC = true;
		if (name.endsWith("MC"))
			_TC = true;
		if (name.endsWith("MC2K7"))
			_MC = _MC2K7 = true;

		// initialize buffer hit
		if (getRoundNum() == 0) {
			surfStats = VCSBufferManager.getStatBuffers();
			flatStats = VCSBufferManager.getFlattenerBuffers();
			nonFiringStats = VCSBufferManager.getStatBuffers();
			logBuffer(new Range(-0.1752, 0.1752),
					surfStats.get(0).stats[0][0][0][0][0][0][0][0][0], 0f);
			logBuffer(new Range(-0.1752, 0.1752), hitGFFast, 0f);
		}

		_gun = new SamekhGun(this);
		_raikogun = new RaikoGun(this);

		_enemyWaves = new ArrayList<Wave>();
		_surfData = new ArrayList<Store>();
		
		move = new BHMove(this);

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);

		_fieldRect = new java.awt.geom.Rectangle2D.Double(18, 18,
				(_bfWidth = getBattleFieldWidth()) - 36,
				(_bfHeight = getBattleFieldHeight()) - 36);

		setColors(Color.orange, Color.black, Color.yellow);

		do {
			if (getRadarTurnRemaining() == 0) {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			}
			if (getOthers() == 0)
				onScannedRobot(lastSRE);
			execute();
		} while (true);
	}

	public void log(String msg) {
		out.printf("%4d ".concat(msg), (int) getTime());
		out.println();
	}

	@SuppressWarnings("unchecked")
	public void onScannedRobot(ScannedRobotEvent e) {
		lastSRE = e;
		move.onScannedRobot(e);
	
		_myLocation = new Point2D.Double(getX(), getY());
//		if (getOthers() > 0) {
//			// /////////////////////////////////
//			// Wave Surfing
//			Store s = new Store();
//			Store last = null;
//			try {
//				last = _surfData.get(0);
//			} catch (Exception ignored) {
//			}
//
//			enemyDistance = e.getDistance();
//
//			double lateralVelocity = s.latvel = (float) ((s.vel = (float) getVelocity()) * Math
//					.sin(e.getBearingRadians()));
			double absBearing = /*s.absBearing =*/ (float) e.getBearingRadians()
					+ (float) getHeadingRadians();
//
//			s.x = getX();
//			s.y = getY();
//
//			s.bft = (float) e.getDistance();
//
//			s.advvel = (float) (getVelocity() * -Math
//					.cos(e.getBearingRadians()));
//
//			s.absBearing += Math.PI;
			setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing
					- getRadarHeadingRadians()) * 2);
//
//			s.dir = M.abs(getVelocity()) > 0.01 ? ((lateralVelocity >= 0) ? 1
//					: -1) : (last == null ? 1 : last.dir);
//
//			s.latvel = Math.abs(s.latvel);
//
//			if (last == null) {
//				s.accl = (float) getVelocity();
//				s.tsdc = s.tsvc = 0;
//			} else {
//				s.accl = (float) getVelocity() - last.vel;
//				s.tsdc = s.dir == last.dir ? last.tsdc + 1 : 0;
//				s.tsvc = M.isNear(s.vel, last.vel) ? last.tsvc + 1 : 0;
//			}
//
//			s.scanPosition = M
//					.project(_myLocation, absBearing, e.getDistance());
//
//			s.wallF = (float) wallDistance(getX(), getY(), e.getDistance(),
//					absBearing, s.dir);
//			s.wallB = (float) wallDistance(getX(), getY(), e.getDistance(),
//					absBearing, -s.dir);
//
//			if (_surfData.size() >= 10) {
//				s.dist10 = (float) s.distance(_surfData.get(9));
//			}
//
//			_surfData.add(0, s);
//
//			double bulletPower = _oppEnergy - e.getEnergy();
//			boolean isFiringWave = false;
//			if (bulletPower < 3.01 && bulletPower > 0.09
//					&& _surfData.size() > 2) {
//				// ew.advanceWave();
//				isFiringWave = true;
//				bulletPowerTree.addPoint(new double[] { getEnergy() / 100,
//						e.getEnergy() / 100, e.getDistance() / 1200 },
//						(float) bulletPower);
//				enemyShotFire++;
//			} else {
//				if (bulletPowerTree.size() == 0)
//					bulletPower = 2d;
//				else {
//					List<KdTree.Entry<Float>> result = bulletPowerTree
//							.nearestNeighbor(
//									new double[] { getEnergy() / 100,
//											e.getEnergy() / 100,
//											e.getDistance() / 1200 },
//									(int) Math.min(M.ceil(M
//											.sqrt(bulletPowerTree.size())),
//											100d), false);
//					float[] bpBins = new float[99];
//					Iterator<KdTree.Entry<Float>> it = result.iterator();
//
//					while (it.hasNext()) {
//						KdTree.Entry<Float> p = it.next();
//						double weight = 1 / (p.distance + 0.00000000000000000000001);
//
//						int index = (int) Math.round(p.value * bpBins.length
//								/ 3);
//
//						for (int i = 0; i < bpBins.length; i++)
//							bpBins[i] += weight / (M.sqr(index - i) / 9 + 1);
//					}
//
//					int maxIndex = 66;
//					for (int i = 0; i < bpBins.length; i++)
//						if (bpBins[i] > bpBins[maxIndex])
//							maxIndex = i;
//
//					bulletPower = maxIndex * 3.0 / bpBins.length;
//				}
//			}
//
//			if (_surfData.size() > 2) {
//				Store a = _surfData.get(2);
//				Wave ew = new Wave(bulletPower, a, getTime() - 1, false);
//				_enemyWaves.add(ew);
//
//				s.bft /= ew.bulletVelocity;
//				s.tsdc /= s.bft;
//				s.tsvc /= s.bft;
//				ew.fireLocation = _enemyLocation;
//				ew.isFiringWave = isFiringWave;
//
//				if (isFiringWave) {
//					ArrayList<SingleBuffer>[] buffers = VCSBufferManager
//							.getStats(a.latvel, a.advvel, a.bft, a.tsdc,
//									a.accl, a.tsvc, a.dist10, a.wallF, a.wallB,
//									surfStats, flatStats, nonFiringStats);
//					wavesStats.put(ew, buffers[0]);
//					wavesFlatStats.put(ew, buffers[1]);
//					wavesNonFiringStats.put(ew, buffers[2]);
//				} else {
//					ArrayList<SingleBuffer>[] buffers = VCSBufferManager
//							.getStats(a.latvel, a.advvel, a.bft, a.tsdc,
//									a.accl, a.tsvc, a.dist10, a.wallF, a.wallB,
//									nonFiringStats);
//					wavesNonFiringStats.put(ew, buffers[0]);
//				}
//			}
//
//			_oppEnergy = e.getEnergy();
//			_enemyLocation = s.scanPosition;
//
//			checkFlattener();
//		}
//
//		updateWaves();
//		doSurfing();
		// //////////////////////////////////////////////////*/
		_enemyLocation = M.project(_myLocation, absBearing, e.getDistance());

		if (getOthers() != 0) {
			if (_MC2K7)
				_raikogun.onScannedRobot(e);
			if (!_MC)
				_gun.onScannedRobot(e);
		}
	}

	public void onHitRobot(HitRobotEvent e) {
		/*
		log("INFO: Hit Robot");
		_oppEnergy -= 0.6;
		*/
		move.onHitRobot(e);
	}

	public void onHitByBullet(HitByBulletEvent e) {
		move.onHitByBullet(e);
		/*
		_oppEnergy += M.getHitRegneration(e.getBullet().getPower());
		Point2D bulletLocation = new Point2D.Double(e.getBullet().getX(), e
				.getBullet().getY());
		Wave wave = getFiringWaveAt(bulletLocation);
		if (wave == null) {
			log("ERROR: Bullet hit on non-existant wave!");
		} else {
			wave.isHit = true;
			wave.bulletLocation = bulletLocation;
		}
		enemyShotHit++; */
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		move.onBulletHitBullet(e);
//		Point2D bulletLocation = new Point2D.Double(e.getBullet().getX(), e
//				.getBullet().getY());
//		Wave wave = getFiringWaveAt(bulletLocation);
//		if (wave == null) {
//			log("ERROR: Bullet hit on non-existant wave!");
//		} else {
//			wave.bulletHitBullet = true;
//			wave.bulletLocation = bulletLocation;
//		}
//		enemyShotFire--;
//		// _gun.onBulletHitBullet(e);
	}

	public void onBulletHit(BulletHitEvent e) {
		move.onBulletHit(e);
//		_oppEnergy -= M.getBulletDamage(e.getBullet().getPower());
		// _gun.onBulletHit(e);
	}

	public void onHitWall(HitWallEvent e) {
//		log("WARNING: Hit wall!");
	}

	public void checkFlattener() {
		if (getRoundNum() > 2 && getHP() > 0.1) {
			if (!flattener) {
				flattener = true;
				log("INFO: Curve Flattening Enabled.");
			}
		} else {
			if (flattener) {
				flattener = false;
				log("INFO: Curve Flattening Disabled.");
			}
		}
	}

	public void updateWaves() {
		for (int i = 0; i < _enemyWaves.size(); i++) {
			Wave wave = _enemyWaves.get(i);

			wave.update(_myLocation);
			updateWaveStats(wave);

			if (wave.status == Wave.PASSED) {
				if (getOthers() > 0) {
					if (wave.isHit || wave.bulletHitBullet) {
						double hitGF = wave.getGuessFactor(M.getAngle(
								wave.fireLocation, wave.bulletLocation));
						Range hr = new Range(hitGF - 0.175, hitGF + 0.175);
						logHit(wave, hr);
					}
					if (wave.isFiringWave) {
						this.logFlat(wave, wave.hitRange);
					}
					this.logNonFiring(wave, wave.hitRange);
				}
				_enemyWaves.remove(i--);
			}
		}
	}

	public void updateWaveStats(Wave ew) {
		if (ew.isFiringWave) {
			ew.paintBucket = new float[BINS];
			
			float[] surfS = new float[BINS], surfF = new float[BINS], surfNF = new float[BINS];
			VCSBufferManager.sumBuffer(wavesStats.get(ew), surfS, false);
			VCSBufferManager.sumBuffer(wavesFlatStats.get(ew), surfF, false);
			VCSBufferManager.sumBuffer(wavesNonFiringStats.get(ew), surfNF, false);
			
			float[] weight = new float[] { 1f, 0.125f, 0f, 1f, .75f, .0f,
					0f };
			if (flattener) {
				weight = new float[] { 1f, 1f, .8f, 1f, .8f, .1f,
						.8f };
			}
			ArrayUtils.sum(ew.paintBucket, weight, surfS, surfF, surfNF,
					hitGFFast, hitGFUf, visitGFFast, visitGFFast);

		}
	}

	public Wave getFiringWaveAt(Point2D pt) {
		Wave foundWave = null;
		for (Wave w : _enemyWaves) {
			if (w.isFiringWave
					&& M.abs(w.distanceTraveled - w.fireLocation.distance(pt)) < 40) {
				foundWave = w;
				break;
			}
		}
		return foundWave;
	}

	public Wave[] getFurthestWaves() {
		Wave[] w = new Wave[_enemyWaves.size()];
		w = _enemyWaves.toArray(new Wave[0]);

		// insertion sort
		int i = 0;
		for (Wave current : _enemyWaves) {
			if (current.isFiringWave && current.status != Wave.PASSED
					&& !(current.isHit || current.bulletHitBullet)) {
				int j = i - 1;
				while (j >= 0
						&& current.distanceTraveled > w[j].distanceTraveled) {
					w[j + 1] = w[j];
					j--;
				}
				w[j + 1] = current;
				i++;
			}
		}

		Wave[] result = new Wave[i];
		for (int k = 0; k < i; k++) {
			result[k] = w[k];
		}

		return result;
	}

	public void logHit(Wave ew, Range hitRange) {
		float[] temp = BinUtils.makeSmoothedBins(
				VCSBufferManager.StatBuffer.BINS, hitRange);
		ArrayList<SingleBuffer> buff = wavesStats.get(ew);
		if (buff == null)
			log("ERROR: Waves stats mysteriously lost!");
		else
			VCSBufferManager.registerHit(buff, temp);
		logBuffer(hitRange, hitGFFast, 0.2f);
		logBuffer(hitRange, hitGFUf, 0.05f);
	}

	public void logFlat(Wave ew, Range hitRange) {
		float[] temp = BinUtils.makeSmoothedBins(
				VCSBufferManager.StatBuffer.BINS, hitRange);
		ArrayList<SingleBuffer> buff = wavesFlatStats.get(ew);
		if (buff == null)
			log("ERROR: Waves stats mysteriously lost!");
		else
			VCSBufferManager.registerHit(buff, temp);
		logBuffer(hitRange, visitGFFast, 0.2f);
		logBuffer(hitRange, visitGFUf, 0.05f);
	}

	public void logNonFiring(Wave ew, Range hitRange) {
		float[] temp = BinUtils.makeSmoothedBins(
				VCSBufferManager.StatBuffer.BINS, hitRange);
		ArrayList<SingleBuffer> buff = wavesNonFiringStats.get(ew);
		if (buff == null)
			log("ERROR: Waves stats mysteriously lost!");
		else
			VCSBufferManager.registerHit(buff, temp);
	}

	public void logBuffer(Range hitRange, float[] buffer, float r) {
		float[] a = BinUtils.makeSmoothedBins(VCSBufferManager.StatBuffer.BINS,
				hitRange);
		for (int i = 0; i < buffer.length; i++) {
			buffer[i] = ((buffer[i] * r + a[i]) / (r + 1f));
		}
	}

	private final static class PredictionResult {
		List<Point2D> points = new ArrayList<Point2D>();
		Range resultHitRange;
	}

	public PredictionResult predictPosition(Wave surfWave, int direction) {
		MovementPredictor.PredictionStatus predictedPosition = new MovementPredictor.PredictionStatus(
				getX(), getY(), getHeadingRadians(), getVelocity(), getTime());
		Wave simulator = surfWave.clone();
		PredictionResult result = new PredictionResult();
		double maxV = direction == 0 ? 0d : 8d;
		if (direction == 0)
			direction = 1;

		do {
			double angleOffset = getDistanceControlledAngleOffset(predictedPosition
					.distance(_orbitLocation));

			double moveAngle = wallSmoothing(predictedPosition, M.getAngle(
					_enemyLocation, predictedPosition)
					+ (direction * angleOffset), direction, 1);

			predictedPosition = MovementPredictor.predict(predictedPosition,
					moveAngle, maxV, Double.POSITIVE_INFINITY, _fieldRect);
			result.points.add(predictedPosition);
			simulator.update(predictedPosition);
		} while (simulator.status != Wave.PASSED);

		result.resultHitRange = simulator.hitRange;
		return result;
	}

	public double checkDanger(Wave[] wave, int dir) {
		PredictionResult result = predictPosition(wave[0], dir);

		if (dir != 0)
			paintingPosition.add(result);

		double waveDanger = BinUtils.getTotalInRect(wave[0].paintBucket,
				result.resultHitRange)
				/ result.resultHitRange.getSize();
		
		double hitAngle = wave[0].getAngle(result.resultHitRange.getMean());
		double otherWavesDanger = 0;
		for (Wave w : wave) {
			otherWavesDanger += w.paintBucket[(int) M.limit(0,M.round(w.getGuessFactor(hitAngle) * (BINS/2) - (BINS/2)),BINS)];
		}

		Point2D lastPoint = result.points.get(result.points.size() - 1);
		double dangerMultipiler = M.min(lastPoint.distance(wave[0].fireLocation),
				lastPoint.distance(_enemyLocation));

		if (enemyDistance < fearDistance) {
			dangerMultipiler = M.pow(dangerMultipiler, DANGER_FACTOR_FEAR);
		} else {
			dangerMultipiler = M.pow(dangerMultipiler, DANGER_FACTOR);
		}

		dangerMultipiler = 1 / dangerMultipiler;

		return (waveDanger) * dangerMultipiler;
	}

	public void doSurfing() {
		paintingPosition.clear();
		Wave[] surfWaves = getFurthestWaves();

		if (surfWaves.length > 0)
			_orbitLocation = surfWaves[0].fireLocation;
		else
			_orbitLocation = _enemyLocation;

		double goAngle = M.getAngle(_orbitLocation, _myLocation);

		if (surfWaves == null || surfWaves.length == 0) {
			// No waves
			goAngle = wallSmoothing(
					_myLocation,
					goAngle
							+ (simpleMoveDirection * getDistanceControlledAngleOffset(enemyDistance)),
					simpleMoveDirection, 1);
			if (Math.random() > 0.92
					|| M.project(_myLocation, goAngle, WALL_STICK).distance(
							_enemyLocation) < WALL_STICK) {
				simpleMoveDirection = -simpleMoveDirection;
				goAngle = wallSmoothing(
						_myLocation,
						goAngle
								+ (simpleMoveDirection * getDistanceControlledAngleOffset(enemyDistance)),
						simpleMoveDirection, 1);
			}
			setBackAsFront(this, goAngle);
		} else {
			double dangerLeft = checkDanger(surfWaves, -1);
			double dangerRight = checkDanger(surfWaves, 1);
			double dangerStop = checkDanger(surfWaves, 0);

			double distanceOffset = getDistanceControlledAngleOffset(_myLocation
					.distance(_enemyLocation));

			// goAngle = M.getAngle(surfWaves[0].fireLocation, _myLocation);
			goAngle = M.getAngle(_orbitLocation, _myLocation);

			double goAngleLeft = goAngle - distanceOffset;
			double goAngleLeftSmoothed = wallSmoothing(_myLocation,
					goAngleLeft, -1, 1);

			double goAngleRight = goAngle + distanceOffset;
			double goAngleRightSmoothed = wallSmoothing(_myLocation,
					goAngleRight, 1, 1);

			double maxAngle = Math.PI / 6;
			boolean secondTime = false;
			while (true) {
				if (dangerLeft < dangerRight
						&& M.normalRelativeAngle(goAngleLeft
								- goAngleLeftSmoothed) < maxAngle) {
					goAngle = goAngleLeftSmoothed;
					if (!secondTime)
						disableCornerEscaped();
					break;
				} else if (M.normalRelativeAngle(goAngleRight
						- goAngleRightSmoothed) < maxAngle) {
					goAngle = goAngleRightSmoothed;
					if (!secondTime)
						disableCornerEscaped();
					break;
				} else {
					maxAngle = Math.PI / 3;
					enabledEscapedMode();
					if (secondTime) {
						log("INFO: Corner escaping fail.");
						maxAngle = Double.POSITIVE_INFINITY;
					}
					secondTime = true;
				}
			}

			if (dangerStop <= dangerLeft && dangerStop <= dangerRight) {
				setMaxVelocity(0);
			} else {
				setMaxVelocity(8);
			}

			setBackAsFront(this, goAngle);
		}
	}

	final void disableCornerEscaped() {
		if (cornerEscapedMode) {
			cornerEscapedMode = false;
			log("INFO: Corner Escape Mode disabled");
		}
	}

	final void enabledEscapedMode() {
		if (!cornerEscapedMode) {
			cornerEscapedMode = true;
			log("WARNING: Corner Escaped Mode Enabled; prediction might not be accurate.");
		}
	}

	final double getDistanceControlledAngleOffset(double currentDistance) {
		// double distanceOffset = currentDistance - preferredDistance;
		// return M.limit(-M.QUARTER_PI, 3 * M.sqr(distanceOffset
		// / preferredDistance), -M.QUARTER_PI)
		// + Math.PI / 2;
		return Math.PI / 2 - 1
				+ M.limit(50, currentDistance, preferredDistance)
				/ preferredDistance;
	}

	final double wallSmoothing(Point2D pt, double angle, int orientation,
			int smoothTowardEnemy) {
		return smooth(pt.getX(), pt.getY(), angle, orientation);
		// double x = pt.getX(), y = pt.getY();
		//
		// // in Java, (-3 MOD 4) is not 1, so make sure we have some excess
		// // positivity here
		// angle += (4 * Math.PI);
		//
		// double testX = x + (Math.sin(angle) * WALL_STICK);
		// double testY = y + (Math.cos(angle) * WALL_STICK);
		// double wallDistanceX = Math.min(x - 18, _bfWidth - x - 18);
		// double wallDistanceY = Math.min(y - 18, _bfHeight - y - 18);
		// double testDistanceX = Math.min(testX - 18, _bfWidth - testX - 18);
		// double testDistanceY = Math.min(testY - 18, _bfHeight - testY - 18);
		//
		// double adjacent = 0;
		// int g = 0; // because I'm paranoid about potential infinite loops
		//
		// while (!_fieldRect.contains(testX, testY) && g++ < 25) {
		// if (testDistanceY < 0 && testDistanceY < testDistanceX) {
		// // wall smooth North or South wall
		// angle = ((int) ((angle + (Math.PI / 2)) / Math.PI)) * Math.PI;
		// adjacent = Math.abs(wallDistanceY);
		// } else if (testDistanceX < 0 && testDistanceX <= testDistanceY) {
		// // wall smooth East or West wall
		// angle = (((int) (angle / Math.PI)) * Math.PI) + (Math.PI / 2);
		// adjacent = Math.abs(wallDistanceX);
		// }
		//
		// // use your own equivalent of (1 / POSITIVE_INFINITY) instead of
		// // 0.005 if you
		// // want to stay closer to the wall ;)
		// angle += smoothTowardEnemy * orientation
		// * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005);
		//
		// testX = x + (Math.sin(angle) * WALL_STICK);
		// testY = y + (Math.cos(angle) * WALL_STICK);
		// testDistanceX = Math.min(testX - 18, _bfWidth - testX - 18);
		// testDistanceY = Math.min(testY - 18, _bfHeight - testY - 18);
		//
		// if (smoothTowardEnemy == -1) {
		// // this method ended with tank smoothing away from enemy... you
		// // may need to
		// // note that globally, or maybe you don't care.
		// }
		// }
		//
		// return M.normalAbsoluteAngle(angle);
	}

	public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
		if (_TC)
			return;
		double angle = Utils.normalRelativeAngle(goAngle
				- robot.getHeadingRadians());
		if (Math.abs(angle) > (Math.PI / 2)) {
			if (angle < 0) {
				robot.setTurnRightRadians(Math.PI + angle);
			} else {
				robot.setTurnLeftRadians(Math.PI - angle);
			}
			robot.setBack(100);
		} else {
			if (angle < 0) {
				robot.setTurnLeftRadians(-1 * angle);
			} else {
				robot.setTurnRightRadians(angle);
			}
			robot.setAhead(100);
		}
	}

	double getHP() {
		return enemyShotHit / enemyShotFire;
	}

	public void onPaint(java.awt.Graphics2D g) {
//		// Set font
//		g.setFont(new Font("Dialog", Font.PLAIN, 11));
//
//		// Draw enemy waves
//		for (Wave w : _enemyWaves) {
//			if (w.isFiringWave && !w.bulletHitBullet && !w.isHit)
//				WavePainter.paint(g, w);
//		}
//
//		// Draw Precise Prediction
//		g.setColor(Color.pink);
//		for (PredictionResult r : paintingPosition) {
//			for (Point2D pt : r.points) {
//				g.fillOval((int) pt.getX() - 2, (int) pt.getY() - 2, 4, 4);
//			}
//		}
//
//		g.setColor(Color.lightGray);
//		if (_myLocation != null)
//			g.draw(new Rectangle2D.Double(_myLocation.getX() - 18, _myLocation
//					.getY() - 18, 36, 36));
//
//		if (_enemyLocation != null)
//			g.draw(new Rectangle2D.Double(_enemyLocation.getX() - 18,
//					_enemyLocation.getY() - 18, 36, 36));
//
//		NumberFormat nf = NumberFormat.getNumberInstance();
//		nf.setMaximumFractionDigits(2);
//		nf.setMinimumFractionDigits(2);
//		nf.setMaximumIntegerDigits(4);
//		nf.setMinimumIntegerDigits(4);
//
//		g.setColor(Color.WHITE);
//		g.drawString("Distance: ".concat(
//				String.valueOf(nf.format(enemyDistance))).concat(" (").concat(
//				nf.format(preferredDistance)).concat(") ").concat(
//				" Enemy hitrate: ").concat(
//				String.valueOf(nf.format(getHP() * 100))).concat("%"), 10, 10);
		move.onPaint(g);
		_gun.onPaint(g);
	}

	static double HALF_PI = Math.PI / 2;
	static double WALKING_STICK = WALL_STICK;
	static double WALL_MARGIN = 19;
	static double S = WALL_MARGIN;
	static double W = WALL_MARGIN;
	static double N = 600 - WALL_MARGIN;
	static double E = 800 - WALL_MARGIN;

	// eDist = the distance from you to the enemy
	// eAngle = the absolute angle from you to the enemy
	// oDir = 1 for the clockwise orbit distance
	// -1 for the counter-clockwise orbit distance
	// returns: the positive orbital distance (in radians) the enemy can travel
	// before hitting a wall (possibly infinity).
	public double wallDistance(double x, double y, double eDist, double eAngle,
			int oDir) {
		return Math.min(Math.min(Math.min(distanceWest(N - y, eDist, eAngle
				- HALF_PI, oDir), distanceWest(E - x, eDist, eAngle + Math.PI,
				oDir)), distanceWest(6 - S, eDist, eAngle + HALF_PI, oDir)),
				distanceWest(x - W, eDist, eAngle, oDir));
	}

	double distanceWest(double toWall, double eDist, double eAngle, int oDir) {
		if (eDist <= toWall) {
			return Double.POSITIVE_INFINITY;
		}
		double wallAngle = Math.acos(-oDir * toWall / eDist) + oDir * HALF_PI;
		return Utils.normalAbsoluteAngle(oDir * (wallAngle - eAngle));
	}

	double smooth(double x, double y, double angle, int oDir) {
		angle = smoothWest(N - y, angle - HALF_PI, oDir) + HALF_PI;
		angle = smoothWest(E - x, angle + Math.PI, oDir) - Math.PI;
		angle = smoothWest(y - S, angle + HALF_PI, oDir) - HALF_PI;
		angle = smoothWest(x - W, angle, oDir);

		// for bots that could calculate an angle that is pointing pretty far
		// into a corner, these three lines may be necessary when travelling
		// counter-clockwise (since the smoothing above may have moved the
		// walking stick into another wall)
		angle = smoothWest(y - S, angle + HALF_PI, oDir) - HALF_PI;
		angle = smoothWest(E - x, angle + Math.PI, oDir) - Math.PI;
		angle = smoothWest(N - y, angle - HALF_PI, oDir) + HALF_PI;

		return angle;
	}

	// smooths agains the west wall
	double smoothWest(double dist, double angle, int oDir) {
		if (dist < -WALKING_STICK * M.sin(angle)) {
			return M.acos(oDir * dist / WALKING_STICK) - oDir * HALF_PI;
		}
		return angle;
	}
}
