package tobe.guns;
import tobe.platform.*;
import tobe.statistics.*;
import tobe.util.*;
import robocode.*;

/** Sniper is a pattern-matcher
 * Thanks to graygoo and Wolverine for good ideas
 */
public class Sniper implements Gun {

	public Aim aim(CommandCentre cc) {
		AdvancedRobot bot = cc.getBot();
		double x = bot.getX();
		double y = bot.getY();
		TargetStatistics t = cc.getPreferredTarget();
		if(t == null) return null;
			double shotPower = Math.min(3,bot.getEnergy()-5.0);
			if(shotPower < 0.5) shotPower = Math.min(0.5, bot.getEnergy()-0.1);
	/*testing*/		shotPower = (t.getDistance(bot.getX(), bot.getY()) < 500 ? shotPower : Math.min(0.1, shotPower));
		double bulletVelocity = (20-3*shotPower);
		t.getPosition(pos);
		pos.changeOrigin(x,y);
		double timeToHit = pos.getDistance()/bulletVelocity;
		CircularArray deltas = t.getDeltas();
		if(deltas.size() < weight.length+timeToHit+1) return null;
		int match = 0;
		double score = 99999;
		for(int i = (int) -timeToHit; /*score > 3 && */i > -deltas.size()+weight.length; i--) {
		  double s = 0;
		  for(int j = -weight.length; j < 0 ; j++) {
		    s+=weight[weight.length+j]*((Delta) deltas.get(j)).closeness((Delta) deltas.get(i+j));
		  }
		  if(!((Delta) deltas.get(i)).fired) s += 1;//not too good if I did not fire here
		  if( s < score ) {
		    match = i;
		    score = s;
		  }
		}
		if(score > 5) return null;
		t.getPosition(pos);
		pos.changeOrigin(x,y);
		t.getMovement(mov);
		double bulletTravel = 0;
		for(int i = 0; bulletTravel < pos.getDistance() && i < (int) timeToHit; i++) {
		  ((Delta) deltas.get(match+i)).applyTo(pos,mov);
		  bulletTravel += bulletVelocity;
		}
			double m = bot.getWidth()*0.8;
			double h = cc.getPlayingField().getHeight();
			double w = cc.getPlayingField().getWidth();
			double xb = Math.min(w-m,Math.max(m,pos.getToX()));
			double yb = Math.min(h-m,Math.max(m,pos.getToY()));
			pos.setPoints(xb,yb,x,y);
		return new Aim(pos.getBearing(), Math.atan(bot.getWidth()/2/pos.getDistance()), shotPower);
	}
	
	public void reset() {
	}
	
	private BearingVector pos = new BearingVector();
	private BearingVector mov = new BearingVector();
	//private double[] weight = {1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,8};
	private double[] weight = {1,1,2,3,5,8,13};
}
